/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.interceptors;

import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.trust.DefaultSTSTokenCacher;
import org.apache.cxf.ws.security.trust.STSAuthParams;
import org.apache.cxf.ws.security.trust.STSClient;
import org.apache.cxf.ws.security.trust.STSTokenCacher;
import org.apache.cxf.ws.security.trust.STSTokenRetriever;
import org.apache.cxf.ws.security.trust.STSUtils;

public class STSTokenOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(STSTokenOutInterceptor.class);
    private STSClient stsClient;
    private STSTokenRetriever.TokenRequestParams tokenParams;
    private STSTokenCacher tokenCacher = new DefaultSTSTokenCacher();

    public STSTokenOutInterceptor(STSAuthParams authParams, String stsWsdlLocation, Bus bus) {
        this("prepare-send", authParams, stsWsdlLocation, bus);
    }

    public STSTokenOutInterceptor(String phase, STSAuthParams authParams, String stsWsdlLocation, Bus bus) {
        super(phase);
        this.stsClient = STSUtils.createSTSClient(authParams, stsWsdlLocation, bus);
        this.tokenParams = new STSTokenRetriever.TokenRequestParams();
    }

    public STSTokenOutInterceptor(STSClient stsClient) {
        this("prepare-send", stsClient, new STSTokenRetriever.TokenRequestParams());
    }

    public STSTokenOutInterceptor(STSClient stsClient, STSTokenRetriever.TokenRequestParams tokenParams) {
        this("prepare-send", stsClient, tokenParams);
    }

    public STSTokenOutInterceptor(String phase, STSClient stsClient, STSTokenRetriever.TokenRequestParams tokenParams) {
        super(phase);
        this.stsClient = stsClient;
        this.tokenParams = tokenParams;
    }

    public void handleMessage(Message message) throws Fault {
        SecurityToken tok;
        if (this.stsClient != null) {
            message.put((Object)"security.sts.client", (Object)this.stsClient);
        }
        if ((tok = STSTokenRetriever.getToken(message, this.tokenParams, this.tokenCacher)) == null) {
            LOG.warning("Security token was not retrieved from STS");
        }
        this.processToken(message, tok);
    }

    protected void processToken(Message message, SecurityToken tok) {
    }

    public STSClient getSTSClient() {
        return this.stsClient;
    }

    public STSTokenCacher getTokenCacher() {
        return this.tokenCacher;
    }

    public void setTokenCacher(STSTokenCacher tokenCacher) {
        this.tokenCacher = tokenCacher;
    }
}

