/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.LinkedHashSet;
import java.util.Properties;
import org.apache.openejb.client.ClientRuntimeException;
import org.apache.openejb.client.proxy.InvocationHandler;
import org.apache.openejb.client.proxy.Jdk13InvocationHandler;
import org.apache.openejb.client.proxy.ProxyFactory;

public class Jdk13ProxyFactory
implements ProxyFactory {
    private final Class[] constructorParams = new Class[]{java.lang.reflect.InvocationHandler.class};

    @Override
    public void init(Properties props) {
        String version = "";
        String badVersion = "1.3.0-";
        try {
            version = System.getProperty("java.vm.version");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (version.contains("1.3.0-")) {
            String message = "INCOMPATIBLE VM: \n\nThe Java Virtual Machine you are using contains a bug\nin the proxy generation logic.  This bug has been    \ndocumented by Sun and has been fixed in later VMs.   \nPlease download the latest 1.3 Virtual Machine.      \nFor more details see:                                \nhttp://developer.java.sun.com/developer/bugParade/bugs/4346224.html\n  ";
            throw new ClientRuntimeException("INCOMPATIBLE VM: \n\nThe Java Virtual Machine you are using contains a bug\nin the proxy generation logic.  This bug has been    \ndocumented by Sun and has been fixed in later VMs.   \nPlease download the latest 1.3 Virtual Machine.      \nFor more details see:                                \nhttp://developer.java.sun.com/developer/bugParade/bugs/4346224.html\n  ");
        }
    }

    @Override
    public InvocationHandler getInvocationHandler(Object proxy) throws IllegalArgumentException {
        Jdk13InvocationHandler handler = (Jdk13InvocationHandler)Proxy.getInvocationHandler(proxy);
        if (handler == null) {
            return null;
        }
        return handler.getInvocationHandler();
    }

    @Override
    public Object setInvocationHandler(Object proxy, InvocationHandler handler) throws IllegalArgumentException {
        Jdk13InvocationHandler jdk13 = (Jdk13InvocationHandler)Proxy.getInvocationHandler(proxy);
        if (jdk13 == null) {
            throw new IllegalArgumentException("Proxy " + String.valueOf(proxy) + " unknown!");
        }
        return jdk13.setInvocationHandler(handler);
    }

    @Override
    public Class getProxyClass(Class interfce) throws IllegalArgumentException {
        return Proxy.getProxyClass(interfce.getClassLoader(), interfce);
    }

    @Override
    public Class getProxyClass(Class[] interfaces) throws IllegalArgumentException {
        if (interfaces.length < 1) {
            throw new IllegalArgumentException("There must be at least one interface to implement.");
        }
        return Proxy.getProxyClass(interfaces[0].getClassLoader(), interfaces);
    }

    @Override
    public boolean isProxyClass(Class cl) {
        return Proxy.isProxyClass(cl);
    }

    @Override
    public Object newProxyInstance(Class proxyClass) throws IllegalArgumentException {
        if (!Proxy.isProxyClass(proxyClass)) {
            throw new IllegalArgumentException("This class is not a proxy.");
        }
        try {
            Constructor cons = proxyClass.getConstructor(this.constructorParams);
            return cons.newInstance(new Jdk13InvocationHandler());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new InternalError(e.toString());
        }
    }

    @Override
    public Object newProxyInstance(Class interfce, InvocationHandler h) throws IllegalArgumentException {
        Jdk13InvocationHandler handler = new Jdk13InvocationHandler(h);
        return Proxy.newProxyInstance(interfce.getClassLoader(), new Class[]{interfce}, (java.lang.reflect.InvocationHandler)handler);
    }

    @Override
    public Object newProxyInstance(Class[] interfaces, InvocationHandler h) throws IllegalArgumentException {
        if (interfaces.length < 1) {
            throw new IllegalArgumentException("There must be at least one interface to implement.");
        }
        Jdk13InvocationHandler handler = new Jdk13InvocationHandler(h);
        try {
            return Proxy.newProxyInstance(interfaces[0].getClassLoader(), interfaces, (java.lang.reflect.InvocationHandler)handler);
        }
        catch (IllegalArgumentException iae) {
            ClassLoader reconciliatedCl = Jdk13ProxyFactory.reconciliate(interfaces);
            try {
                reconciliatedCl.loadClass(interfaces[0].getName());
                return Proxy.newProxyInstance(reconciliatedCl, interfaces, (java.lang.reflect.InvocationHandler)handler);
            }
            catch (ClassNotFoundException e2) {
                throw iae;
            }
        }
    }

    private static ClassLoader reconciliate(Class<?> ... interfaces) {
        LinkedHashSet<ClassLoader> classloaders = new LinkedHashSet<ClassLoader>();
        for (Class<?> clazz : interfaces) {
            classloaders.add(clazz.getClassLoader());
        }
        return new MultipleClassLoadersClassLoader(classloaders.toArray(new ClassLoader[classloaders.size()]));
    }

    private static class MultipleClassLoadersClassLoader
    extends ClassLoader {
        private ClassLoader[] delegatingClassloaders;

        public MultipleClassLoadersClassLoader(ClassLoader[] classLoaders) {
            super(classLoaders[0]);
            this.delegatingClassloaders = classLoaders;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            ClassNotFoundException ex = null;
            for (ClassLoader cl : this.delegatingClassloaders) {
                try {
                    return cl.loadClass(name);
                }
                catch (ClassNotFoundException cnfe) {
                    if (ex != null) continue;
                    ex = cnfe;
                }
            }
            throw ex;
        }
    }
}

