/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.CapturedHttpHeadersUtil;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpStatusCodeConverter;
import io.opentelemetry.instrumentation.api.instrumenter.http.internal.HttpAttributes;
import io.opentelemetry.instrumentation.api.instrumenter.network.NetworkAttributesGetter;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.semconv.SemanticAttributes;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;

abstract class HttpCommonAttributesExtractor<REQUEST, RESPONSE, GETTER extends HttpCommonAttributesGetter<REQUEST, RESPONSE>>
implements AttributesExtractor<REQUEST, RESPONSE> {
    final GETTER getter;
    final NetworkAttributesGetter<REQUEST, RESPONSE> networkGetter;
    private final HttpStatusCodeConverter statusCodeConverter;
    private final List<String> capturedRequestHeaders;
    private final List<String> capturedResponseHeaders;
    private final Set<String> knownMethods;

    HttpCommonAttributesExtractor(GETTER getter, NetworkAttributesGetter<REQUEST, RESPONSE> networkGetter, HttpStatusCodeConverter statusCodeConverter, List<String> capturedRequestHeaders, List<String> capturedResponseHeaders, Set<String> knownMethods) {
        this.getter = getter;
        this.networkGetter = networkGetter;
        this.statusCodeConverter = statusCodeConverter;
        this.capturedRequestHeaders = CapturedHttpHeadersUtil.lowercase(capturedRequestHeaders);
        this.capturedResponseHeaders = CapturedHttpHeadersUtil.lowercase(capturedResponseHeaders);
        this.knownMethods = new HashSet<String>(knownMethods);
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        String method = this.getter.getHttpRequestMethod(request);
        if (SemconvStability.emitStableHttpSemconv()) {
            if (method == null || this.knownMethods.contains(method)) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_REQUEST_METHOD, (Object)method);
            } else {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_REQUEST_METHOD, (Object)"_OTHER");
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_REQUEST_METHOD_ORIGINAL, (Object)method);
            }
        }
        if (SemconvStability.emitOldHttpSemconv()) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_METHOD, (Object)method);
        }
        for (String name : this.capturedRequestHeaders) {
            List<String> values = this.getter.getHttpRequestHeader(request, name);
            if (values.isEmpty()) continue;
            if (SemconvStability.emitOldHttpSemconv()) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, CapturedHttpHeadersUtil.oldSemconvRequestAttributeKey(name), values);
            }
            if (!SemconvStability.emitStableHttpSemconv()) continue;
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, CapturedHttpHeadersUtil.stableSemconvRequestAttributeKey(name), values);
        }
    }

    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        Long requestBodySize = this.requestBodySize(request);
        if (SemconvStability.emitOldHttpSemconv()) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_REQUEST_CONTENT_LENGTH, (Object)requestBodySize);
        }
        Integer statusCode = null;
        if (response != null) {
            statusCode = this.getter.getHttpResponseStatusCode(request, response, error);
            if (statusCode != null && statusCode > 0) {
                if (SemconvStability.emitStableHttpSemconv()) {
                    AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_RESPONSE_STATUS_CODE, (Object)statusCode);
                }
                if (SemconvStability.emitOldHttpSemconv()) {
                    AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_STATUS_CODE, (Object)statusCode);
                }
            }
            Long responseBodySize = this.responseBodySize(request, response);
            if (SemconvStability.emitOldHttpSemconv()) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_RESPONSE_CONTENT_LENGTH, (Object)responseBodySize);
            }
            for (String name : this.capturedResponseHeaders) {
                List<String> values = this.getter.getHttpResponseHeader(request, response, name);
                if (values.isEmpty()) continue;
                if (SemconvStability.emitOldHttpSemconv()) {
                    AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, CapturedHttpHeadersUtil.oldSemconvResponseAttributeKey(name), values);
                }
                if (!SemconvStability.emitStableHttpSemconv()) continue;
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, CapturedHttpHeadersUtil.stableSemconvResponseAttributeKey(name), values);
            }
        }
        if (SemconvStability.emitStableHttpSemconv()) {
            String errorType = null;
            if (statusCode != null && statusCode > 0) {
                if (this.statusCodeConverter.isError(statusCode)) {
                    errorType = statusCode.toString();
                }
            } else {
                errorType = this.getter.getErrorType(request, response, error);
                if (errorType == null && error != null) {
                    errorType = error.getClass().getName();
                }
                if (errorType == null) {
                    errorType = "_OTHER";
                }
            }
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, HttpAttributes.ERROR_TYPE, (Object)errorType);
        }
        if (SemconvStability.emitStableHttpSemconv()) {
            String protocolName = HttpCommonAttributesExtractor.lowercaseStr(this.networkGetter.getNetworkProtocolName(request, response));
            String protocolVersion = HttpCommonAttributesExtractor.lowercaseStr(this.networkGetter.getNetworkProtocolVersion(request, response));
            if (protocolVersion != null) {
                if (!"http".equals(protocolName)) {
                    AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NETWORK_PROTOCOL_NAME, (Object)protocolName);
                }
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NETWORK_PROTOCOL_VERSION, (Object)protocolVersion);
            }
        }
    }

    @Nullable
    private Long requestBodySize(REQUEST request) {
        return HttpCommonAttributesExtractor.parseNumber(HttpCommonAttributesExtractor.firstHeaderValue(this.getter.getHttpRequestHeader(request, "content-length")));
    }

    @Nullable
    private Long responseBodySize(REQUEST request, RESPONSE response) {
        return HttpCommonAttributesExtractor.parseNumber(HttpCommonAttributesExtractor.firstHeaderValue(this.getter.getHttpResponseHeader(request, response, "content-length")));
    }

    @Nullable
    static String firstHeaderValue(List<String> values) {
        return values.isEmpty() ? null : values.get(0);
    }

    @Nullable
    private static Long parseNumber(@Nullable String number) {
        if (number == null) {
            return null;
        }
        try {
            return Long.parseLong(number);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    private static String lowercaseStr(@Nullable String str) {
        return str == null ? null : str.toLowerCase(Locale.ROOT);
    }
}

