/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt;

import java.security.Principal;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.jwt.Claims;

public interface JsonWebToken
extends Principal {
    @Override
    public String getName();

    default public String getRawToken() {
        return (String)this.getClaim(Claims.raw_token);
    }

    default public String getIssuer() {
        return (String)this.getClaim(Claims.iss);
    }

    default public Set<String> getAudience() {
        return (Set)this.getClaim(Claims.aud);
    }

    default public String getSubject() {
        return (String)this.getClaim(Claims.sub);
    }

    default public String getTokenID() {
        return (String)this.getClaim(Claims.jti);
    }

    default public long getExpirationTime() {
        return (Long)this.getClaim(Claims.exp);
    }

    default public long getIssuedAtTime() {
        return (Long)this.getClaim(Claims.iat);
    }

    default public Set<String> getGroups() {
        return (Set)this.getClaim(Claims.groups);
    }

    public Set<String> getClaimNames();

    default public boolean containsClaim(String claimName) {
        return this.claim(claimName).isPresent();
    }

    public <T> T getClaim(String var1);

    default public <T> T getClaim(Claims claim) {
        return this.getClaim(claim.name());
    }

    default public <T> Optional<T> claim(String claimName) {
        return Optional.ofNullable(this.getClaim(claimName));
    }

    default public <T> Optional<T> claim(Claims claim) {
        return this.claim(claim.name());
    }
}

