/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.loader.listener;

import java.lang.management.ManagementFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class JMXServerListener
implements LifecycleListener {
    private static final Log LOGGER = LogFactory.getLog(JMXServerListener.class);
    private String protocol;
    private String host;
    private int port = -1;
    private String urlPath;
    private JMXConnectorServer server;
    private JMXServiceURL serviceURL;

    public synchronized void lifecycleEvent(LifecycleEvent event) {
        try {
            if (this.server == null && "start".equals(event.getType())) {
                this.serviceURL = new JMXServiceURL(this.protocol, this.host, this.port, this.urlPath);
                this.server = JMXConnectorServerFactory.newJMXConnectorServer(this.serviceURL, null, ManagementFactory.getPlatformMBeanServer());
                this.server.start();
                LOGGER.info((Object)("Started JMX server: " + this.serviceURL.toString()));
            } else if (this.server != null && "stop".equals(event.getType())) {
                this.server.stop();
                this.server = null;
                LOGGER.info((Object)("Stopped JMX server: " + this.serviceURL.toString()));
            }
        }
        catch (Exception e) {
            throw new JMXException(e);
        }
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUrlPath(String urlPath) {
        this.urlPath = urlPath;
    }

    private static class JMXException
    extends RuntimeException {
        public JMXException(Exception e) {
            super(e);
        }
    }
}

