/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper.converter;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.johnzon.mapper.MapperConfig;

public class EnumConverter<T extends Enum<T>>
implements MapperConfig.CustomEnumConverter<T> {
    private final Map<String, T> values;
    private final Class<T> enumType;

    public EnumConverter(Class<T> aClass) {
        this.enumType = aClass;
        Enum[] enumConstants = aClass.isEnum() ? (Enum[])aClass.getEnumConstants() : (Enum[])aClass.getSuperclass().getEnumConstants();
        this.values = new HashMap<String, T>(enumConstants.length);
        for (Enum t : enumConstants) {
            this.values.put(t.name(), t);
        }
    }

    @Override
    public String toString(T instance) {
        return instance != null ? ((Enum)instance).name() : null;
    }

    @Override
    public T fromString(String text) {
        Enum val = (Enum)this.values.get(text);
        if (val == null) {
            throw new IllegalArgumentException("Illegal " + String.valueOf(this.enumType) + " enum value: " + text);
        }
        return (T)val;
    }

    public String toString() {
        return this.getClass().getSimpleName() + String.valueOf(this.values.keySet());
    }

    @Override
    public Type type() {
        return this.enumType;
    }
}

