/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server;

import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.server.OpProcessor;
import org.apache.tinkerpop.gremlin.server.auth.AllowAllAuthenticator;
import org.apache.tinkerpop.gremlin.server.channel.WebSocketChannelizer;
import org.apache.tinkerpop.gremlin.server.util.DefaultGraphManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class Settings {
    private static final Logger logger = LoggerFactory.getLogger(Settings.class);
    public String host = "localhost";
    public int port = 8182;
    public int threadPoolWorker = 1;
    public boolean useEpollEventLoop = false;
    public int gremlinPool = 0;
    public int threadPoolBoss = 1;
    public long evaluationTimeout = 30000L;
    public int resultIterationBatchSize = 64;
    public int maxInitialLineLength = 4096;
    public int maxHeaderSize = 8192;
    public int maxChunkSize = 8192;
    public int maxContentLength = 0xA00000;
    public int maxAccumulationBufferComponents = 1024;
    public int writeBufferHighWaterMark = 65536;
    public int writeBufferLowWaterMark = 32768;
    public long idleConnectionTimeout = 0L;
    public long keepAliveInterval = 0L;
    public boolean strictTransactionManagement = false;
    public String channelizer = WebSocketChannelizer.class.getName();
    public String graphManager = DefaultGraphManager.class.getName();
    public int maxWorkQueueSize = 8192;
    @Deprecated
    public int maxSessionTaskQueueSize = 4096;
    public int maxParameters = 16;
    @Deprecated
    public long sessionLifetimeTimeout = 600000L;
    @Deprecated
    public boolean useGlobalFunctionCacheForSessions = true;
    @Deprecated
    public boolean useCommonEngineForSessions = true;
    public ServerMetrics metrics = null;
    public Map<String, String> graphs = new HashMap<String, String>();
    public Map<String, ScriptEngineSettings> scriptEngines;
    public List<SerializerSettings> serializers = Collections.emptyList();
    public SslSettings ssl = null;
    public AuthenticationSettings authentication = new AuthenticationSettings();
    public AuthorizationSettings authorization = new AuthorizationSettings();
    public Boolean enableAuditLog = false;
    public List<ProcessorSettings> processors = new ArrayList<ProcessorSettings>();

    public Settings() {
        this.scriptEngines = new HashMap<String, ScriptEngineSettings>();
        this.scriptEngines.put("gremlin-groovy", new ScriptEngineSettings());
    }

    public Optional<ProcessorSettings> optionalProcessor(Class<? extends OpProcessor> clazz) {
        return this.processors.stream().filter(p -> p.className.equals(clazz.getCanonicalName())).findFirst();
    }

    public Optional<ServerMetrics> optionalMetrics() {
        return Optional.ofNullable(this.metrics);
    }

    public Optional<SslSettings> optionalSsl() {
        return Optional.ofNullable(this.ssl);
    }

    public long getEvaluationTimeout() {
        return this.evaluationTimeout;
    }

    public static Settings read(String file) throws Exception {
        FileInputStream input = new FileInputStream(new File(file));
        return Settings.read(input);
    }

    protected static Constructor createDefaultYamlConstructor() {
        LoaderOptions options = new LoaderOptions();
        Constructor constructor = new Constructor(Settings.class, options);
        TypeDescription settingsDescription = new TypeDescription(Settings.class);
        settingsDescription.addPropertyParameters("graphs", new Class[]{String.class, String.class});
        settingsDescription.addPropertyParameters("scriptEngines", new Class[]{String.class, ScriptEngineSettings.class});
        settingsDescription.addPropertyParameters("serializers", new Class[]{SerializerSettings.class});
        settingsDescription.addPropertyParameters("processors", new Class[]{ProcessorSettings.class});
        constructor.addTypeDescription(settingsDescription);
        TypeDescription serializerSettingsDescription = new TypeDescription(SerializerSettings.class);
        serializerSettingsDescription.addPropertyParameters("config", new Class[]{String.class, Object.class});
        constructor.addTypeDescription(serializerSettingsDescription);
        TypeDescription scriptEngineSettingsDescription = new TypeDescription(ScriptEngineSettings.class);
        scriptEngineSettingsDescription.addPropertyParameters("imports", new Class[]{String.class});
        scriptEngineSettingsDescription.addPropertyParameters("staticImports", new Class[]{String.class});
        scriptEngineSettingsDescription.addPropertyParameters("scripts", new Class[]{String.class});
        scriptEngineSettingsDescription.addPropertyParameters("config", new Class[]{String.class, Object.class});
        scriptEngineSettingsDescription.addPropertyParameters("plugins", new Class[]{String.class, Object.class});
        constructor.addTypeDescription(scriptEngineSettingsDescription);
        TypeDescription sslSettings = new TypeDescription(SslSettings.class);
        constructor.addTypeDescription(sslSettings);
        TypeDescription authenticationSettings = new TypeDescription(AuthenticationSettings.class);
        constructor.addTypeDescription(authenticationSettings);
        TypeDescription serverMetricsDescription = new TypeDescription(ServerMetrics.class);
        constructor.addTypeDescription(serverMetricsDescription);
        TypeDescription consoleReporterDescription = new TypeDescription(ConsoleReporterMetrics.class);
        constructor.addTypeDescription(consoleReporterDescription);
        TypeDescription csvReporterDescription = new TypeDescription(CsvReporterMetrics.class);
        constructor.addTypeDescription(csvReporterDescription);
        TypeDescription jmxReporterDescription = new TypeDescription(JmxReporterMetrics.class);
        constructor.addTypeDescription(jmxReporterDescription);
        TypeDescription slf4jReporterDescription = new TypeDescription(Slf4jReporterMetrics.class);
        constructor.addTypeDescription(slf4jReporterDescription);
        TypeDescription gangliaReporterDescription = new TypeDescription(GangliaReporterMetrics.class);
        constructor.addTypeDescription(gangliaReporterDescription);
        TypeDescription graphiteReporterDescription = new TypeDescription(GraphiteReporterMetrics.class);
        constructor.addTypeDescription(graphiteReporterDescription);
        return constructor;
    }

    public static Settings read(InputStream stream) {
        Objects.requireNonNull(stream);
        Constructor constructor = Settings.createDefaultYamlConstructor();
        Yaml yaml = new Yaml((BaseConstructor)constructor);
        return (Settings)yaml.loadAs(stream, Settings.class);
    }

    public static abstract class BaseMetrics {
        public boolean enabled = false;
    }

    public static abstract class IntervalMetrics
    extends BaseMetrics {
        public long interval = 60000L;
    }

    public static abstract class HostPortIntervalMetrics
    extends IntervalMetrics {
        public String host = "localhost";
        public int port;
    }

    public static class GraphiteReporterMetrics
    extends HostPortIntervalMetrics {
        public String prefix = "";

        public GraphiteReporterMetrics() {
            this.port = 2003;
        }
    }

    public static class GangliaReporterMetrics
    extends HostPortIntervalMetrics {
        public String addressingMode = null;
        public int ttl = 1;
        public boolean protocol31 = true;
        public UUID hostUUID = null;
        public String spoof = null;

        public GangliaReporterMetrics() {
            this.port = 8649;
        }
    }

    public static class Slf4jReporterMetrics
    extends IntervalMetrics {
        public String loggerName = Slf4jReporterMetrics.class.getName();
    }

    public static class JmxReporterMetrics
    extends BaseMetrics {
        public String domain = null;
        public String agentId = null;
    }

    public static class CsvReporterMetrics
    extends IntervalMetrics {
        public String fileName = "metrics.csv";
    }

    public static class ConsoleReporterMetrics
    extends IntervalMetrics {
    }

    public static class ServerMetrics {
        public ConsoleReporterMetrics consoleReporter = null;
        public CsvReporterMetrics csvReporter = null;
        public JmxReporterMetrics jmxReporter = null;
        public Slf4jReporterMetrics slf4jReporter = null;
        public GangliaReporterMetrics gangliaReporter = null;
        public GraphiteReporterMetrics graphiteReporter = null;

        public Optional<ConsoleReporterMetrics> optionalConsoleReporter() {
            return Optional.ofNullable(this.consoleReporter);
        }

        public Optional<CsvReporterMetrics> optionalCsvReporter() {
            return Optional.ofNullable(this.csvReporter);
        }

        public Optional<JmxReporterMetrics> optionalJmxReporter() {
            return Optional.ofNullable(this.jmxReporter);
        }

        public Optional<Slf4jReporterMetrics> optionalSlf4jReporter() {
            return Optional.ofNullable(this.slf4jReporter);
        }

        public Optional<GangliaReporterMetrics> optionalGangliaReporter() {
            return Optional.ofNullable(this.gangliaReporter);
        }

        public Optional<GraphiteReporterMetrics> optionalGraphiteReporter() {
            return Optional.ofNullable(this.graphiteReporter);
        }
    }

    public static class SslSettings {
        public boolean enabled = false;
        public String keyStore;
        public String keyStorePassword;
        public String trustStore;
        public String trustStorePassword;
        public String keyStoreType;
        public String trustStoreType;
        public List<String> sslEnabledProtocols = new ArrayList<String>();
        public List<String> sslCipherSuites = new ArrayList<String>();
        public ClientAuth needClientAuth = ClientAuth.NONE;
        public long refreshInterval = 60000L;
        private SslContext sslContext;

        public void overrideSslContext(SslContext sslContext) {
            this.sslContext = sslContext;
        }

        public Optional<SslContext> getSslContext() {
            return Optional.ofNullable(this.sslContext);
        }
    }

    public static class AuthorizationSettings {
        public String authorizer = null;
        public Map<String, Object> config = null;
    }

    public static class AuthenticationSettings {
        public String authenticator = AllowAllAuthenticator.class.getName();
        public String authenticationHandler = null;
        public Map<String, Object> config = null;
    }

    public static class SerializerSettings {
        public String className;
        public Map<String, Object> config = Collections.emptyMap();

        public SerializerSettings() {
        }

        SerializerSettings(String className, Map<String, Object> config) {
            this.className = className;
            this.config = config;
        }
    }

    public static class ScriptEngineSettings {
        public List<String> imports = new ArrayList<String>();
        public List<String> staticImports = new ArrayList<String>();
        public List<String> scripts = new ArrayList<String>();
        public Map<String, Object> config = null;
        public Map<String, Map<String, Object>> plugins = new LinkedHashMap<String, Map<String, Object>>();
    }

    public static class ProcessorSettings {
        public String className;
        public Map<String, Object> config;
    }
}

