/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.language.translator;

import org.apache.tinkerpop.gremlin.language.grammar.GremlinParser;
import org.apache.tinkerpop.gremlin.language.translator.TranslateVisitor;

public abstract class AbstractTranslateVisitor
extends TranslateVisitor {
    public AbstractTranslateVisitor(String graphTraversalSourceName) {
        super(graphTraversalSourceName);
    }

    public Void visitStringLiteral(GremlinParser.StringLiteralContext ctx) {
        String text = AbstractTranslateVisitor.removeFirstAndLastCharacters(ctx.getText());
        this.handleStringLiteralText(text);
        return null;
    }

    public Void visitStringNullableLiteral(GremlinParser.StringNullableLiteralContext ctx) {
        if (ctx.getText().equals("null")) {
            this.sb.append("null");
        } else {
            String text = AbstractTranslateVisitor.removeFirstAndLastCharacters(ctx.getText());
            this.handleStringLiteralText(text);
        }
        return null;
    }

    public Void visitNakedKey(GremlinParser.NakedKeyContext ctx) {
        this.handleStringLiteralText(ctx.getText());
        return null;
    }

    @Override
    public Void visitKeyword(GremlinParser.KeywordContext ctx) {
        String keyword = ctx.getText();
        if (ctx.getParent() instanceof GremlinParser.MapKeyContext) {
            this.handleStringLiteralText(keyword);
        } else {
            this.sb.append(keyword).append(" ");
        }
        return null;
    }

    protected void handleStringLiteralText(String text) {
        this.sb.append("\"");
        this.sb.append(text);
        this.sb.append("\"");
    }
}

