/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.process.traversal.util.Metrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.CollectionSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class MetricsSerializer
extends SimpleTypeSerializer<Metrics> {
    private static final CollectionSerializer collectionSerializer = new CollectionSerializer(DataType.LIST);

    public MetricsSerializer() {
        super(DataType.METRICS);
    }

    @Override
    protected Metrics readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        MutableMetrics result = new MutableMetrics(context.readValue(buffer, String.class, false), context.readValue(buffer, String.class, false));
        result.setDuration(context.readValue(buffer, Long.class, false), TimeUnit.NANOSECONDS);
        Map counts = context.readValue(buffer, Map.class, false);
        counts.forEach(result::setCount);
        Map annotations = context.readValue(buffer, Map.class, false);
        annotations.forEach(result::setAnnotation);
        Collection nestedMetrics = collectionSerializer.readValue(buffer, context);
        nestedMetrics.forEach(result::addNested);
        return result;
    }

    @Override
    protected void writeValue(Metrics value, Buffer buffer, GraphBinaryWriter context) throws IOException {
        context.writeValue(value.getId(), buffer, false);
        context.writeValue(value.getName(), buffer, false);
        context.writeValue(value.getDuration(TimeUnit.NANOSECONDS), buffer, false);
        context.writeValue(value.getCounts(), buffer, false);
        context.writeValue(value.getAnnotations(), buffer, false);
        collectionSerializer.writeValue(value.getNested(), buffer, context);
    }
}

