/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.traverser.util;

import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSideEffects;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyPath;
import org.apache.tinkerpop.gremlin.process.traversal.util.EmptyTraversalSideEffects;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceFactory;

public abstract class AbstractTraverser<T>
implements Traverser<T>,
Traverser.Admin<T> {
    protected T t;

    protected AbstractTraverser() {
    }

    public AbstractTraverser(T t) {
        this.t = t;
    }

    @Override
    public void merge(Traverser.Admin<?> other) {
        throw new UnsupportedOperationException("This traverser does not support merging: " + this.getClass().getCanonicalName());
    }

    @Override
    public <R> Traverser.Admin<R> split(R r, Step<T, R> step) {
        try {
            AbstractTraverser clone = (AbstractTraverser)super.clone();
            clone.t = r;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public Traverser.Admin<T> split() {
        try {
            return (AbstractTraverser)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void addLabels(Set<String> labels) {
    }

    @Override
    public void keepLabels(Set<String> labels) {
    }

    @Override
    public void dropLabels(Set<String> labels) {
    }

    @Override
    public void dropPath() {
    }

    @Override
    public void set(T t) {
        this.t = t;
    }

    @Override
    public void initialiseLoops(String stepLabel, String loopName) {
    }

    @Override
    public void incrLoops() {
    }

    @Override
    public void resetLoops() {
    }

    @Override
    public String getStepId() {
        throw new UnsupportedOperationException("This traverser does not support futures: " + this.getClass().getCanonicalName());
    }

    @Override
    public void setStepId(String stepId) {
    }

    @Override
    public void setBulk(long count) {
    }

    @Override
    public Traverser.Admin<T> detach() {
        this.t = ReferenceFactory.detach(this.t);
        return this;
    }

    @Override
    public T attach(Function<Attachable<T>, T> method) {
        if (this.t instanceof Attachable && !(((Attachable)this.t).get() instanceof Path)) {
            this.t = ((Attachable)this.t).attach(method);
        }
        return this.t;
    }

    @Override
    public void setSideEffects(TraversalSideEffects sideEffects) {
    }

    @Override
    public TraversalSideEffects getSideEffects() {
        return EmptyTraversalSideEffects.instance();
    }

    @Override
    public T get() {
        return this.t;
    }

    @Override
    public <S> S sack() {
        throw new UnsupportedOperationException("This traverser does not support sacks: " + this.getClass().getCanonicalName());
    }

    @Override
    public <S> void sack(S object) {
    }

    @Override
    public Path path() {
        return EmptyPath.instance();
    }

    @Override
    public int loops() {
        throw new UnsupportedOperationException("This traverser does not support loops: " + this.getClass().getCanonicalName());
    }

    @Override
    public int loops(String loopName) {
        throw new UnsupportedOperationException("This traverser does not support named loops: " + this.getClass().getCanonicalName());
    }

    @Override
    public long bulk() {
        return 1L;
    }

    @Override
    public AbstractTraverser<T> clone() {
        try {
            return (AbstractTraverser)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public int hashCode() {
        return Objects.hashCode(this.t);
    }

    public boolean equals(Object object) {
        return object instanceof AbstractTraverser && Objects.equals(this.t, ((AbstractTraverser)object).t);
    }

    public String toString() {
        return Objects.toString(this.t);
    }
}

