/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.task;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ClusterStorageCapacityExceededException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.tez.common.Preconditions;
import org.apache.tez.common.TezExecutors;
import org.apache.tez.common.TezSharedExecutor;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.hadoop.shim.HadoopShim;
import org.apache.tez.runtime.LogicalIOProcessorRuntimeTask;
import org.apache.tez.runtime.api.ExecutionContext;
import org.apache.tez.runtime.api.ObjectRegistry;
import org.apache.tez.runtime.api.TaskFailureType;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.runtime.api.impl.TezUmbilical;
import org.apache.tez.runtime.internals.api.TaskReporterInterface;
import org.apache.tez.runtime.task.EndReason;
import org.apache.tez.runtime.task.ErrorReporter;
import org.apache.tez.runtime.task.TaskRunner2Callable;
import org.apache.tez.runtime.task.TaskRunner2Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezTaskRunner2 {
    private static final Logger LOG = LoggerFactory.getLogger(TezTaskRunner2.class);
    @VisibleForTesting
    final LogicalIOProcessorRuntimeTask task;
    private final UserGroupInformation ugi;
    private final TaskReporterInterface taskReporter;
    private final ExecutorService executor;
    private final UmbilicalAndErrorHandler umbilicalAndErrorHandler;
    private final AtomicBoolean killTaskRequested = new AtomicBoolean(false);
    private final AtomicBoolean stopContainerRequested = new AtomicBoolean(false);
    private final AtomicBoolean taskComplete = new AtomicBoolean(false);
    private final AtomicBoolean errorSeen = new AtomicBoolean(false);
    private volatile EndReason firstEndReason = null;
    private volatile Throwable firstException;
    private volatile EventMetaData exceptionSourceInfo;
    volatile TaskFailureType firstTaskFailureType;
    private final AtomicBoolean errorReporterToAm = new AtomicBoolean(false);
    private volatile boolean oobSignalErrorInProgress = false;
    private final Lock oobSignalLock = new ReentrantLock();
    private final Condition oobSignalCondition = this.oobSignalLock.newCondition();
    private volatile long taskKillStartTime = 0L;
    final Configuration taskConf;
    private final HadoopShim hadoopShim;
    private volatile TaskRunner2Callable taskRunnerCallable;
    private final TezSharedExecutor localExecutor;

    @Deprecated
    public TezTaskRunner2(Configuration tezConf, UserGroupInformation ugi, String[] localDirs, TaskSpec taskSpec, int appAttemptNumber, Map<String, ByteBuffer> serviceConsumerMetadata, Map<String, String> serviceProviderEnvMap, Multimap<String, String> startedInputsMap, TaskReporterInterface taskReporter, ExecutorService executor, ObjectRegistry objectRegistry, String pid, ExecutionContext executionContext, long memAvailable, boolean updateSysCounters, HadoopShim hadoopShim) throws IOException {
        this(tezConf, ugi, localDirs, taskSpec, appAttemptNumber, serviceConsumerMetadata, serviceProviderEnvMap, startedInputsMap, taskReporter, executor, objectRegistry, pid, executionContext, memAvailable, updateSysCounters, hadoopShim, null);
    }

    public TezTaskRunner2(Configuration tezConf, UserGroupInformation ugi, String[] localDirs, TaskSpec taskSpec, int appAttemptNumber, Map<String, ByteBuffer> serviceConsumerMetadata, Map<String, String> serviceProviderEnvMap, Multimap<String, String> startedInputsMap, TaskReporterInterface taskReporter, ExecutorService executor, ObjectRegistry objectRegistry, String pid, ExecutionContext executionContext, long memAvailable, boolean updateSysCounters, HadoopShim hadoopShim, TezExecutors sharedExecutor) throws IOException {
        this.ugi = ugi;
        this.taskReporter = taskReporter;
        this.executor = executor;
        this.umbilicalAndErrorHandler = new UmbilicalAndErrorHandler();
        this.hadoopShim = hadoopShim;
        this.taskConf = new Configuration(tezConf);
        TezTaskRunner2.mergeTaskSpecConfToConf(taskSpec, this.taskConf);
        this.localExecutor = sharedExecutor == null ? new TezSharedExecutor(tezConf) : null;
        this.task = new LogicalIOProcessorRuntimeTask(taskSpec, appAttemptNumber, this.taskConf, localDirs, this.umbilicalAndErrorHandler, serviceConsumerMetadata, serviceProviderEnvMap, startedInputsMap, objectRegistry, pid, executionContext, memAvailable, updateSysCounters, hadoopShim, (TezExecutors)(sharedExecutor == null ? this.localExecutor : sharedExecutor));
    }

    static void mergeTaskSpecConfToConf(TaskSpec taskSpec, Configuration conf) {
        if (taskSpec.getTaskConf() != null) {
            for (Map.Entry entry : taskSpec.getTaskConf()) {
                conf.set((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    /*
     * Exception decompiling
     */
    public TaskRunner2Result run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void processCallableResult(TaskRunner2Callable.TaskRunner2CallableResult executionResult) {
        if (executionResult != null) {
            TezTaskRunner2 tezTaskRunner2 = this;
            synchronized (tezTaskRunner2) {
                if (this.isRunningState()) {
                    if (executionResult.error != null) {
                        this.trySettingEndReason(EndReason.TASK_ERROR);
                        this.registerFirstException(this.getTaskFailureType(executionResult.error), executionResult.error, null);
                    } else {
                        this.trySettingEndReason(EndReason.SUCCESS);
                        this.taskComplete.set(true);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean killTask() {
        boolean isFirstError = false;
        TezTaskRunner2 tezTaskRunner2 = this;
        synchronized (tezTaskRunner2) {
            if (this.isRunningState()) {
                if (this.trySettingEndReason(EndReason.KILL_REQUESTED)) {
                    isFirstError = true;
                    this.killTaskRequested.set(true);
                } else {
                    this.logErrorIgnored("killTask", null);
                }
            } else {
                this.logErrorIgnored("killTask", null);
            }
        }
        if (isFirstError) {
            this.logAborting("killTask");
            this.killTaskInternal();
            return true;
        }
        return false;
    }

    private void killTaskInternal() {
        this.abortTaskInternal();
        this.interruptTaskInternal();
    }

    private void abortTaskInternal() {
        if (this.taskRunnerCallable != null) {
            this.taskKillStartTime = System.currentTimeMillis();
            this.taskRunnerCallable.abortTask();
        }
    }

    private void interruptTaskInternal() {
        if (this.taskRunnerCallable != null) {
            this.taskRunnerCallable.interruptTask();
        }
    }

    private boolean isRunningState() {
        return !this.taskComplete.get() && !this.killTaskRequested.get() && !this.stopContainerRequested.get() && !this.errorSeen.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalTerminationInternal(TezTaskAttemptID taskAttemptID, EndReason endReason, TaskFailureType taskFailureType, Throwable t, String message, EventMetaData sourceInfo, boolean isKill) {
        boolean isFirstError = false;
        String typeString = isKill ? " kill " : " failure ";
        TezTaskRunner2 tezTaskRunner2 = this;
        synchronized (tezTaskRunner2) {
            if (this.isRunningState()) {
                if (this.trySettingEndReason(endReason)) {
                    if (t == null) {
                        String errMessage = message;
                        if (errMessage == null) {
                            errMessage = typeString + " : No user message or exception specified";
                        }
                        t = new RuntimeException(errMessage);
                    }
                    this.registerFirstException(taskFailureType, t, sourceInfo);
                    LOG.info("Received notification of a " + typeString + " which will cause the task to die", t);
                    isFirstError = true;
                    this.errorReporterToAm.set(true);
                    this.oobSignalErrorInProgress = true;
                } else {
                    this.logErrorIgnored(typeString, message);
                }
            } else {
                this.logErrorIgnored(typeString, message);
            }
        }
        if (isFirstError) {
            this.logAborting(typeString);
            this.abortTaskInternal();
            try {
                if (isKill) {
                    this.taskReporter.taskKilled(taskAttemptID, t, this.getTaskDiagnosticsString(t, message, typeString), sourceInfo);
                } else {
                    this.taskReporter.taskFailed(taskAttemptID, taskFailureType, t, this.getTaskDiagnosticsString(t, message, typeString), sourceInfo);
                }
            }
            catch (IOException e) {
                this.handleFinalStatusUpdateFailure(e, typeString);
            }
            catch (TezException e) {
                this.handleFinalStatusUpdateFailure(e, typeString);
            }
            catch (Exception e) {
                this.handleFinalStatusUpdateFailure(e, typeString);
            }
            finally {
                this.interruptTaskInternal();
                this.oobSignalLock.lock();
                try {
                    this.oobSignalErrorInProgress = false;
                    this.oobSignalCondition.signal();
                }
                finally {
                    this.oobSignalLock.unlock();
                }
            }
        }
    }

    private synchronized boolean trySettingEndReason(EndReason endReason) {
        if (this.isRunningState()) {
            this.firstEndReason = endReason;
            return true;
        }
        return false;
    }

    private void registerFirstException(TaskFailureType taskFailureType, Throwable t, EventMetaData sourceInfo) {
        Preconditions.checkState((boolean)this.isRunningState());
        this.errorSeen.set(true);
        this.firstException = t;
        this.firstTaskFailureType = taskFailureType;
        this.exceptionSourceInfo = sourceInfo;
    }

    private String getTaskDiagnosticsString(Throwable t, String message, String typeString) {
        String diagnostics = t != null && message != null ? "Error while running task (" + typeString + ") : " + ExceptionUtils.getStackTrace((Throwable)t) + ", errorMessage=" + message : (t == null && message == null ? "Unknown error" : (t != null ? "Error while running task (" + typeString + ") : " + ExceptionUtils.getStackTrace((Throwable)t) : " errorMessage=" + message));
        return diagnostics;
    }

    private TaskRunner2Result logAndReturnEndResult(EndReason endReason, TaskFailureType taskFailureType, Throwable firstError, boolean stopContainerRequested) {
        TaskRunner2Result result = new TaskRunner2Result(endReason, taskFailureType, firstError, stopContainerRequested);
        LOG.info("TaskRunnerResult for {} : {}  ", (Object)this.task.getTaskAttemptID(), (Object)result);
        return result;
    }

    private void handleFinalStatusUpdateFailure(Throwable t, String stateString) {
        LOG.warn("Failure while reporting state= {} to AM", (Object)stateString, (Object)t);
    }

    private void logErrorIgnored(String ignoredEndReason, String errorMessage) {
        Object[] objectArray = new Object[4];
        objectArray[0] = ignoredEndReason;
        objectArray[1] = this.task.getTaskAttemptID();
        objectArray[2] = this.firstEndReason;
        objectArray[3] = this.firstException == null ? (errorMessage == null ? "" : errorMessage) : this.firstException.getMessage();
        LOG.info("Ignoring {} request since the task with id {} has ended for reason: {}. IgnoredError: {} ", objectArray);
    }

    private void logAborting(String abortReason) {
        LOG.info("Attempting to abort {} due to an invocation of {}", (Object)this.task.getTaskAttemptID(), (Object)abortReason);
    }

    private TaskFailureType getTaskFailureType(Throwable e) {
        boolean hasClusterStorageCapacityExceededException;
        boolean bl = hasClusterStorageCapacityExceededException = ExceptionUtils.indexOfType((Throwable)e, ClusterStorageCapacityExceededException.class) != -1;
        if (hasClusterStorageCapacityExceededException) {
            return TaskFailureType.FATAL;
        }
        return TaskFailureType.NON_FATAL;
    }

    class UmbilicalAndErrorHandler
    implements TezUmbilical,
    ErrorReporter {
        UmbilicalAndErrorHandler() {
        }

        @Override
        public void addEvents(Collection<TezEvent> events) {
            if (TezTaskRunner2.this.isRunningState()) {
                TezTaskRunner2.this.taskReporter.addEvents(TezTaskRunner2.this.task.getTaskAttemptID(), events);
            }
        }

        @Override
        public void signalFailure(TezTaskAttemptID taskAttemptID, TaskFailureType taskFailureType, Throwable t, String message, EventMetaData sourceInfo) {
            TezTaskRunner2.this.signalTerminationInternal(taskAttemptID, EndReason.TASK_ERROR, taskFailureType, t, message, sourceInfo, false);
        }

        @Override
        public void signalKillSelf(TezTaskAttemptID taskAttemptID, Throwable t, String message, EventMetaData sourceInfo) {
            TezTaskRunner2.this.signalTerminationInternal(taskAttemptID, EndReason.TASK_KILL_REQUEST, null, t, message, sourceInfo, true);
        }

        @Override
        public boolean canCommit(TezTaskAttemptID taskAttemptID) throws IOException {
            if (TezTaskRunner2.this.isRunningState()) {
                return TezTaskRunner2.this.taskReporter.canCommit(taskAttemptID);
            }
            LOG.info("returning canCommit=false since task is not in a running state");
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reportError(Throwable t) {
            boolean isFirstError = false;
            TezTaskRunner2 tezTaskRunner2 = TezTaskRunner2.this;
            synchronized (tezTaskRunner2) {
                if (TezTaskRunner2.this.isRunningState()) {
                    LOG.info("TaskReporter reporter error which will cause the task to fail", t);
                    if (TezTaskRunner2.this.trySettingEndReason(EndReason.COMMUNICATION_FAILURE)) {
                        TezTaskRunner2.this.registerFirstException(TaskFailureType.NON_FATAL, t, null);
                        isFirstError = true;
                    } else {
                        TezTaskRunner2.this.logErrorIgnored("umbilicalFatalError", null);
                    }
                } else {
                    TezTaskRunner2.this.logErrorIgnored("umbilicalFatalError", null);
                }
            }
            if (isFirstError) {
                TezTaskRunner2.this.logAborting("umbilicalFatalError");
                TezTaskRunner2.this.killTaskInternal();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdownRequested() {
            boolean isFirstTerminate = false;
            TezTaskRunner2 tezTaskRunner2 = TezTaskRunner2.this;
            synchronized (tezTaskRunner2) {
                isFirstTerminate = TezTaskRunner2.this.trySettingEndReason(EndReason.CONTAINER_STOP_REQUESTED);
                TezTaskRunner2.this.stopContainerRequested.set(true);
            }
            if (isFirstTerminate) {
                TezTaskRunner2.this.logAborting("shutdownRequested");
                TezTaskRunner2.this.killTaskInternal();
            } else {
                TezTaskRunner2.this.logErrorIgnored("shutdownRequested", null);
            }
        }
    }
}

