/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import afghanistan from './countries/afghanistan.geojson';
import aland from './countries/aland.geojson';
import albania from './countries/albania.geojson';
import algeria from './countries/algeria.geojson';
import american_samoa from './countries/american_samoa.geojson';
import andorra from './countries/andorra.geojson';
import angola from './countries/angola.geojson';
import anguilla from './countries/anguilla.geojson';
import antarctica from './countries/antarctica.geojson';
import antigua_and_barbuda from './countries/antigua_and_barbuda.geojson';
import argentina from './countries/argentina.geojson';
import armenia from './countries/armenia.geojson';
import australia from './countries/australia.geojson';
import austria from './countries/austria.geojson';
import azerbaijan from './countries/azerbaijan.geojson';
import bahrain from './countries/bahrain.geojson';
import bangladesh from './countries/bangladesh.geojson';
import barbados from './countries/barbados.geojson';
import belarus from './countries/belarus.geojson';
import belgium from './countries/belgium.geojson';
import belize from './countries/belize.geojson';
import benin from './countries/benin.geojson';
import bermuda from './countries/bermuda.geojson';
import bhutan from './countries/bhutan.geojson';
import bolivia from './countries/bolivia.geojson';
import bosnia_and_herzegovina from './countries/bosnia_and_herzegovina.geojson';
import botswana from './countries/botswana.geojson';
import brazil from './countries/brazil.geojson';
import brunei from './countries/brunei.geojson';
import bulgaria from './countries/bulgaria.geojson';
import burkina_faso from './countries/burkina_faso.geojson';
import burundi from './countries/burundi.geojson';
import cambodia from './countries/cambodia.geojson';
import cameroon from './countries/cameroon.geojson';
import canada from './countries/canada.geojson';
import cape_verde from './countries/cape_verde.geojson';
import central_african_republic from './countries/central_african_republic.geojson';
import chad from './countries/chad.geojson';
import chile from './countries/chile.geojson';
import china from './countries/china.geojson';
import colombia from './countries/colombia.geojson';
import comoros from './countries/comoros.geojson';
import cook_islands from './countries/cook_islands.geojson';
import costa_rica from './countries/costa_rica.geojson';
import croatia from './countries/croatia.geojson';
import cuba from './countries/cuba.geojson';
import cyprus from './countries/cyprus.geojson';
import czech_republic from './countries/czech_republic.geojson';
import democratic_republic_of_the_congo from './countries/democratic_republic_of_the_congo.geojson';
import denmark from './countries/denmark.geojson';
import djibouti from './countries/djibouti.geojson';
import dominica from './countries/dominica.geojson';
import dominican_republic from './countries/dominican_republic.geojson';
import ecuador from './countries/ecuador.geojson';
import egypt from './countries/egypt.geojson';
import el_salvador from './countries/el_salvador.geojson';
import equatorial_guinea from './countries/equatorial_guinea.geojson';
import eritrea from './countries/eritrea.geojson';
import estonia from './countries/estonia.geojson';
import ethiopia from './countries/ethiopia.geojson';
import fiji from './countries/fiji.geojson';
import finland from './countries/finland.geojson';
import france from './countries/france.geojson';
import france_overseas from './countries/france_overseas.geojson';
import france_regions from './countries/france_regions.geojson';
import french_polynesia from './countries/french_polynesia.geojson';
import gabon from './countries/gabon.geojson';
import gambia from './countries/gambia.geojson';
import germany from './countries/germany.geojson';
import ghana from './countries/ghana.geojson';
import greece from './countries/greece.geojson';
import greenland from './countries/greenland.geojson';
import grenada from './countries/grenada.geojson';
import guatemala from './countries/guatemala.geojson';
import guinea from './countries/guinea.geojson';
import guyana from './countries/guyana.geojson';
import haiti from './countries/haiti.geojson';
import honduras from './countries/honduras.geojson';
import hungary from './countries/hungary.geojson';
import iceland from './countries/iceland.geojson';
import india from './countries/india.geojson';
import indonesia from './countries/indonesia.geojson';
import iran from './countries/iran.geojson';
import israel from './countries/israel.geojson';
import italy from './countries/italy.geojson';
import italy_regions from './countries/italy_regions.geojson';
import japan from './countries/japan.geojson';
import jordan from './countries/jordan.geojson';
import kazakhstan from './countries/kazakhstan.geojson';
import kenya from './countries/kenya.geojson';
import korea from './countries/korea.geojson';
import kuwait from './countries/kuwait.geojson';
import kyrgyzstan from './countries/kyrgyzstan.geojson';
import laos from './countries/laos.geojson';
import latvia from './countries/latvia.geojson';
import lebanon from './countries/lebanon.geojson';
import lesotho from './countries/lesotho.geojson';
import liberia from './countries/liberia.geojson';
import libya from './countries/libya.geojson';
import liechtenstein from './countries/liechtenstein.geojson';
import lithuania from './countries/lithuania.geojson';
import luxembourg from './countries/luxembourg.geojson';
import macedonia from './countries/macedonia.geojson';
import madagascar from './countries/madagascar.geojson';
import malawi from './countries/malawi.geojson';
import malaysia from './countries/malaysia.geojson';
import maldives from './countries/maldives.geojson';
import mali from './countries/mali.geojson';
import malta from './countries/malta.geojson';
import marshall_islands from './countries/marshall_islands.geojson';
import mauritania from './countries/mauritania.geojson';
import mauritius from './countries/mauritius.geojson';
import mexico from './countries/mexico.geojson';
import moldova from './countries/moldova.geojson';
import mongolia from './countries/mongolia.geojson';
import montenegro from './countries/montenegro.geojson';
import montserrat from './countries/montserrat.geojson';
import morocco from './countries/morocco.geojson';
import mozambique from './countries/mozambique.geojson';
import myanmar from './countries/myanmar.geojson';
import namibia from './countries/namibia.geojson';
import nauru from './countries/nauru.geojson';
import nepal from './countries/nepal.geojson';
import netherlands from './countries/netherlands.geojson';
import new_caledonia from './countries/new_caledonia.geojson';
import new_zealand from './countries/new_zealand.geojson';
import nicaragua from './countries/nicaragua.geojson';
import niger from './countries/niger.geojson';
import nigeria from './countries/nigeria.geojson';
import northern_mariana_islands from './countries/northern_mariana_islands.geojson';
import norway from './countries/norway.geojson';
import oman from './countries/oman.geojson';
import pakistan from './countries/pakistan.geojson';
import palau from './countries/palau.geojson';
import panama from './countries/panama.geojson';
import papua_new_guinea from './countries/papua_new_guinea.geojson';
import paraguay from './countries/paraguay.geojson';
import peru from './countries/peru.geojson';
import philippines from './countries/philippines.geojson';
import philippines_regions from './countries/philippines_regions.geojson';
import poland from './countries/poland.geojson';
import portugal from './countries/portugal.geojson';
import qatar from './countries/qatar.geojson';
import romania from './countries/romania.geojson';
import russia from './countries/russia.geojson';
import rwanda from './countries/rwanda.geojson';
import saint_lucia from './countries/saint_lucia.geojson';
import saint_pierre_and_miquelon from './countries/saint_pierre_and_miquelon.geojson';
import saint_vincent_and_the_grenadines from './countries/saint_vincent_and_the_grenadines.geojson';
import samoa from './countries/samoa.geojson';
import san_marino from './countries/san_marino.geojson';
import sao_tome_and_principe from './countries/sao_tome_and_principe.geojson';
import saudi_arabia from './countries/saudi_arabia.geojson';
import senegal from './countries/senegal.geojson';
import seychelles from './countries/seychelles.geojson';
import sierra_leone from './countries/sierra_leone.geojson';
import singapore from './countries/singapore.geojson';
import slovakia from './countries/slovakia.geojson';
import slovenia from './countries/slovenia.geojson';
import solomon_islands from './countries/solomon_islands.geojson';
import somalia from './countries/somalia.geojson';
import south_africa from './countries/south_africa.geojson';
import spain from './countries/spain.geojson';
import sri_lanka from './countries/sri_lanka.geojson';
import sudan from './countries/sudan.geojson';
import suriname from './countries/suriname.geojson';
import sweden from './countries/sweden.geojson';
import switzerland from './countries/switzerland.geojson';
import syria from './countries/syria.geojson';
import taiwan from './countries/taiwan.geojson';
import tajikistan from './countries/tajikistan.geojson';
import tanzania from './countries/tanzania.geojson';
import thailand from './countries/thailand.geojson';
import the_bahamas from './countries/the_bahamas.geojson';
import timorleste from './countries/timorleste.geojson';
import togo from './countries/togo.geojson';
import tonga from './countries/tonga.geojson';
import trinidad_and_tobago from './countries/trinidad_and_tobago.geojson';
import tunisia from './countries/tunisia.geojson';
import turkey from './countries/turkey.geojson';
import turkey_regions from './countries/turkey_regions.geojson';
import turkmenistan from './countries/turkmenistan.geojson';
import turks_and_caicos_islands from './countries/turks_and_caicos_islands.geojson';
import uganda from './countries/uganda.geojson';
import uk from './countries/uk.geojson';
import ukraine from './countries/ukraine.geojson';
import united_arab_emirates from './countries/united_arab_emirates.geojson';
import united_states_minor_outlying_islands from './countries/united_states_minor_outlying_islands.geojson';
import united_states_virgin_islands from './countries/united_states_virgin_islands.geojson';
import uruguay from './countries/uruguay.geojson';
import usa from './countries/usa.geojson';
import uzbekistan from './countries/uzbekistan.geojson';
import vanuatu from './countries/vanuatu.geojson';
import venezuela from './countries/venezuela.geojson';
import vietnam from './countries/vietnam.geojson';
import wallis_and_futuna from './countries/wallis_and_futuna.geojson';
import yemen from './countries/yemen.geojson';
import zambia from './countries/zambia.geojson';
import zimbabwe from './countries/zimbabwe.geojson';

export const countries = {
  afghanistan,
  aland,
  albania,
  algeria,
  american_samoa,
  andorra,
  angola,
  anguilla,
  antarctica,
  antigua_and_barbuda,
  argentina,
  armenia,
  australia,
  austria,
  azerbaijan,
  bahrain,
  bangladesh,
  barbados,
  belarus,
  belgium,
  belize,
  benin,
  bermuda,
  bhutan,
  bolivia,
  bosnia_and_herzegovina,
  botswana,
  brazil,
  brunei,
  bulgaria,
  burkina_faso,
  burundi,
  cambodia,
  cameroon,
  canada,
  cape_verde,
  central_african_republic,
  chad,
  chile,
  china,
  colombia,
  comoros,
  cook_islands,
  costa_rica,
  croatia,
  cuba,
  cyprus,
  czech_republic,
  democratic_republic_of_the_congo,
  denmark,
  djibouti,
  dominica,
  dominican_republic,
  ecuador,
  egypt,
  el_salvador,
  equatorial_guinea,
  eritrea,
  estonia,
  ethiopia,
  fiji,
  finland,
  france,
  france_overseas,
  france_regions,
  french_polynesia,
  gabon,
  gambia,
  germany,
  ghana,
  greece,
  greenland,
  grenada,
  guatemala,
  guinea,
  guyana,
  haiti,
  honduras,
  hungary,
  iceland,
  india,
  indonesia,
  iran,
  israel,
  italy,
  italy_regions,
  japan,
  jordan,
  kazakhstan,
  kenya,
  korea,
  kuwait,
  kyrgyzstan,
  laos,
  latvia,
  lebanon,
  lesotho,
  liberia,
  libya,
  liechtenstein,
  lithuania,
  luxembourg,
  macedonia,
  madagascar,
  malawi,
  malaysia,
  maldives,
  mali,
  malta,
  marshall_islands,
  mauritania,
  mauritius,
  mexico,
  moldova,
  mongolia,
  montenegro,
  montserrat,
  morocco,
  mozambique,
  myanmar,
  namibia,
  nauru,
  nepal,
  netherlands,
  new_caledonia,
  new_zealand,
  nicaragua,
  niger,
  nigeria,
  northern_mariana_islands,
  norway,
  oman,
  pakistan,
  palau,
  panama,
  papua_new_guinea,
  paraguay,
  peru,
  philippines,
  philippines_regions,
  poland,
  portugal,
  qatar,
  romania,
  russia,
  rwanda,
  saint_lucia,
  saint_pierre_and_miquelon,
  saint_vincent_and_the_grenadines,
  samoa,
  san_marino,
  sao_tome_and_principe,
  saudi_arabia,
  senegal,
  seychelles,
  sierra_leone,
  singapore,
  slovakia,
  slovenia,
  solomon_islands,
  somalia,
  south_africa,
  spain,
  sri_lanka,
  sudan,
  suriname,
  sweden,
  switzerland,
  syria,
  taiwan,
  tajikistan,
  tanzania,
  thailand,
  the_bahamas,
  timorleste,
  togo,
  tonga,
  trinidad_and_tobago,
  tunisia,
  turkey,
  turkey_regions,
  turkmenistan,
  turks_and_caicos_islands,
  uganda,
  uk,
  ukraine,
  united_arab_emirates,
  united_states_minor_outlying_islands,
  united_states_virgin_islands,
  uruguay,
  usa,
  uzbekistan,
  vanuatu,
  venezuela,
  vietnam,
  wallis_and_futuna,
  yemen,
  zambia,
  zimbabwe,
};

export const countryOptions = Object.keys(countries).map(x => {
  if (x === 'uk' || x === 'usa') {
    return [x, x.toUpperCase()];
  }
  if (x === 'italy_regions') {
    return [x, 'Italy (regions)'];
  }
  if (x === 'france_regions') {
    return [x, 'France (regions)'];
  }
  if (x === 'france_overseas') {
    return [x, 'France (with overseas)'];
  }
  if (x === 'turkey_regions') {
    return [x, 'Turkey (regions)'];
  }
  return [
    x,
    x
      .split('_')
      .map(e => e[0].toUpperCase() + e.slice(1))
      .join(' '),
  ];
});

export default countries;
