/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.event;

import java.io.Serializable;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.Conventions;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.event.ApplicationEvents;
import org.springframework.test.context.event.ApplicationEventsApplicationListener;
import org.springframework.test.context.event.ApplicationEventsHolder;
import org.springframework.test.context.event.RecordApplicationEvents;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.util.Assert;

public class ApplicationEventsTestExecutionListener
extends AbstractTestExecutionListener {
    public static final int ORDER = 1800;
    private static final String RECORD_APPLICATION_EVENTS = Conventions.getQualifiedAttributeName(ApplicationEventsTestExecutionListener.class, (String)"recordApplicationEvents");
    private static final Object applicationEventsMonitor = new Object();

    @Override
    public final int getOrder() {
        return 1800;
    }

    @Override
    public void prepareTestInstance(TestContext testContext) throws Exception {
        if (this.recordApplicationEvents(testContext)) {
            this.registerListenerAndResolvableDependencyIfNecessary(testContext.getApplicationContext());
            ApplicationEventsHolder.registerApplicationEvents();
        }
    }

    @Override
    public void beforeTestMethod(TestContext testContext) throws Exception {
        if (this.recordApplicationEvents(testContext)) {
            ApplicationEventsHolder.registerApplicationEventsIfNecessary();
        }
    }

    @Override
    public void afterTestMethod(TestContext testContext) throws Exception {
        if (this.recordApplicationEvents(testContext)) {
            ApplicationEventsHolder.unregisterApplicationEvents();
        }
    }

    private boolean recordApplicationEvents(TestContext testContext) {
        return (Boolean)testContext.computeAttribute(RECORD_APPLICATION_EVENTS, name -> TestContextAnnotationUtils.hasAnnotation(testContext.getTestClass(), RecordApplicationEvents.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerListenerAndResolvableDependencyIfNecessary(ApplicationContext applicationContext) {
        Assert.isInstanceOf(AbstractApplicationContext.class, (Object)applicationContext, (String)"The ApplicationContext for the test must be an AbstractApplicationContext");
        AbstractApplicationContext aac = (AbstractApplicationContext)applicationContext;
        Object object = applicationEventsMonitor;
        synchronized (object) {
            boolean notAlreadyRegistered = aac.getApplicationListeners().stream().map(Object::getClass).noneMatch(ApplicationEventsApplicationListener.class::equals);
            if (notAlreadyRegistered) {
                aac.addApplicationListener((ApplicationListener)new ApplicationEventsApplicationListener());
                ConfigurableListableBeanFactory beanFactory = aac.getBeanFactory();
                beanFactory.registerResolvableDependency(ApplicationEvents.class, (Object)new ApplicationEventsObjectFactory());
            }
        }
    }

    private static class ApplicationEventsObjectFactory
    implements ObjectFactory<ApplicationEvents>,
    Serializable {
        private ApplicationEventsObjectFactory() {
        }

        public ApplicationEvents getObject() {
            return ApplicationEventsHolder.getRequiredApplicationEvents();
        }

        public String toString() {
            return "Current ApplicationEvents";
        }
    }
}

