/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.Writer;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.PptxCellHelper;
import net.sf.jasperreports.engine.export.ooxml.PptxParagraphHelper;

public class PptxTableHelper
extends BaseHelper {
    private CutsInfo xCuts;
    private PptxCellHelper cellHelper;
    private PptxParagraphHelper paragraphHelper;

    protected PptxTableHelper(JasperReportsContext jasperReportsContext, Writer writer, CutsInfo xCuts) {
        super(jasperReportsContext, writer);
        this.xCuts = xCuts;
        this.cellHelper = new PptxCellHelper(jasperReportsContext, writer);
        this.paragraphHelper = new PptxParagraphHelper(jasperReportsContext, writer);
    }

    public PptxCellHelper getCellHelper() {
        return this.cellHelper;
    }

    public PptxParagraphHelper getParagraphHelper() {
        return this.paragraphHelper;
    }

    public void exportHeader() {
        this.write("  <a:tbl>\n");
        this.write("   <a:tblPr>\n");
        this.write("   <a:tableStyleId>{2D5ABB26-0587-4C30-8999-92F81FD0307C}</a:tableStyleId>\n");
        this.write("   </a:tblPr>\n");
        this.write("   <a:tblGrid>\n");
        for (int col = 1; col < this.xCuts.size(); ++col) {
            this.write("    <a:gridCol w=\"" + LengthUtil.emu(this.xCuts.getCutOffset(col) - this.xCuts.getCutOffset(col - 1)) + "\"/>\n");
        }
        this.write("   </a:tblGrid>\n");
    }

    public void exportFooter() {
        this.write("  </a:tbl>\n");
    }

    public void exportRowHeader(int rowHeight) {
        this.write("   <a:tr h=\"" + LengthUtil.emu(rowHeight) + "\">\n");
    }

    public void exportRowFooter() {
        this.write("   </a:tr>\n");
    }

    public void exportEmptyCell(JRExporterGridCell gridCell, JRExporterGridCell topGridCell, JRExporterGridCell leftGridCell, JRExporterGridCell rightGridCell, JRExporterGridCell bottomGridCell) {
        this.cellHelper.exportHeader(gridCell);
        this.paragraphHelper.exportEmptyParagraph();
        this.write("  <a:tcPr marL=\"0\" marR=\"0\" marT=\"0\" marB=\"0\">\n");
        this.cellHelper.getBorderHelper().exportBorder(gridCell, topGridCell, leftGridCell, rightGridCell, bottomGridCell);
        this.cellHelper.exportBackcolor(gridCell);
        this.write("  </a:tcPr>\n");
        this.cellHelper.exportFooter();
    }

    public void exportOccupiedCells(JRExporterGridCell gridCell, JRExporterGridCell topGridCell, JRExporterGridCell leftGridCell, JRExporterGridCell rightGridCell, JRExporterGridCell bottomGridCell) {
        this.write("    <a:tc hMerge=\"1\">\n");
        this.paragraphHelper.exportEmptyParagraph();
        this.write("  <a:tcPr marL=\"0\" marR=\"0\" marT=\"0\" marB=\"0\">\n");
        this.cellHelper.getBorderHelper().exportBorder(gridCell, topGridCell, leftGridCell, rightGridCell, bottomGridCell);
        this.cellHelper.exportBackcolor(gridCell);
        this.write("  </a:tcPr>\n");
        this.cellHelper.exportFooter();
    }
}

