/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.classworlds.DuplicateRealmException;
import org.codehaus.classworlds.NoSuchRealmException;
import org.codehaus.plexus.ComponentLookupManager;
import org.codehaus.plexus.DuplicateChildContainerException;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.composition.ComponentComposerManager;
import org.codehaus.plexus.component.composition.CompositionException;
import org.codehaus.plexus.component.composition.SetterComponentComposer;
import org.codehaus.plexus.component.configurator.BasicComponentConfigurator;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.discovery.ComponentDiscovererManager;
import org.codehaus.plexus.component.discovery.ComponentDiscoveryListener;
import org.codehaus.plexus.component.discovery.PlexusXmlComponentDiscoverer;
import org.codehaus.plexus.component.factory.ComponentFactoryManager;
import org.codehaus.plexus.component.manager.ComponentManager;
import org.codehaus.plexus.component.manager.ComponentManagerManager;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRepository;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.component.repository.exception.ComponentRepositoryException;
import org.codehaus.plexus.component.repository.io.PlexusTools;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.configuration.PlexusConfigurationMerger;
import org.codehaus.plexus.configuration.PlexusConfigurationResourceException;
import org.codehaus.plexus.configuration.processor.ConfigurationProcessingException;
import org.codehaus.plexus.configuration.processor.ConfigurationProcessor;
import org.codehaus.plexus.configuration.processor.ConfigurationResourceNotFoundException;
import org.codehaus.plexus.configuration.processor.DirectoryConfigurationResourceHandler;
import org.codehaus.plexus.configuration.processor.FileConfigurationResourceHandler;
import org.codehaus.plexus.container.initialization.ComponentDiscoveryPhase;
import org.codehaus.plexus.container.initialization.ContainerInitializationContext;
import org.codehaus.plexus.container.initialization.ContainerInitializationException;
import org.codehaus.plexus.container.initialization.ContainerInitializationPhase;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.context.ContextMapAdapter;
import org.codehaus.plexus.context.DefaultContext;
import org.codehaus.plexus.lifecycle.LifecycleHandlerManager;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;

public class DefaultPlexusContainer
extends AbstractLogEnabled
implements MutablePlexusContainer {
    protected String name;
    protected PlexusContainer parentContainer;
    protected DefaultContext context;
    protected PlexusConfiguration configuration;
    protected Reader configurationReader;
    protected ClassWorld classWorld;
    protected ClassRealm containerRealm;
    protected List initializationPhases;
    protected ComponentRepository componentRepository;
    protected ComponentManagerManager componentManagerManager;
    protected LifecycleHandlerManager lifecycleHandlerManager;
    protected ComponentDiscovererManager componentDiscovererManager;
    protected ComponentFactoryManager componentFactoryManager;
    protected ComponentLookupManager componentLookupManager;
    protected ComponentComposerManager componentComposerManager;
    protected LoggerManager loggerManager;
    protected Map childContainers = new WeakHashMap();
    protected Date creationDate = new Date();
    protected boolean reloadingEnabled;

    public DefaultPlexusContainer() throws PlexusContainerException {
        this("default");
    }

    public DefaultPlexusContainer(Reader configurationReader, Map context) throws PlexusContainerException {
        this("default", Thread.currentThread().getContextClassLoader(), configurationReader, context);
    }

    public DefaultPlexusContainer(String name) throws PlexusContainerException {
        this(name, new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader()));
    }

    public DefaultPlexusContainer(String name, ClassLoader classLoader) throws PlexusContainerException {
        this(name, new ClassWorld("plexus.core", classLoader));
    }

    public DefaultPlexusContainer(String name, ClassLoader classLoader, Reader configurationReader, Map context) throws PlexusContainerException {
        this(name, new ClassWorld("plexus.core", classLoader), configurationReader, context);
    }

    public DefaultPlexusContainer(String name, ClassWorld classWorld, PlexusContainer parentContainer) throws PlexusContainerException {
        this(name, classWorld);
        this.parentContainer = parentContainer;
    }

    public DefaultPlexusContainer(String name, ClassWorld classWorld) throws PlexusContainerException {
        this(name, classWorld, null, null);
    }

    private DefaultPlexusContainer(String name, ClassWorld classWorld, Reader configurationReader, Map context) throws PlexusContainerException {
        this.name = name;
        this.classWorld = classWorld;
        this.context = new DefaultContext();
        if (context != null) {
            Iterator i = context.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                this.context.put(entry.getKey(), entry.getValue());
            }
        }
        this.configurationReader = configurationReader;
        this.initialize();
        this.start();
    }

    public Object lookup(String componentKey) throws ComponentLookupException {
        return this.componentLookupManager.lookup(componentKey);
    }

    public Map lookupMap(String role) throws ComponentLookupException {
        return this.componentLookupManager.lookupMap(role);
    }

    public List lookupList(String role) throws ComponentLookupException {
        return this.componentLookupManager.lookupList(role);
    }

    public Object lookup(String role, String roleHint) throws ComponentLookupException {
        return this.componentLookupManager.lookup(role, roleHint);
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public boolean hasChildContainer(String name) {
        return this.childContainers.get(name) != null;
    }

    public void removeChildContainer(String name) {
        this.childContainers.remove(name);
    }

    public PlexusContainer getChildContainer(String name) {
        return (PlexusContainer)this.childContainers.get(name);
    }

    public PlexusContainer createChildContainer(String name, List classpathJars, Map context) throws PlexusContainerException {
        return this.createChildContainer(name, classpathJars, context, Collections.EMPTY_LIST);
    }

    public PlexusContainer createChildContainer(String name, List classpathJars, Map context, List discoveryListeners) throws PlexusContainerException {
        if (this.hasChildContainer(name)) {
            throw new DuplicateChildContainerException(this.getName(), name);
        }
        DefaultPlexusContainer child = new DefaultPlexusContainer(name, this.classWorld, this);
        child.classWorld = this.classWorld;
        ClassRealm childRealm = null;
        String childRealmId = this.getName() + ".child-container[" + name + "]";
        try {
            childRealm = this.classWorld.getRealm(childRealmId);
        }
        catch (NoSuchRealmException e) {
            try {
                childRealm = this.classWorld.newRealm(childRealmId);
            }
            catch (DuplicateRealmException impossibleError) {
                this.getLogger().error("An impossible error has occurred. After getRealm() failed, newRealm() produced duplication error on same id!", impossibleError);
            }
        }
        childRealm.setParent(this.containerRealm);
        child.containerRealm = childRealm;
        child.setLoggerManager(this.loggerManager);
        Iterator it = context.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            child.addContextValue(entry.getKey(), entry.getValue());
        }
        child.initialize();
        it = classpathJars.iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            File jar = (File)((Object)next);
            child.addJarResource(jar);
        }
        it = discoveryListeners.iterator();
        while (it.hasNext()) {
            ComponentDiscoveryListener listener = (ComponentDiscoveryListener)((Object)it.next());
            child.registerComponentDiscoveryListener(listener);
        }
        child.start();
        this.childContainers.put(name, child);
        return child;
    }

    public ComponentDescriptor getComponentDescriptor(String componentKey) {
        ComponentDescriptor result = this.componentRepository.getComponentDescriptor(componentKey);
        if (result == null && this.parentContainer != null) {
            result = this.parentContainer.getComponentDescriptor(componentKey);
        }
        return result;
    }

    public Map getComponentDescriptorMap(String role) {
        Map componentDescriptors;
        Map result = null;
        if (this.parentContainer != null) {
            result = this.parentContainer.getComponentDescriptorMap(role);
        }
        if ((componentDescriptors = this.componentRepository.getComponentDescriptorMap(role)) != null) {
            if (result != null) {
                result.putAll(componentDescriptors);
            } else {
                result = componentDescriptors;
            }
        }
        return result;
    }

    public List getComponentDescriptorList(String role) {
        ComponentDescriptor unhintedDescriptor;
        Map componentDescriptorsByHint = this.getComponentDescriptorMap(role);
        List<Object> result = componentDescriptorsByHint != null ? new ArrayList(componentDescriptorsByHint.values()) : ((unhintedDescriptor = this.getComponentDescriptor(role)) != null ? Collections.singletonList(unhintedDescriptor) : Collections.EMPTY_LIST);
        return result;
    }

    public void addComponentDescriptor(ComponentDescriptor componentDescriptor) throws ComponentRepositoryException {
        this.componentRepository.addComponentDescriptor(componentDescriptor);
    }

    public void release(Object component) throws ComponentLifecycleException {
        if (component == null) {
            return;
        }
        ComponentManager componentManager = this.componentManagerManager.findComponentManagerByComponentInstance(component);
        if (componentManager == null) {
            if (this.parentContainer != null) {
                this.parentContainer.release(component);
            } else {
                this.getLogger().warn("Component manager not found for returned component. Ignored. component=" + component);
            }
        } else {
            componentManager.release(component);
            if (componentManager.getConnections() <= 0) {
                this.componentManagerManager.unassociateComponentWithComponentManager(component);
            }
        }
    }

    public void releaseAll(Map components) throws ComponentLifecycleException {
        Iterator i = components.values().iterator();
        while (i.hasNext()) {
            Object component = i.next();
            this.release(component);
        }
    }

    public void releaseAll(List components) throws ComponentLifecycleException {
        Iterator i = components.iterator();
        while (i.hasNext()) {
            Object component = i.next();
            this.release(component);
        }
    }

    public boolean hasComponent(String componentKey) {
        return this.componentRepository.hasComponent(componentKey);
    }

    public boolean hasComponent(String role, String roleHint) {
        return this.componentRepository.hasComponent(role, roleHint);
    }

    public void suspend(Object component) throws ComponentLifecycleException {
        if (component == null) {
            return;
        }
        ComponentManager componentManager = this.componentManagerManager.findComponentManagerByComponentInstance(component);
        componentManager.suspend(component);
    }

    public void resume(Object component) throws ComponentLifecycleException {
        if (component == null) {
            return;
        }
        ComponentManager componentManager = this.componentManagerManager.findComponentManagerByComponentInstance(component);
        componentManager.resume(component);
    }

    public void initialize() throws PlexusContainerException {
        this.containerRealm = (ClassRealm)this.classWorld.getRealms().iterator().next();
        try {
            this.initializeConfiguration();
            this.initializePhases();
        }
        catch (ContextException e) {
            e.printStackTrace();
            throw new PlexusContainerException("Error processing configuration", e);
        }
        catch (ConfigurationProcessingException e) {
            throw new PlexusContainerException("Error processing configuration", e);
        }
        catch (ConfigurationResourceNotFoundException e) {
            throw new PlexusContainerException("Error processing configuration", e);
        }
        catch (PlexusConfigurationException e) {
            throw new PlexusContainerException("Error configuring components", e);
        }
    }

    public void initializePhases() throws PlexusContainerException {
        PlexusConfiguration initializationConfiguration = this.configuration.getChild("container-initialization");
        ContainerInitializationContext initializationContext = new ContainerInitializationContext(this, this.classWorld, this.containerRealm, this.configuration);
        BasicComponentConfigurator c = new BasicComponentConfigurator();
        try {
            c.configureComponent(this, initializationConfiguration, this.containerRealm);
        }
        catch (ComponentConfigurationException e) {
            throw new PlexusContainerException("Error setting container initialization initializationPhases.", e);
        }
        Iterator iterator = this.initializationPhases.iterator();
        while (iterator.hasNext()) {
            ContainerInitializationPhase phase = (ContainerInitializationPhase)iterator.next();
            try {
                phase.execute(initializationContext);
            }
            catch (ContainerInitializationException e) {
                throw new PlexusContainerException("Error initializaing container in " + phase + ".", e);
            }
        }
    }

    public List discoverComponents(ClassRealm classRealm) throws PlexusConfigurationException, ComponentRepositoryException {
        return ComponentDiscoveryPhase.discoverComponents(this);
    }

    public void start() throws PlexusContainerException {
        this.configuration = null;
    }

    public void dispose() {
        this.disposeAllComponents();
        boolean needToDisposeRealm = true;
        if (this.parentContainer != null && this.containerRealm.getId().equals(this.parentContainer.getContainerRealm().getId())) {
            needToDisposeRealm = false;
        }
        if (this.parentContainer != null) {
            this.parentContainer.removeChildContainer(this.getName());
            this.parentContainer = null;
        }
        try {
            this.containerRealm.setParent(null);
            if (needToDisposeRealm) {
                this.classWorld.disposeRealm(this.containerRealm.getId());
            }
        }
        catch (NoSuchRealmException e) {
            this.getLogger().debug("Failed to dispose realm for exiting container: " + this.getName(), e);
        }
    }

    protected void disposeAllComponents() {
        ArrayList collection = new ArrayList(this.componentManagerManager.getComponentManagers().values());
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            try {
                ((ComponentManager)iter.next()).dispose();
            }
            catch (Exception e) {
                this.getLogger().error("Error while disposing component manager. Continuing with the rest", e);
            }
        }
        this.componentManagerManager.getComponentManagers().clear();
    }

    public void addContextValue(Object key, Object value) {
        this.context.put(key, value);
    }

    public void setConfigurationResource(Reader configuration) throws PlexusConfigurationResourceException {
        this.configurationReader = configuration;
    }

    public String getName() {
        return this.name;
    }

    public ClassWorld getClassWorld() {
        return this.classWorld;
    }

    public void setClassWorld(ClassWorld classWorld) {
        this.classWorld = classWorld;
    }

    public ClassRealm getContainerRealm() {
        return this.containerRealm;
    }

    public void setContainerRealm(ClassRealm containerRealm) {
        this.containerRealm = containerRealm;
    }

    public Context getContext() {
        return this.context;
    }

    protected void initializeConfiguration() throws ConfigurationProcessingException, ConfigurationResourceNotFoundException, PlexusConfigurationException, ContextException {
        PlexusXmlComponentDiscoverer discoverer;
        PlexusConfiguration plexusConfiguration;
        PlexusConfiguration bootstrapConfiguration;
        InputStream is = this.containerRealm.getResourceAsStream("org/codehaus/plexus/plexus-bootstrap.xml");
        if (is == null) {
            throw new IllegalStateException("The internal default plexus-bootstrap.xml is missing. This is highly irregular, your plexus JAR is most likely corrupt.");
        }
        this.configuration = bootstrapConfiguration = PlexusTools.buildConfiguration("org/codehaus/plexus/plexus-bootstrap.xml", new InputStreamReader(is));
        if (!(this.context.contains("plexus.ignoreContainerConfiguration") && this.context.get("plexus.ignoreContainerConfiguration") == Boolean.TRUE || (plexusConfiguration = (discoverer = new PlexusXmlComponentDiscoverer()).discoverConfiguration(this.getContext(), this.containerRealm)) == null)) {
            this.configuration = PlexusConfigurationMerger.merge(plexusConfiguration, this.configuration);
            this.processConfigurationsDirectory();
        }
        if (this.configurationReader != null) {
            PlexusConfiguration userConfiguration = PlexusTools.buildConfiguration("<User Specified Configuration Reader>", this.getInterpolationConfigurationReader(this.configurationReader));
            this.configuration = PlexusConfigurationMerger.merge(userConfiguration, this.configuration);
            this.processConfigurationsDirectory();
        }
        ConfigurationProcessor p = new ConfigurationProcessor();
        p.addConfigurationResourceHandler(new FileConfigurationResourceHandler());
        p.addConfigurationResourceHandler(new DirectoryConfigurationResourceHandler());
        this.configuration = p.process(this.configuration, Collections.EMPTY_MAP);
    }

    protected Reader getInterpolationConfigurationReader(Reader reader) {
        return new InterpolationFilterReader(reader, (Map)new ContextMapAdapter(this.context));
    }

    private void processConfigurationsDirectory() throws PlexusConfigurationException {
        String s = this.configuration.getChild("configurations-directory").getValue(null);
        if (s != null) {
            PlexusConfiguration componentsConfiguration = this.configuration.getChild("components");
            File configurationsDirectory = new File(s);
            if (configurationsDirectory.exists() && configurationsDirectory.isDirectory()) {
                List componentConfigurationFiles;
                try {
                    componentConfigurationFiles = FileUtils.getFiles((File)configurationsDirectory, (String)"**/*.conf", (String)"**/*.xml");
                }
                catch (IOException e) {
                    throw new PlexusConfigurationException("Unable to locate configuration files", e);
                }
                Iterator i = componentConfigurationFiles.iterator();
                while (i.hasNext()) {
                    File componentConfigurationFile = (File)i.next();
                    FileReader reader = null;
                    try {
                        reader = new FileReader(componentConfigurationFile);
                        PlexusConfiguration componentConfiguration = PlexusTools.buildConfiguration(componentConfigurationFile.getAbsolutePath(), this.getInterpolationConfigurationReader(reader));
                        componentsConfiguration.addChild(componentConfiguration.getChild("components"));
                    }
                    catch (FileNotFoundException e) {
                        try {
                            throw new PlexusConfigurationException("File " + componentConfigurationFile + " disappeared before processing", e);
                        }
                        catch (Throwable throwable) {
                            IOUtil.close(reader);
                            throw throwable;
                        }
                    }
                    IOUtil.close((Reader)reader);
                }
            }
        }
    }

    public void addJarResource(File jar) throws PlexusContainerException {
        try {
            this.containerRealm.addConstituent(jar.toURI().toURL());
            this.discoverComponents(this.containerRealm);
        }
        catch (MalformedURLException e) {
            throw new PlexusContainerException("Cannot add jar resource: " + jar + " (bad URL)", e);
        }
        catch (PlexusConfigurationException e) {
            throw new PlexusContainerException("Cannot add jar resource: " + jar + " (error discovering new components)", e);
        }
        catch (ComponentRepositoryException e) {
            throw new PlexusContainerException("Cannot add jar resource: " + jar + " (error discovering new components)", e);
        }
    }

    public void addJarRepository(File repository) {
        if (repository.exists() && repository.isDirectory()) {
            File[] jars = repository.listFiles();
            for (int j = 0; j < jars.length; ++j) {
                if (!jars[j].getAbsolutePath().endsWith(".jar")) continue;
                try {
                    this.addJarResource(jars[j]);
                    continue;
                }
                catch (PlexusContainerException e) {
                    this.getLogger().warn("Unable to add JAR: " + jars[j], e);
                }
            }
        } else {
            String message = "The specified JAR repository doesn't exist or is not a directory: '" + repository.getAbsolutePath() + "'.";
            if (this.getLogger() != null) {
                this.getLogger().warn(message);
            } else {
                System.out.println(message);
            }
        }
    }

    public Logger getLogger() {
        return super.getLogger();
    }

    public void registerComponentDiscoveryListener(ComponentDiscoveryListener listener) {
        this.componentDiscovererManager.registerComponentDiscoveryListener(listener);
    }

    public void removeComponentDiscoveryListener(ComponentDiscoveryListener listener) {
        this.componentDiscovererManager.removeComponentDiscoveryListener(listener);
    }

    public Object autowire(Object component) throws CompositionException {
        SetterComponentComposer composer = new SetterComponentComposer();
        composer.assembleComponent(component, null, this);
        return component;
    }

    public Object createAndAutowire(String clazz) throws CompositionException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Object component = this.containerRealm.loadClass(clazz).newInstance();
        SetterComponentComposer composer = new SetterComponentComposer();
        composer.assembleComponent(component, null, this);
        return component;
    }

    public void setReloadingEnabled(boolean reloadingEnabled) {
        this.reloadingEnabled = reloadingEnabled;
    }

    public boolean isReloadingEnabled() {
        return this.reloadingEnabled;
    }

    public ComponentRepository getComponentRepository() {
        return this.componentRepository;
    }

    public void setComponentRepository(ComponentRepository componentRepository) {
        this.componentRepository = componentRepository;
    }

    public ComponentManagerManager getComponentManagerManager() {
        return this.componentManagerManager;
    }

    public void setComponentManagerManager(ComponentManagerManager componentManagerManager) {
        this.componentManagerManager = componentManagerManager;
    }

    public LifecycleHandlerManager getLifecycleHandlerManager() {
        return this.lifecycleHandlerManager;
    }

    public void setLifecycleHandlerManager(LifecycleHandlerManager lifecycleHandlerManager) {
        this.lifecycleHandlerManager = lifecycleHandlerManager;
    }

    public ComponentDiscovererManager getComponentDiscovererManager() {
        return this.componentDiscovererManager;
    }

    public void setComponentDiscovererManager(ComponentDiscovererManager componentDiscovererManager) {
        this.componentDiscovererManager = componentDiscovererManager;
    }

    public ComponentFactoryManager getComponentFactoryManager() {
        return this.componentFactoryManager;
    }

    public void setComponentFactoryManager(ComponentFactoryManager componentFactoryManager) {
        this.componentFactoryManager = componentFactoryManager;
    }

    public ComponentLookupManager getComponentLookupManager() {
        return this.componentLookupManager;
    }

    public void setComponentLookupManager(ComponentLookupManager componentLookupManager) {
        this.componentLookupManager = componentLookupManager;
    }

    public ComponentComposerManager getComponentComposerManager() {
        return this.componentComposerManager;
    }

    public void setComponentComposerManager(ComponentComposerManager componentComposerManager) {
        this.componentComposerManager = componentComposerManager;
    }

    public LoggerManager getLoggerManager() {
        return this.loggerManager;
    }

    public void setLoggerManager(LoggerManager loggerManager) {
        this.loggerManager = loggerManager;
    }

    public PlexusConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(PlexusConfiguration configuration) {
        this.configuration = configuration;
    }

    public PlexusContainer getParentContainer() {
        return this.parentContainer;
    }
}

