/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.tiles;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.TextProviderFactory;
import com.opensymphony.xwork2.config.ConfigurationException;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.tiles.core.evaluator.AbstractAttributeEvaluator;
import org.apache.tiles.request.Request;
import org.apache.tiles.request.servlet.ServletUtil;

public class I18NAttributeEvaluator
extends AbstractAttributeEvaluator {
    private static final Logger LOG = LogManager.getLogger(I18NAttributeEvaluator.class);

    @Override
    public Object evaluate(String expression, Request request) {
        String result = expression;
        HttpServletRequest httpRequest = ServletUtil.getServletRequest(request).getRequest();
        ActionContext ctx = ServletActionContext.getActionContext((HttpServletRequest)httpRequest);
        if (ctx == null) {
            LOG.error("Cannot obtain HttpServletRequest from [{}]", (Object)request.getClass().getName());
            throw new ConfigurationException("There is no ActionContext for current request!");
        }
        TextProviderFactory tpf = (TextProviderFactory)ctx.getContainer().getInstance(TextProviderFactory.class);
        TextProvider textProvider = tpf.createInstance(ctx.getActionInvocation().getAction().getClass());
        if (textProvider != null) {
            LOG.debug("Trying find text [{}] using TextProvider {}", (Object)expression, (Object)textProvider);
            result = textProvider.getText(expression);
        }
        return result;
    }
}

