/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputLocationTracker;
import org.apache.maven.model.ReportSet;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportPlugin
implements Serializable,
Cloneable,
InputLocationTracker {
    private String groupId = "org.apache.maven.plugins";
    private String artifactId;
    private String version;
    private String inherited;
    private Object configuration;
    private List<ReportSet> reportSets;
    private Map<Object, InputLocation> locations;
    private Map<String, ReportSet> reportSetMap = null;
    private boolean inheritanceApplied = true;

    public void addReportSet(ReportSet reportSet) {
        this.getReportSets().add(reportSet);
    }

    public ReportPlugin clone() {
        try {
            ReportPlugin copy = (ReportPlugin)super.clone();
            if (this.configuration != null) {
                copy.configuration = new Xpp3Dom((Xpp3Dom)this.configuration);
            }
            if (this.reportSets != null) {
                copy.reportSets = new ArrayList<ReportSet>();
                for (ReportSet item : this.reportSets) {
                    copy.reportSets.add(item.clone());
                }
            }
            if (copy.locations != null) {
                copy.locations = new LinkedHashMap<Object, InputLocation>(copy.locations);
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public Object getConfiguration() {
        return this.configuration;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getInherited() {
        return this.inherited;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public List<ReportSet> getReportSets() {
        if (this.reportSets == null) {
            this.reportSets = new ArrayList<ReportSet>();
        }
        return this.reportSets;
    }

    public String getVersion() {
        return this.version;
    }

    public void removeReportSet(ReportSet reportSet) {
        this.getReportSets().remove(reportSet);
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setConfiguration(Object configuration) {
        this.configuration = configuration;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setInherited(String inherited) {
        this.inherited = inherited;
    }

    @Override
    public void setLocation(Object key, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key, location);
        }
    }

    public void setReportSets(List<ReportSet> reportSets) {
        this.reportSets = reportSets;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void flushReportSetMap() {
        this.reportSetMap = null;
    }

    public Map<String, ReportSet> getReportSetsAsMap() {
        if (this.reportSetMap == null) {
            this.reportSetMap = new LinkedHashMap<String, ReportSet>();
            if (this.getReportSets() != null) {
                for (ReportSet reportSet : this.getReportSets()) {
                    this.reportSetMap.put(reportSet.getId(), reportSet);
                }
            }
        }
        return this.reportSetMap;
    }

    public String getKey() {
        return ReportPlugin.constructKey(this.groupId, this.artifactId);
    }

    public static String constructKey(String groupId, String artifactId) {
        return groupId + ":" + artifactId;
    }

    public boolean isInherited() {
        return this.inherited != null ? Boolean.parseBoolean(this.inherited) : true;
    }

    public void setInherited(boolean inherited) {
        this.inherited = String.valueOf(inherited);
    }

    public void unsetInheritanceApplied() {
        this.inheritanceApplied = false;
    }

    public boolean isInheritanceApplied() {
        return this.inheritanceApplied;
    }
}

