/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.BackendWritableBroadcastState;
import org.apache.flink.runtime.state.RegisteredBroadcastStateBackendMetaInfo;
import org.apache.flink.util.Preconditions;

public class HeapBroadcastState<K, V>
implements BackendWritableBroadcastState<K, V> {
    private RegisteredBroadcastStateBackendMetaInfo<K, V> stateMetaInfo;
    private final Map<K, V> backingMap;
    private final MapSerializer<K, V> internalMapCopySerializer;

    HeapBroadcastState(RegisteredBroadcastStateBackendMetaInfo<K, V> stateMetaInfo) {
        this(stateMetaInfo, new HashMap());
    }

    private HeapBroadcastState(RegisteredBroadcastStateBackendMetaInfo<K, V> stateMetaInfo, Map<K, V> internalMap) {
        this.stateMetaInfo = (RegisteredBroadcastStateBackendMetaInfo)Preconditions.checkNotNull(stateMetaInfo);
        this.backingMap = (Map)Preconditions.checkNotNull(internalMap);
        this.internalMapCopySerializer = new MapSerializer(stateMetaInfo.getKeySerializer(), stateMetaInfo.getValueSerializer());
    }

    private HeapBroadcastState(HeapBroadcastState<K, V> toCopy) {
        this(toCopy.stateMetaInfo.deepCopy(), toCopy.internalMapCopySerializer.copy(toCopy.backingMap));
    }

    @Override
    public void setStateMetaInfo(RegisteredBroadcastStateBackendMetaInfo<K, V> stateMetaInfo) {
        this.stateMetaInfo = stateMetaInfo;
    }

    @Override
    public RegisteredBroadcastStateBackendMetaInfo<K, V> getStateMetaInfo() {
        return this.stateMetaInfo;
    }

    @Override
    public HeapBroadcastState<K, V> deepCopy() {
        return new HeapBroadcastState<K, V>(this);
    }

    public void clear() {
        this.backingMap.clear();
    }

    public String toString() {
        return "HeapBroadcastState{stateMetaInfo=" + this.stateMetaInfo + ", backingMap=" + this.backingMap + ", internalMapCopySerializer=" + this.internalMapCopySerializer + '}';
    }

    @Override
    public long write(FSDataOutputStream out) throws IOException {
        long partitionOffset = out.getPos();
        DataOutputViewStreamWrapper dov = new DataOutputViewStreamWrapper((OutputStream)out);
        dov.writeInt(this.backingMap.size());
        for (Map.Entry<K, V> entry : this.backingMap.entrySet()) {
            this.getStateMetaInfo().getKeySerializer().serialize(entry.getKey(), (DataOutputView)dov);
            this.getStateMetaInfo().getValueSerializer().serialize(entry.getValue(), (DataOutputView)dov);
        }
        return partitionOffset;
    }

    public V get(K key) {
        return this.backingMap.get(key);
    }

    public void put(K key, V value) {
        this.backingMap.put(key, value);
    }

    public void putAll(Map<K, V> map) {
        this.backingMap.putAll(map);
    }

    public void remove(K key) {
        this.backingMap.remove(key);
    }

    public boolean contains(K key) {
        return this.backingMap.containsKey(key);
    }

    public Iterator<Map.Entry<K, V>> iterator() {
        return this.backingMap.entrySet().iterator();
    }

    public Iterable<Map.Entry<K, V>> entries() {
        return this.backingMap.entrySet();
    }

    public Iterable<Map.Entry<K, V>> immutableEntries() {
        return Collections.unmodifiableSet(this.backingMap.entrySet());
    }
}

