/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import org.apache.flink.util.ExceptionUtils;
import org.slf4j.Logger;

public final class IOUtils {
    private static final int BLOCKSIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyBytes(InputStream in, OutputStream out, int buffSize, boolean close) throws IOException {
        PrintStream ps = out instanceof PrintStream ? (PrintStream)out : null;
        byte[] buf = new byte[buffSize];
        try {
            int bytesRead = in.read(buf);
            while (bytesRead >= 0) {
                out.write(buf, 0, bytesRead);
                if (ps != null && ps.checkError()) {
                    throw new IOException("Unable to write to output stream.");
                }
                bytesRead = in.read(buf);
            }
        }
        finally {
            if (close) {
                out.close();
                in.close();
            }
        }
    }

    public static void copyBytes(InputStream in, OutputStream out) throws IOException {
        IOUtils.copyBytes(in, out, 4096, true);
    }

    public static void copyBytes(InputStream in, OutputStream out, boolean close) throws IOException {
        IOUtils.copyBytes(in, out, 4096, close);
    }

    public static void readFully(InputStream in, byte[] buf, int off, int len) throws IOException {
        int toRead = len;
        while (toRead > 0) {
            int ret = in.read(buf, off, toRead);
            if (ret < 0) {
                throw new IOException("Premeture EOF from inputStream");
            }
            toRead -= ret;
            off += ret;
        }
    }

    public static int tryReadFully(InputStream in, byte[] buf) throws IOException {
        int totalRead;
        int read;
        for (totalRead = 0; totalRead != buf.length && (read = in.read(buf, totalRead, buf.length - totalRead)) != -1; totalRead += read) {
        }
        return totalRead;
    }

    public static void skipFully(InputStream in, long len) throws IOException {
        while (len > 0L) {
            long ret = in.skip(len);
            if (ret < 0L) {
                throw new IOException("Premeture EOF from inputStream");
            }
            len -= ret;
        }
    }

    public static void cleanup(Logger log, AutoCloseable ... closeables) {
        for (AutoCloseable c : closeables) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (Exception e) {
                if (log == null || !log.isDebugEnabled()) continue;
                log.debug("Exception in closing " + c, (Throwable)e);
            }
        }
    }

    public static void closeStream(Closeable stream) {
        IOUtils.cleanup(null, stream);
    }

    public static void closeSocket(Socket sock) {
        if (sock != null) {
            try {
                sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeAll(AutoCloseable ... closeables) throws Exception {
        IOUtils.closeAll(Arrays.asList(closeables));
    }

    public static void closeAll(Iterable<? extends AutoCloseable> closeables) throws Exception {
        if (null != closeables) {
            Exception collectedExceptions = null;
            for (AutoCloseable autoCloseable : closeables) {
                try {
                    if (null == autoCloseable) continue;
                    autoCloseable.close();
                }
                catch (Exception e) {
                    collectedExceptions = ExceptionUtils.firstOrSuppressed(e, collectedExceptions);
                }
            }
            if (null != collectedExceptions) {
                throw collectedExceptions;
            }
        }
    }

    public static void closeAllQuietly(AutoCloseable ... closeables) {
        IOUtils.closeAllQuietly(Arrays.asList(closeables));
    }

    public static void closeAllQuietly(Iterable<? extends AutoCloseable> closeables) {
        if (null != closeables) {
            for (AutoCloseable autoCloseable : closeables) {
                IOUtils.closeQuietly(autoCloseable);
            }
        }
    }

    public static void closeQuietly(AutoCloseable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void deleteFileQuietly(Path path) {
        try {
            Files.deleteIfExists(path);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private IOUtils() {
    }
}

