/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.codec.digest.MessageDigestAlgorithms;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Sha2$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(expr, bitLength) - Returns a checksum of SHA-2 family as a hex string of `expr`.\n      SHA-224, SHA-256, SHA-384, and SHA-512 are supported. Bit length of 0 is equivalent to 256.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('Spark', 256);\n       529bc3b07127ecb7e53a4dcf1991d9152c24537d919178022b2c42657f79a26b\n  ", since="1.5.0", group="hash_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001\u0002\u000f\u001e\u0001*B\u0001B\u0011\u0001\u0003\u0016\u0004%\ta\u0011\u0005\t\u000f\u0002\u0011\t\u0012)A\u0005\t\"A\u0001\n\u0001BK\u0002\u0013\u00051\t\u0003\u0005J\u0001\tE\t\u0015!\u0003E\u0011\u0015Q\u0005\u0001\"\u0001L\u0011\u0015y\u0005\u0001\"\u0011Q\u0011\u00159\u0006\u0001\"\u0011Y\u0011\u0015a\u0006\u0001\"\u0011^\u0011\u0015I\u0007\u0001\"\u0015k\u0011\u0015\u0011\b\u0001\"\u0011t\u0011\u001d\t\u0019\u0001\u0001C)\u0003\u000bA\u0011\"a\u0004\u0001\u0003\u0003%\t!!\u0005\t\u0013\u0005]\u0001!%A\u0005\u0002\u0005e\u0001\"CA\u0018\u0001E\u0005I\u0011AA\r\u0011%\t\t\u0004AA\u0001\n\u0003\n\u0019\u0004C\u0005\u0002F\u0001\t\t\u0011\"\u0001\u0002H!I\u0011q\n\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u000b\u0005\n\u0003/\u0002\u0011\u0011!C!\u00033B\u0011\"a\u001a\u0001\u0003\u0003%\t!!\u001b\t\u0013\u00055\u0004!!A\u0005B\u0005=t!CAJ;\u0005\u0005\t\u0012AAK\r!aR$!A\t\u0002\u0005]\u0005B\u0002&\u0017\t\u0003\t)\u000bC\u0005\u0002(Z\t\t\u0011\"\u0012\u0002*\"I\u00111\u0016\f\u0002\u0002\u0013\u0005\u0015Q\u0016\u0005\n\u0003g3\u0012\u0011!CA\u0003kC\u0011\"a2\u0017\u0003\u0003%I!!3\u0003\tMC\u0017M\r\u0006\u0003=}\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0001%I\u0001\tG\u0006$\u0018\r\\=ti*\u0011!eI\u0001\u0004gFd'B\u0001\u0013&\u0003\u0015\u0019\b/\u0019:l\u0015\t1s%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Q\u0005\u0019qN]4\u0004\u0001M1\u0001aK\u00183s}\u0002\"\u0001L\u0017\u000e\u0003uI!AL\u000f\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u00171\u0013\t\tTD\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\t\u0019dG\u0004\u0002-i%\u0011Q'H\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0004H\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u0005Uj\u0002C\u0001\u001e>\u001b\u0005Y$\"\u0001\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yZ$\u0001D*fe&\fG.\u001b>bE2,\u0007C\u0001\u001eA\u0013\t\t5HA\u0004Qe>$Wo\u0019;\u0002\t1,g\r^\u000b\u0002\tB\u0011A&R\u0005\u0003\rv\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0015aWM\u001a;!\u0003\u0015\u0011\u0018n\u001a5u\u0003\u0019\u0011\u0018n\u001a5uA\u00051A(\u001b8jiz\"2\u0001T'O!\ta\u0003\u0001C\u0003C\u000b\u0001\u0007A\tC\u0003I\u000b\u0001\u0007A)\u0001\u0005eCR\fG+\u001f9f+\u0005\t\u0006C\u0001*V\u001b\u0005\u0019&B\u0001+\"\u0003\u0015!\u0018\u0010]3t\u0013\t16K\u0001\u0005ECR\fG+\u001f9f\u0003!qW\u000f\u001c7bE2,W#A-\u0011\u0005iR\u0016BA.<\u0005\u001d\u0011un\u001c7fC:\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005q\u0006cA0g#:\u0011\u0001-\u001a\b\u0003C\u0012l\u0011A\u0019\u0006\u0003G&\na\u0001\u0010:p_Rt\u0014\"\u0001\u001f\n\u0005UZ\u0014BA4i\u0005\r\u0019V-\u001d\u0006\u0003km\nAB\\;mYN\u000bg-Z#wC2$2a\u001b8q!\tQD.\u0003\u0002nw\t\u0019\u0011I\\=\t\u000b=L\u0001\u0019A6\u0002\r%t\u0007/\u001e;2\u0011\u0015\t\u0018\u00021\u0001l\u0003\u0019Ig\u000e];ue\u0005IAm\\$f]\u000e{G-\u001a\u000b\u0004ij|\bCA;y\u001b\u00051(BA<\u001e\u0003\u001d\u0019w\u000eZ3hK:L!!\u001f<\u0003\u0011\u0015C\bO]\"pI\u0016DQa\u001f\u0006A\u0002q\f1a\u0019;y!\t)X0\u0003\u0002\u007fm\nq1i\u001c3fO\u0016t7i\u001c8uKb$\bBBA\u0001\u0015\u0001\u0007A/\u0001\u0002fm\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0006\u0019\u0006\u001d\u00111\u0002\u0005\u0007\u0003\u0013Y\u0001\u0019\u0001#\u0002\u000f9,w\u000fT3gi\"1\u0011QB\u0006A\u0002\u0011\u000b\u0001B\\3x%&<\u0007\u000e^\u0001\u0005G>\u0004\u0018\u0010F\u0003M\u0003'\t)\u0002C\u0004C\u0019A\u0005\t\u0019\u0001#\t\u000f!c\u0001\u0013!a\u0001\t\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u000eU\r!\u0015QD\u0016\u0003\u0003?\u0001B!!\t\u0002,5\u0011\u00111\u0005\u0006\u0005\u0003K\t9#A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011F\u001e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002.\u0005\r\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u00026A!\u0011qGA!\u001b\t\tID\u0003\u0003\u0002<\u0005u\u0012\u0001\u00027b]\u001eT!!a\u0010\u0002\t)\fg/Y\u0005\u0005\u0003\u0007\nID\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u0013\u00022AOA&\u0013\r\tie\u000f\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004W\u0006M\u0003\"CA+#\u0005\u0005\t\u0019AA%\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\f\t\u0006\u0003;\n\u0019g[\u0007\u0003\u0003?R1!!\u0019<\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003K\nyF\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA-\u0002l!A\u0011QK\n\u0002\u0002\u0003\u00071.\u0001\u0004fcV\fGn\u001d\u000b\u00043\u0006E\u0004\u0002CA+)\u0005\u0005\t\u0019A6)'\u0001\t)(a\u001f\u0002~\u0005\u0005\u00151QAD\u0003\u0013\u000bi)a$\u0011\u00071\n9(C\u0002\u0002zu\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\u0000\u0005\t\u0019I\u0003\u0011!A\u0001zf)\u0016(D?\"*\u0007\u0010\u001d:-A\tLG\u000fT3oORD\u0017\u0006I\u0017!%\u0016$XO\u001d8tA\u0005\u00043\r[3dWN,X\u000eI8gAMC\u0015)\f\u001a!M\u0006l\u0017\u000e\\=!CN\u0004\u0013\r\t5fq\u0002\u001aHO]5oO\u0002zg\r\t1fqB\u0014\bM\f\u0006!A\u0001\u0002\u0003\u0005I*I\u00036\u0012$\u0007\u000e\u0017!'\"\u000bUFM\u001b7Y\u0001\u001a\u0006*Q\u00174qQb\u0003%\u00198eAMC\u0015)L\u001b2e\u0001\n'/\u001a\u0011tkB\u0004xN\u001d;fI:\u0002#)\u001b;!Y\u0016tw\r\u001e5!_\u001a\u0004\u0003\u0007I5tA\u0015\fX/\u001b<bY\u0016tG\u000f\t;pAI*dG\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002\u0006\u0006q(\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014Ta\u0006\u00148n\n\u0017!eU2\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00116ee\u00127m\r21oE\u0012t'Z2co\u0015,4'\u0019\u001beG\u001a\f\u0014(O\u0019esE*$g\u0019\u001a5kM:D-O\u0019:c]B\u0004G\r\u001ace\r$$GN\u001b8M^J\u0014M\r\u001cc\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAF\u0003\u0015\td&\u000e\u00181\u0003\u00159'o\\;qC\t\t\t*\u0001\u0006iCNDwLZ;oGN\fAa\u00155beA\u0011AFF\n\u0005-\u0005e\u0015\bE\u0004\u0002\u001c\u0006\u0005F\t\u0012'\u000e\u0005\u0005u%bAAPw\u00059!/\u001e8uS6,\u0017\u0002BAR\u0003;\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\t)*\u0001\u0005u_N#(/\u001b8h)\t\t)$A\u0003baBd\u0017\u0010F\u0003M\u0003_\u000b\t\fC\u0003C3\u0001\u0007A\tC\u0003I3\u0001\u0007A)A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005]\u00161\u0019\t\u0006u\u0005e\u0016QX\u0005\u0004\u0003w[$AB(qi&|g\u000eE\u0003;\u0003\u007f#E)C\u0002\u0002Bn\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAc5\u0005\u0005\t\u0019\u0001'\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAAf!\u0011\t9$!4\n\t\u0005=\u0017\u0011\b\u0002\u0007\u001f\nTWm\u0019;")
public class Sha2
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(Sha2 sha2) {
        return Sha2$.MODULE$.unapply(sha2);
    }

    public static Function1<Tuple2<Expression, Expression>, Sha2> tupled() {
        return Sha2$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Sha2>> curried() {
        return Sha2$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)new .colon.colon((Object)BinaryType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        int bitLength = BoxesRunTime.unboxToInt((Object)input2);
        byte[] input = (byte[])input1;
        int n = bitLength;
        switch (n) {
            case 224: {
                return UTF8String.fromString((String)new DigestUtils("SHA-224").digestAsHex(input));
            }
            case 0: 
            case 256: {
                return UTF8String.fromString((String)DigestUtils.sha256Hex((byte[])input));
            }
            case 384: {
                return UTF8String.fromString((String)DigestUtils.sha384Hex((byte[])input));
            }
            case 512: {
                return UTF8String.fromString((String)DigestUtils.sha512Hex((byte[])input));
            }
        }
        return null;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String digestUtils = DigestUtils.class.getName();
        String messageDigestAlgorithms = MessageDigestAlgorithms.class.getName();
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(eval1, eval2) -> new StringBuilder(454).append("\n        if (").append((String)eval2).append(" == 224) {\n          ").append(ev.value()).append(" = UTF8String.fromString(\n                          new ").append(digestUtils).append("(").append(messageDigestAlgorithms).append(".SHA_224).digestAsHex(").append((String)eval1).append("));\n        } else if (").append((String)eval2).append(" == 256 || ").append((String)eval2).append(" == 0) {\n          ").append(ev.value()).append(" =\n            UTF8String.fromString(").append(digestUtils).append(".sha256Hex(").append((String)eval1).append("));\n        } else if (").append((String)eval2).append(" == 384) {\n          ").append(ev.value()).append(" =\n            UTF8String.fromString(").append(digestUtils).append(".sha384Hex(").append((String)eval1).append("));\n        } else if (").append((String)eval2).append(" == 512) {\n          ").append(ev.value()).append(" =\n            UTF8String.fromString(").append(digestUtils).append(".sha512Hex(").append((String)eval1).append("));\n        } else {\n          ").append(ev.isNull()).append(" = true;\n        }\n      ").toString());
    }

    @Override
    public Sha2 withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public Sha2 copy(Expression left, Expression right) {
        return new Sha2(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "Sha2";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sha2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sha2)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sha2 sha2 = (Sha2)x$1;
        Expression expression = this.left();
        Expression expression2 = sha2.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = sha2.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!sha2.canEqual(this)) return false;
        return true;
    }

    public Sha2(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

