/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.BitmapConstructAgg$;
import org.apache.spark.sql.catalyst.expressions.BitmapExpressionUtils;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ExpressionDescription(usage="\n    _FUNC_(child) - Returns a bitmap with the positions of the bits set from all the values from\n    the child expression. The child expression will most likely be bitmap_bit_position().\n  ", examples="\n    Examples:\n      > SELECT substring(hex(_FUNC_(bitmap_bit_position(col))), 0, 6) FROM VALUES (1), (2), (3) AS tab(col);\n       070000\n      > SELECT substring(hex(_FUNC_(bitmap_bit_position(col))), 0, 6) FROM VALUES (1), (1), (1) AS tab(col);\n       010000\n  ", since="3.5.0", group="agg_funcs")
@ScalaSignature(bytes="\u0006\u0001\tMd\u0001\u0002\u00192\u0001zB\u0001b\u0017\u0001\u0003\u0016\u0004%\t\u0001\u0018\u0005\t;\u0002\u0011\t\u0012)A\u0005\u001f\"Aa\f\u0001BK\u0002\u0013\u0005q\f\u0003\u0005d\u0001\tE\t\u0015!\u0003a\u0011!!\u0007A!f\u0001\n\u0003y\u0006\u0002C3\u0001\u0005#\u0005\u000b\u0011\u00021\t\u000b\u0019\u0004A\u0011A4\t\u000b\u0019\u0004A\u0011\u00017\t\u000b9\u0004A\u0011I8\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\b!9\u0011q\u0002\u0001\u0005B\u0005E\u0001bBA\u0012\u0001\u0011E\u0013Q\u0005\u0005\b\u0003W\u0001A\u0011IA\u0017\u0011\u001d\t\u0019\u0004\u0001C!\u0003kAq!a\u000f\u0001\t\u0003\ni\u0004C\u0004\u0002F\u0001!\t%a\u0012\t\u0013\u0005=\u0003A1A\u0005\n\u0005E\u0003\u0002CA-\u0001\u0001\u0006I!a\u0015\t\u000f\u0005m\u0003\u0001\"\u0011\u0002^!9\u0011\u0011\r\u0001\u0005B\u0005\r\u0004\"CA9\u0001\t\u0007I\u0011IA/\u0011!\t\u0019\b\u0001Q\u0001\n\u0005}\u0003bBA;\u0001\u0011\u0005\u0013q\u000f\u0005\b\u0003\u0017\u0003A\u0011IAG\u0011\u001d\t)\n\u0001C!\u0003/Cq!!)\u0001\t\u0003\n\u0019\u000bC\u0005\u0002.\u0002\t\t\u0011\"\u0001\u00020\"I\u0011q\u0017\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0018\u0005\n\u0003\u001f\u0004\u0011\u0013!C\u0001\u0003#D\u0011\"!6\u0001#\u0003%\t!!5\t\u0013\u0005]\u0007!!A\u0005B\u0005e\u0007\u0002CAu\u0001\u0005\u0005I\u0011A0\t\u0013\u0005-\b!!A\u0005\u0002\u00055\b\"CAz\u0001\u0005\u0005I\u0011IA{\u0011%\u0011\u0019\u0001AA\u0001\n\u0003\u0011)\u0001C\u0005\u0003\n\u0001\t\t\u0011\"\u0011\u0003\f\u001dI!qF\u0019\u0002\u0002#\u0005!\u0011\u0007\u0004\taE\n\t\u0011#\u0001\u00034!1aM\nC\u0001\u0005\u0003B\u0011Ba\u0011'\u0003\u0003%)E!\u0012\t\u0013\t\u001dc%!A\u0005\u0002\n%\u0003\"\u0003B)ME\u0005I\u0011AAi\u0011%\u0011\u0019FJI\u0001\n\u0003\t\t\u000eC\u0005\u0003V\u0019\n\t\u0011\"!\u0003X!I!Q\r\u0014\u0012\u0002\u0013\u0005\u0011\u0011\u001b\u0005\n\u0005O2\u0013\u0013!C\u0001\u0003#D\u0011B!\u001b'\u0003\u0003%IAa\u001b\u0003%\tKG/\\1q\u0007>t7\u000f\u001e:vGR\fum\u001a\u0006\u0003eM\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011A'N\u0001\tG\u0006$\u0018\r\\=ti*\u0011agN\u0001\u0004gFd'B\u0001\u001d:\u0003\u0015\u0019\b/\u0019:l\u0015\tQ4(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002y\u0005\u0019qN]4\u0004\u0001M1\u0001aP#J%b\u0003\"\u0001Q\"\u000e\u0003\u0005S!AQ\u0019\u0002\u0013\u0005<wM]3hCR,\u0017B\u0001#B\u0005MIU\u000e]3sCRLg/Z!hOJ,w-\u0019;f!\t1u)D\u00012\u0013\tA\u0015G\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\rQUjT\u0007\u0002\u0017*\u0011AjM\u0001\u0006iJ,Wm]\u0005\u0003\u001d.\u0013\u0011\"\u00168befd\u0015n[3\u0011\u0005\u0019\u0003\u0016BA)2\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003'Zk\u0011\u0001\u0016\u0006\u0002+\u0006)1oY1mC&\u0011q\u000b\u0016\u0002\b!J|G-^2u!\t\u0019\u0016,\u0003\u0002[)\na1+\u001a:jC2L'0\u00192mK\u0006)1\r[5mIV\tq*\u0001\u0004dQ&dG\rI\u0001\u0017[V$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fiV\t\u0001\r\u0005\u0002TC&\u0011!\r\u0016\u0002\u0004\u0013:$\u0018aF7vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;!\u0003QIg\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0006)\u0012N\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003iS*\\\u0007C\u0001$\u0001\u0011\u0015Yv\u00011\u0001P\u0011\u001dqv\u0001%AA\u0002\u0001Dq\u0001Z\u0004\u0011\u0002\u0003\u0007\u0001\r\u0006\u0002i[\")1\f\u0003a\u0001\u001f\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003A\u00042!]=}\u001d\t\u0011xO\u0004\u0002tm6\tAO\u0003\u0002v{\u00051AH]8pizJ\u0011!V\u0005\u0003qR\u000bq\u0001]1dW\u0006<W-\u0003\u0002{w\n\u00191+Z9\u000b\u0005a$\u0006cA?\u0002\u00025\taP\u0003\u0002\u0000k\u0005)A/\u001f9fg&\u0019\u00111\u0001@\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\u0005%\u0001cA?\u0002\f%\u0019\u0011Q\u0002@\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\u0002\u001d:fiRLh*Y7f+\t\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005ua\u0002BA\f\u00033\u0001\"a\u001d+\n\u0007\u0005mA+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003?\t\tC\u0001\u0004TiJLgn\u001a\u0006\u0004\u00037!\u0016\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000eF\u0002i\u0003OAa!!\u000b\r\u0001\u0004y\u0015\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002;]LG\u000f\u001b(fo6+H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR$2aPA\u0018\u0011\u0019\t\t$\u0004a\u0001A\u0006Ib.Z<NkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u\u0003m9\u0018\u000e\u001e5OK^Le\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fiR\u0019q(a\u000e\t\r\u0005eb\u00021\u0001a\u0003]qWm^%oaV$\u0018iZ4Ck\u001a4WM](gMN,G/\u0001\u0005ok2d\u0017M\u00197f+\t\ty\u0004E\u0002T\u0003\u0003J1!a\u0011U\u0005\u001d\u0011un\u001c7fC:\fq\"Y4h\u0005V4g-\u001a:TG\",W.Y\u000b\u0003\u0003\u0013\u00022!`A&\u0013\r\tiE \u0002\u000b'R\u0014Xo\u0019;UsB,\u0017A\u00032ji6\f\u0007/\u0011;ueV\u0011\u00111\u000b\t\u0004\r\u0006U\u0013bAA,c\t\u0011\u0012\t\u001e;sS\n,H/\u001a*fM\u0016\u0014XM\\2f\u0003-\u0011\u0017\u000e^7ba\u0006#HO\u001d\u0011\u0002'\u0005<wMQ;gM\u0016\u0014\u0018\t\u001e;sS\n,H/Z:\u0016\u0005\u0005}\u0003\u0003B9z\u0003'\nQ\u0002Z3gCVdGOU3tk2$XCAA3!\u0015\u0019\u0016qMA6\u0013\r\tI\u0007\u0016\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007\u0019\u000bi'C\u0002\u0002pE\u0012q\u0001T5uKJ\fG.\u0001\rj]B,H/Q4h\u0005V4g-\u001a:BiR\u0014\u0018NY;uKN\f\u0011$\u001b8qkR\fum\u001a\"vM\u001a,'/\u0011;ue&\u0014W\u000f^3tA\u0005Q\u0011N\\5uS\u0006d\u0017N_3\u0015\t\u0005e\u0014q\u0010\t\u0004'\u0006m\u0014bAA?)\n!QK\\5u\u0011\u001d\t\ti\u0006a\u0001\u0003\u0007\u000baAY;gM\u0016\u0014\b\u0003BAC\u0003\u000fk\u0011aM\u0005\u0004\u0003\u0013\u001b$aC%oi\u0016\u0014h.\u00197S_^\fa!\u001e9eCR,GCBA=\u0003\u001f\u000b\t\nC\u0004\u0002\u0002b\u0001\r!a!\t\u000f\u0005M\u0005\u00041\u0001\u0002\u0004\u0006)\u0011N\u001c9vi\u0006)Q.\u001a:hKR1\u0011\u0011PAM\u0003;Cq!a'\u001a\u0001\u0004\t\u0019)A\u0004ck\u001a4WM]\u0019\t\u000f\u0005}\u0015\u00041\u0001\u0002\u0004\u00069!-\u001e4gKJ\u0014\u0014\u0001B3wC2$B!!*\u0002,B\u00191+a*\n\u0007\u0005%FKA\u0002B]fD\u0011\"!!\u001b!\u0003\u0005\r!a!\u0002\t\r|\u0007/\u001f\u000b\bQ\u0006E\u00161WA[\u0011\u001dY6\u0004%AA\u0002=CqAX\u000e\u0011\u0002\u0003\u0007\u0001\rC\u0004e7A\u0005\t\u0019\u00011\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0018\u0016\u0004\u001f\u0006u6FAA`!\u0011\t\t-a3\u000e\u0005\u0005\r'\u0002BAc\u0003\u000f\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005%G+\u0001\u0006b]:|G/\u0019;j_:LA!!4\u0002D\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u001b\u0016\u0004A\u0006u\u0016AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005m\u0007\u0003BAo\u0003Ol!!a8\u000b\t\u0005\u0005\u00181]\u0001\u0005Y\u0006twM\u0003\u0002\u0002f\u0006!!.\u0019<b\u0013\u0011\ty\"a8\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QUAx\u0011!\t\t0IA\u0001\u0002\u0004\u0001\u0017a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002xB1\u0011\u0011`A\u0000\u0003Kk!!a?\u000b\u0007\u0005uH+\u0001\u0006d_2dWm\u0019;j_:LAA!\u0001\u0002|\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tyDa\u0002\t\u0013\u0005E8%!AA\u0002\u0005\u0015\u0016AB3rk\u0006d7\u000f\u0006\u0003\u0002@\t5\u0001\"CAyI\u0005\u0005\t\u0019AASQM\u0001!\u0011\u0003B\f\u00053\u0011iBa\b\u0003$\t\u0015\"\u0011\u0006B\u0016!\r1%1C\u0005\u0004\u0005+\t$!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u00057\t\u0011Q\u0010\u0006!A\u0001\u0002sLR+O\u0007~C3\r[5mI&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011bA\tLG/\\1qA]LG\u000f\u001b\u0011uQ\u0016\u0004\u0003o\\:ji&|gn\u001d\u0011pM\u0002\"\b.\u001a\u0011cSR\u001c\be]3uA\u0019\u0014x.\u001c\u0011bY2\u0004C\u000f[3!m\u0006dW/Z:!MJ|WN\u0003\u0011!A\u0001\"\b.\u001a\u0011dQ&dG\rI3yaJ,7o]5p]:\u0002C\u000b[3!G\"LG\u000e\u001a\u0011fqB\u0014Xm]:j_:\u0004s/\u001b7mA5|7\u000f\u001e\u0011mS.,G.\u001f\u0011cK\u0002\u0012\u0017\u000e^7ba~\u0013\u0017\u000e^0q_NLG/[8oQ%r#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#A!\t\u0002\u0005\u001fQ\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e];cgR\u0014\u0018N\\4)Q\u0016D\bf\u0018$V\u001d\u000e{\u0006FY5u[\u0006\u0004xLY5u?B|7/\u001b;j_:D3m\u001c7*S%b\u0003\u0005\r\u0017!m%\u0002cIU(NAY\u000bE*V#TA!\n\u0014\u0006\f\u0011)e%b\u0003\u0005K\u001a*A\u0005\u001b\u0006\u0005^1cQ\r|G.K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!a]\u0002\u0004\u0007\r\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UAM,(m\u001d;sS:<\u0007\u0006[3yQ}3UKT\"`Q\tLG/\\1q?\nLGo\u00189pg&$\u0018n\u001c8)G>d\u0017&K\u0015-AAb\u0003EN\u0015!\rJ{U\n\t,B\u0019V+5\u000b\t\u00152S1\u0002\u0003&M\u0015-A!\n\u0014\u0006I!TAQ\f'\rK2pY&Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005M\u00191aA\u0002$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\t\u001d\u0012!B\u001a/k9\u0002\u0014!B4s_V\u0004\u0018E\u0001B\u0017\u0003%\twmZ0gk:\u001c7/\u0001\nCSRl\u0017\r]\"p]N$(/^2u\u0003\u001e<\u0007C\u0001$''\u00111#Q\u0007-\u0011\u0011\t]\"QH(aA\"l!A!\u000f\u000b\u0007\tmB+A\u0004sk:$\u0018.\\3\n\t\t}\"\u0011\b\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001cDC\u0001B\u0019\u0003!!xn\u0015;sS:<GCAAn\u0003\u0015\t\u0007\u000f\u001d7z)\u001dA'1\nB'\u0005\u001fBQaW\u0015A\u0002=CqAX\u0015\u0011\u0002\u0003\u0007\u0001\rC\u0004eSA\u0005\t\u0019\u00011\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII\nq\"\u00199qYf$C-\u001a4bk2$HeM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011IF!\u0019\u0011\u000bM\u000b9Ga\u0017\u0011\rM\u0013if\u00141a\u0013\r\u0011y\u0006\u0016\u0002\u0007)V\u0004H.Z\u001a\t\u0011\t\rD&!AA\u0002!\f1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\n1B]3bIJ+7o\u001c7wKR\u0011!Q\u000e\t\u0005\u0003;\u0014y'\u0003\u0003\u0003r\u0005}'AB(cU\u0016\u001cG\u000f")
public class BitmapConstructAgg
extends ImperativeAggregate
implements ImplicitCastInputTypes,
UnaryLike<Expression>,
scala.Serializable {
    private final Expression child;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private final AttributeReference bitmapAttr;
    private final Seq<AttributeReference> inputAggBufferAttributes;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;

    public static int $lessinit$greater$default$3() {
        return BitmapConstructAgg$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return BitmapConstructAgg$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple3<Expression, Object, Object>> unapply(BitmapConstructAgg bitmapConstructAgg) {
        return BitmapConstructAgg$.MODULE$.unapply(bitmapConstructAgg);
    }

    public static int apply$default$3() {
        return BitmapConstructAgg$.MODULE$.apply$default$3();
    }

    public static int apply$default$2() {
        return BitmapConstructAgg$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple3<Expression, Object, Object>, BitmapConstructAgg> tupled() {
        return BitmapConstructAgg$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, Function1<Object, BitmapConstructAgg>>> curried() {
        return BitmapConstructAgg$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private Seq<Expression> children$lzycompute() {
        BitmapConstructAgg bitmapConstructAgg = this;
        synchronized (bitmapConstructAgg) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)LongType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "bitmap_construct_agg";
    }

    @Override
    public BitmapConstructAgg withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2(), this.copy$default$3());
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public StructType aggBufferSchema() {
        return DataTypeUtils$.MODULE$.fromAttributes(this.aggBufferAttributes());
    }

    private AttributeReference bitmapAttr() {
        return this.bitmapAttr;
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        AttributeReference attributeReference = this.bitmapAttr();
        return Nil$.MODULE$.$colon$colon((Object)attributeReference);
    }

    @Override
    public Option<Literal> defaultResult() {
        return Option$.MODULE$.apply((Object)Literal$.MODULE$.apply(Array$.MODULE$.fill(BitmapExpressionUtils.NUM_BYTES, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Byte())));
    }

    @Override
    public Seq<AttributeReference> inputAggBufferAttributes() {
        return this.inputAggBufferAttributes;
    }

    @Override
    public void initialize(InternalRow buffer) {
        buffer.update(this.mutableAggBufferOffset(), Array$.MODULE$.fill(BitmapExpressionUtils.NUM_BYTES, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Byte()));
    }

    @Override
    public void update(InternalRow buffer, InternalRow input) {
        Object position = this.child().eval(input);
        if (position != null) {
            byte[] bitmap = buffer.getBinary(this.mutableAggBufferOffset());
            long bitPosition = BoxesRunTime.unboxToLong((Object)position);
            if (bitPosition < 0L || bitPosition >= (long)(8 * bitmap.length)) {
                throw QueryExecutionErrors$.MODULE$.invalidBitmapPositionError(bitPosition, bitmap.length);
            }
            int bytePosition = (int)(bitPosition / 8L);
            int bit = (int)(bitPosition % 8L);
            bitmap[bytePosition] = (byte)(bitmap[bytePosition] | 1 << bit);
            return;
        }
    }

    @Override
    public void merge(InternalRow buffer1, InternalRow buffer2) {
        byte[] bitmap1 = buffer1.getBinary(this.mutableAggBufferOffset());
        byte[] bitmap2 = buffer2.getBinary(this.inputAggBufferOffset());
        BitmapExpressionUtils.bitmapMerge(bitmap1, bitmap2);
    }

    @Override
    public Object eval(InternalRow buffer) {
        return buffer.getBinary(this.mutableAggBufferOffset());
    }

    public BitmapConstructAgg copy(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new BitmapConstructAgg(child, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public int copy$default$2() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$3() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "BitmapConstructAgg";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitmapConstructAgg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitmapConstructAgg)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitmapConstructAgg bitmapConstructAgg = (BitmapConstructAgg)x$1;
        Expression expression = this.child();
        Expression expression2 = bitmapConstructAgg.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (this.mutableAggBufferOffset() != bitmapConstructAgg.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != bitmapConstructAgg.inputAggBufferOffset()) return false;
        if (!bitmapConstructAgg.canEqual(this)) return false;
        return true;
    }

    public BitmapConstructAgg(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
        UnaryLike.$init$(this);
        String x$1 = "bitmap";
        BinaryType$ x$22 = BinaryType$.MODULE$;
        boolean x$3 = false;
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, (DataType)x$22, x$3, x$4);
        Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, (DataType)x$22, x$3, x$4);
        this.bitmapAttr = new AttributeReference(x$1, (DataType)x$22, x$3, x$4, x$5, x$6);
        this.inputAggBufferAttributes = (Seq)this.aggBufferAttributes().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.newInstance(), Seq$.MODULE$.canBuildFrom());
    }

    public BitmapConstructAgg(Expression child) {
        this(child, 0, 0);
    }
}

