/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.CastSupport;
import org.apache.spark.sql.catalyst.analysis.TableOutputResolver$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.Assignment;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumns$;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class AssignmentUtils$
implements SQLConfHelper,
CastSupport {
    public static AssignmentUtils$ MODULE$;

    static {
        new AssignmentUtils$();
    }

    @Override
    public Cast cast(Expression child, DataType dataType) {
        return CastSupport.cast$(this, child, dataType);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    public Seq<Assignment> alignUpdateAssignments(Seq<Attribute> attrs2, Seq<Assignment> assignments) {
        ArrayBuffer errors = new ArrayBuffer();
        Seq output = (Seq)attrs2.map((Function1 & Serializable & scala.Serializable)attr -> MODULE$.applyAssignments(MODULE$.restoreActualType((Attribute)attr), (Expression)attr, assignments, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)err -> {
            errors.$plus$eq((Object)err);
            return BoxedUnit.UNIT;
        }, (Seq<String>)((Seq)new .colon.colon((Object)attr.name(), (List)Nil$.MODULE$))), Seq$.MODULE$.canBuildFrom());
        if (errors.nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.invalidRowLevelOperationAssignments(assignments, (Seq<String>)errors.toSeq());
        }
        return (Seq)((TraversableLike)attrs2.zip((GenIterable)output, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Attribute attr = (Attribute)tuple2._1();
                Expression expr = (Expression)tuple2._2();
                return new Assignment(attr, expr);
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Assignment> alignInsertAssignments(Seq<Attribute> attrs2, Seq<Assignment> assignments) {
        BoxedUnit boxedUnit;
        ArrayBuffer errors = new ArrayBuffer();
        Tuple2 tuple2 = assignments.partition((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)AssignmentUtils$.$anonfun$alignInsertAssignments$1(assignment)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq topLevelAssignments = (Seq)tuple2._1();
        Seq nestedAssignments = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)topLevelAssignments, (Object)nestedAssignments);
        Seq topLevelAssignments2 = (Seq)tuple22._1();
        Seq nestedAssignments2 = (Seq)tuple22._2();
        if (nestedAssignments2.nonEmpty()) {
            String nestedAssignmentsStr = ((TraversableOnce)nestedAssignments2.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.sql(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
            boxedUnit = errors.$plus$eq((Object)new StringBuilder(48).append("INSERT assignment keys cannot be nested fields: ").append(nestedAssignmentsStr).toString());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Seq alignedAssignments = (Seq)attrs2.map((Function1 & Serializable & scala.Serializable)attr -> {
            Expression expression;
            Seq matchingAssignments = (Seq)topLevelAssignments2.collect((PartialFunction)new scala.Serializable((Attribute)attr){
                public static final long serialVersionUID = 0L;
                private final Attribute attr$1;

                public final <A1 extends Assignment, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1.key().semanticEquals(this.attr$1)) {
                        return (B1)A1;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Assignment x1) {
                    Assignment assignment = x1;
                    return assignment.key().semanticEquals(this.attr$1);
                }
                {
                    this.attr$1 = attr$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
            if (matchingAssignments.isEmpty()) {
                Option<NamedExpression> defaultExpr = ResolveDefaultColumns$.MODULE$.getDefaultValueExprOrNullLit((Attribute)attr, MODULE$.conf().useNullsForMissingDefaultColumnValues());
                Object object = defaultExpr.isEmpty() ? errors.$plus$eq((Object)new StringBuilder(20).append("No assignment for '").append(attr.name()).append("'").toString()) : BoxedUnit.UNIT;
                expression = (Expression)defaultExpr.getOrElse((Function0 & Serializable & scala.Serializable)() -> attr);
            } else if (matchingAssignments.length() > 1) {
                String conflictingValuesStr = ((TraversableOnce)matchingAssignments.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.value().sql(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
                errors.$plus$eq((Object)new StringBuilder(29).append("Multiple assignments for '").append(attr.name()).append("': ").append(conflictingValuesStr).toString());
                expression = attr;
            } else {
                Seq colPath = (Seq)new .colon.colon((Object)attr.name(), (List)Nil$.MODULE$);
                Attribute actualAttr = MODULE$.restoreActualType((Attribute)attr);
                Expression value = ((Assignment)matchingAssignments.head()).value();
                expression = TableOutputResolver$.MODULE$.resolveUpdate("", value, actualAttr, MODULE$.conf(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)err -> {
                    errors.$plus$eq((Object)err);
                    return BoxedUnit.UNIT;
                }, (Seq<String>)colPath);
            }
            Expression resolvedValue = expression;
            return new Assignment((Expression)attr, resolvedValue);
        }, Seq$.MODULE$.canBuildFrom());
        if (errors.nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.invalidRowLevelOperationAssignments(assignments, (Seq<String>)errors.toSeq());
        }
        return alignedAssignments;
    }

    private Attribute restoreActualType(Attribute attr) {
        return attr.withDataType((DataType)CharVarcharUtils$.MODULE$.getRawType(attr.metadata()).getOrElse((Function0 & Serializable & scala.Serializable)() -> attr.dataType()));
    }

    private Expression applyAssignments(Attribute col, Expression colExpr, Seq<Assignment> assignments, Function1<String, BoxedUnit> addError, Seq<String> colPath) {
        Tuple2 tuple2 = assignments.partition((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)AssignmentUtils$.$anonfun$applyAssignments$1(colExpr, assignment)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq exactAssignments = (Seq)tuple2._1();
        Seq otherAssignments = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)exactAssignments, (Object)otherAssignments);
        Seq exactAssignments2 = (Seq)tuple22._1();
        Seq otherAssignments2 = (Seq)tuple22._2();
        Seq fieldAssignments = (Seq)otherAssignments2.filter((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)AssignmentUtils$.$anonfun$applyAssignments$2(colExpr, assignment)));
        if (exactAssignments2.size() > 1) {
            String conflictingValuesStr = ((TraversableOnce)exactAssignments2.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.value().sql(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
            addError.apply((Object)new StringBuilder(29).append("Multiple assignments for '").append(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(colPath).quoted()).append("': ").append(conflictingValuesStr).toString());
            return colExpr;
        }
        if (exactAssignments2.nonEmpty() && fieldAssignments.nonEmpty()) {
            Seq conflictingAssignments = (Seq)exactAssignments2.$plus$plus((GenTraversableOnce)fieldAssignments, Seq$.MODULE$.canBuildFrom());
            String conflictingAssignmentsStr = ((TraversableOnce)conflictingAssignments.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.sql(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
            addError.apply((Object)new StringBuilder(32).append("Conflicting assignments for '").append(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(colPath).quoted()).append("': ").append(conflictingAssignmentsStr).toString());
            return colExpr;
        }
        if (exactAssignments2.isEmpty() && fieldAssignments.isEmpty()) {
            return TableOutputResolver$.MODULE$.checkNullability(colExpr, col, this.conf(), colPath);
        }
        if (exactAssignments2.nonEmpty()) {
            Expression value = ((Assignment)exactAssignments2.head()).value();
            return TableOutputResolver$.MODULE$.resolveUpdate("", value, col, this.conf(), addError, colPath);
        }
        return this.applyFieldAssignments(col, colExpr, (Seq<Assignment>)fieldAssignments, addError, colPath);
    }

    private Expression applyFieldAssignments(Attribute col, Expression colExpr, Seq<Assignment> assignments, Function1<String, BoxedUnit> addError, Seq<String> colPath) {
        DataType dataType = col.dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            Seq<AttributeReference> fieldAttrs = DataTypeUtils$.MODULE$.toAttributes(structType);
            GetStructField[] fieldExprs = (GetStructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    StructField field = (StructField)tuple2._1();
                    int ordinal = tuple2._2$mcI$sp();
                    return new GetStructField(colExpr, ordinal, (Option<String>)new Some((Object)field.name()));
                }
                throw new MatchError((Object)tuple2);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(GetStructField.class)));
            Seq updatedFieldExprs = (Seq)((TraversableLike)fieldAttrs.zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])fieldExprs), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    AttributeReference fieldAttr = (AttributeReference)tuple2._1();
                    GetStructField fieldExpr = (GetStructField)tuple2._2();
                    return MODULE$.applyAssignments(fieldAttr, fieldExpr, assignments, addError, (Seq<String>)((Seq)colPath.$colon$plus((Object)fieldAttr.name(), Seq$.MODULE$.canBuildFrom())));
                }
                throw new MatchError((Object)tuple2);
            }, Seq$.MODULE$.canBuildFrom());
            return this.toNamedStruct(structType, (Seq<Expression>)updatedFieldExprs);
        }
        addError.apply((Object)new StringBuilder(74).append("Updating nested fields is only supported for StructType but ").append("'").append(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(colPath).quoted()).append("' is of type ").append(dataType).toString());
        return colExpr;
    }

    private Expression toNamedStruct(StructType structType, Seq<Expression> fieldExprs) {
        Expression[] namedStructExprs = (Expression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).zip(fieldExprs, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                StructField field = (StructField)tuple2._1();
                Expression expr = (Expression)tuple2._2();
                return (Seq)new .colon.colon((Object)Literal$.MODULE$.apply(field.name()), (List)new .colon.colon((Object)expr, (List)Nil$.MODULE$));
            }
            throw new MatchError((Object)tuple2);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Expression.class)));
        return new CreateNamedStruct((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])namedStructExprs));
    }

    public boolean aligned(Seq<Attribute> attrs2, Seq<Assignment> assignments) {
        if (attrs2.size() != assignments.size()) {
            return false;
        }
        return ((IterableLike)attrs2.zip(assignments, Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AssignmentUtils$.$anonfun$aligned$1(x0$1)));
    }

    public static final /* synthetic */ boolean $anonfun$alignInsertAssignments$1(Assignment assignment) {
        return assignment.key() instanceof Attribute;
    }

    public static final /* synthetic */ boolean $anonfun$applyAssignments$1(Expression colExpr$1, Assignment assignment) {
        return assignment.key().semanticEquals(colExpr$1);
    }

    public static final /* synthetic */ boolean $anonfun$applyAssignments$2(Expression colExpr$1, Assignment assignment) {
        return assignment.key().exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.semanticEquals(colExpr$1)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$aligned$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Attribute attr = (Attribute)tuple2._1();
        Assignment assignment = (Assignment)tuple2._2();
        DataType attrType = (DataType)CharVarcharUtils$.MODULE$.getRawType(attr.metadata()).getOrElse((Function0 & Serializable & scala.Serializable)() -> attr.dataType());
        Expression expression = assignment.key();
        if (!(expression instanceof Attribute)) return false;
        Attribute attribute = (Attribute)expression;
        if (!BoxesRunTime.unboxToBoolean((Object)MODULE$.conf().resolver().apply((Object)attribute.name(), (Object)attr.name()))) return false;
        boolean bl = true;
        boolean isMatchingAssignment = bl;
        if (!isMatchingAssignment) return false;
        if (!DataType$.MODULE$.equalsIgnoreCompatibleNullability(assignment.value().dataType(), attrType)) return false;
        if (attr.nullable()) return true;
        if (assignment.value().nullable()) return false;
        return true;
    }

    private AssignmentUtils$() {
        MODULE$ = this;
        SQLConfHelper.$init$(this);
        CastSupport.$init$(this);
    }
}

