/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.UUID;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Observation$;
import org.apache.spark.sql.ObservationListener;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.QueryExecution;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001\u0002\r\u001a\u0001\tB\u0001\"\u000b\u0001\u0003\u0006\u0004%\tA\u000b\u0005\tm\u0001\u0011\t\u0011)A\u0005W!)q\u0007\u0001C\u0001q!)q\u0007\u0001C\u0001y!9Q\b\u0001b\u0001\n\u0013q\u0004B\u0002\"\u0001A\u0003%q\bC\u0004D\u0001\u0001\u0007I\u0011\u0002#\t\u000f-\u0003\u0001\u0019!C\u0005\u0019\"1!\u000b\u0001Q!\n\u0015Cqa\u0016\u0001A\u0002\u0013%\u0001\fC\u0004a\u0001\u0001\u0007I\u0011B1\t\r\r\u0004\u0001\u0015)\u0003Z\u0011\u0019)\u0007\u0001\"\u0001\u001cM\"1q\u0010\u0001C\u0001\u0003\u0003Aq!!\u0014\u0001\t\u0003\ty\u0005C\u0004\u0002l\u0001!I!!\u001c\t\u000f\u0005E\u0004\u0001\"\u0003\u0002t!A\u0011Q\u000f\u0001\u0005\u0002m\t9hB\u0004\u0002\nfA\t!a#\u0007\raI\u0002\u0012AAG\u0011\u00199D\u0003\"\u0001\u0002\u0010\"1\u0011\u0011\u0013\u000b\u0005\u0002qBq!!%\u0015\t\u0003\t\u0019JA\u0006PEN,'O^1uS>t'B\u0001\u000e\u001c\u0003\r\u0019\u0018\u000f\u001c\u0006\u00039u\tQa\u001d9be.T!AH\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0013aA8sO\u000e\u00011C\u0001\u0001$!\t!s%D\u0001&\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015&\u0005\u0019\te.\u001f*fM\u0006!a.Y7f+\u0005Y\u0003C\u0001\u00174\u001d\ti\u0013\u0007\u0005\u0002/K5\tqF\u0003\u00021C\u00051AH]8pizJ!AM\u0013\u0002\rA\u0013X\rZ3g\u0013\t!TG\u0001\u0004TiJLgn\u001a\u0006\u0003e\u0015\nQA\\1nK\u0002\na\u0001P5oSRtDCA\u001d<!\tQ\u0004!D\u0001\u001a\u0011\u0015I3\u00011\u0001,)\u0005I\u0014\u0001\u00037jgR,g.\u001a:\u0016\u0003}\u0002\"A\u000f!\n\u0005\u0005K\"aE(cg\u0016\u0014h/\u0019;j_:d\u0015n\u001d;f]\u0016\u0014\u0018!\u00037jgR,g.\u001a:!\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o+\u0005)\u0005c\u0001\u0013G\u0011&\u0011q)\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005iJ\u0015B\u0001&\u001a\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003A\u0019\b/\u0019:l'\u0016\u001c8/[8o?\u0012*\u0017\u000f\u0006\u0002N!B\u0011AET\u0005\u0003\u001f\u0016\u0012A!\u00168ji\"9\u0011\u000bCA\u0001\u0002\u0004)\u0015a\u0001=%c\u0005i1\u000f]1sWN+7o]5p]\u0002B#!\u0003+\u0011\u0005\u0011*\u0016B\u0001,&\u0005!1x\u000e\\1uS2,\u0017aB7fiJL7m]\u000b\u00023B\u0019AE\u0012.\u0011\t1Z6&X\u0005\u00039V\u00121!T1q!\t!c,\u0003\u0002`K\t\u0019\u0011I\\=\u0002\u00175,GO]5dg~#S-\u001d\u000b\u0003\u001b\nDq!U\u0006\u0002\u0002\u0003\u0007\u0011,\u0001\u0005nKR\u0014\u0018nY:!Q\taA+\u0001\u0002p]V\u0011q-\u001c\u000b\u0005QN,(\u0010E\u0002;S.L!A[\r\u0003\u000f\u0011\u000bG/Y:fiB\u0011A.\u001c\u0007\u0001\t\u0015qWB1\u0001p\u0005\u0005!\u0016C\u00019^!\t!\u0013/\u0003\u0002sK\t9aj\u001c;iS:<\u0007\"\u0002;\u000e\u0001\u0004A\u0017A\u00013t\u0011\u00151X\u00021\u0001x\u0003\u0011)\u0007\u0010\u001d:\u0011\u0005iB\u0018BA=\u001a\u0005\u0019\u0019u\u000e\\;n]\")10\u0004a\u0001y\u0006)Q\r\u001f9sgB\u0019A%`<\n\u0005y,#A\u0003\u001fsKB,\u0017\r^3e}\u0005\u0019q-\u001a;\u0016\u0005\u0005\r\u0001\u0007BA\u0003\u0003\u0013\u0001R\u0001L.,\u0003\u000f\u00012\u0001\\A\u0005\t)\tYADA\u0001\u0002\u0003\u0015\ta\u001c\u0002\u0004?\u0012\n\u0004&\u0002\b\u0002\u0010\u0005\u001d\u0002#\u0002\u0013\u0002\u0012\u0005U\u0011bAA\nK\t1A\u000f\u001b:poN\u0004B!a\u0006\u0002\"9!\u0011\u0011DA\u000f\u001d\rq\u00131D\u0005\u0002M%\u0019\u0011qD\u0013\u0002\u000fA\f7m[1hK&!\u00111EA\u0013\u0005QIe\u000e^3seV\u0004H/\u001a3Fq\u000e,\u0007\u000f^5p]*\u0019\u0011qD\u00132\ryY\u0013\u0011FA&c%\u0019\u00131FA\u0018\u0003\u0003\n\t$F\u0002+\u0003[!aA\\\u0011C\u0002\u0005]\u0012\u0002BA\u0019\u0003g\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n$bAA\u001bK\u00051A\u000f\u001b:poN\f2\u0001]A\u001d!\u0011\tY$!\u0010\u000f\u0007\u0011\ni\"\u0003\u0003\u0002@\u0005\u0015\"!\u0003+ie><\u0018M\u00197fc%\u0019\u00131IA#\u0003\u000f\n)DD\u0002%\u0003\u000bJ1!!\u000e&c\u0015\u0011C%JA%\u0005\u0015\u00198-\u00197bc\r1\u0013QC\u0001\nO\u0016$\u0018i\u001d&bm\u0006,\"!!\u0015\u0011\r\u0005M\u0013QL\u0016$\u001b\t\t)F\u0003\u0003\u0002X\u0005e\u0013\u0001B;uS2T!!a\u0017\u0002\t)\fg/Y\u0005\u00049\u0006U\u0003&B\b\u0002\u0010\u0005\u0005\u0014G\u0002\u0010,\u0003G\nI'M\u0005$\u0003W\ty#!\u001a\u00022EJ1%a\u0011\u0002F\u0005\u001d\u0014QG\u0019\u0006E\u0011*\u0013\u0011J\u0019\u0004M\u0005U\u0011\u0001\u0003:fO&\u001cH/\u001a:\u0015\u00075\u000by\u0007C\u0003D!\u0001\u0007\u0001*\u0001\u0006v]J,w-[:uKJ$\u0012!T\u0001\t_:4\u0015N\\5tQR\u0019Q*!\u001f\t\u000f\u0005m$\u00031\u0001\u0002~\u0005\u0011\u0011/\u001a\t\u0005\u0003\u007f\n))\u0004\u0002\u0002\u0002*\u0019\u00111Q\r\u0002\u0013\u0015DXmY;uS>t\u0017\u0002BAD\u0003\u0003\u0013a\"U;fef,\u00050Z2vi&|g.A\u0006PEN,'O^1uS>t\u0007C\u0001\u001e\u0015'\t!2\u0005\u0006\u0002\u0002\f\u0006)\u0011\r\u001d9msR\u0019\u0011(!&\t\u000b%:\u0002\u0019A\u0016")
public class Observation {
    private final String name;
    private final ObservationListener listener;
    private volatile Option<SparkSession> sparkSession;
    private volatile Option<scala.collection.immutable.Map<String, Object>> metrics;

    public static Observation apply(String string) {
        return Observation$.MODULE$.apply(string);
    }

    public static Observation apply() {
        return Observation$.MODULE$.apply();
    }

    public String name() {
        return this.name;
    }

    private ObservationListener listener() {
        return this.listener;
    }

    private Option<SparkSession> sparkSession() {
        return this.sparkSession;
    }

    private void sparkSession_$eq(Option<SparkSession> x$1) {
        this.sparkSession = x$1;
    }

    private Option<scala.collection.immutable.Map<String, Object>> metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Option<scala.collection.immutable.Map<String, Object>> x$1) {
        this.metrics = x$1;
    }

    public <T> Dataset<T> on(Dataset<T> ds, Column expr, Seq<Column> exprs) {
        if (ds.isStreaming()) {
            throw new IllegalArgumentException("Observation does not support streaming Datasets");
        }
        this.register(ds.sparkSession());
        return ds.observe(this.name(), expr, exprs);
    }

    public scala.collection.immutable.Map<String, ?> get() throws InterruptedException {
        Observation observation = this;
        synchronized (observation) {
            while (this.metrics().isEmpty()) {
                this.wait();
            }
        }
        return (scala.collection.immutable.Map)this.metrics().get();
    }

    public java.util.Map<String, Object> getAsJava() throws InterruptedException {
        return JavaConverters$.MODULE$.mapAsJavaMap((Map)this.get().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                return new Tuple2((Object)key, value);
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom()));
    }

    private void register(SparkSession sparkSession) {
        Observation observation = this;
        synchronized (observation) {
            if (this.sparkSession().isDefined()) {
                throw new IllegalArgumentException("An Observation can be used with a Dataset only once");
            }
            this.sparkSession_$eq((Option<SparkSession>)new Some((Object)sparkSession));
        }
        sparkSession.listenerManager().register(this.listener());
    }

    private void unregister() {
        this.sparkSession().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            Observation.$anonfun$unregister$1(this, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void onFinish(QueryExecution qe) {
        if (this.metrics().isEmpty()) {
            Option row = qe.observedMetrics().get((Object)this.name());
            this.metrics_$eq((Option<scala.collection.immutable.Map<String, Object>>)row.map((Function1 & Serializable & scala.Serializable)r -> r.getValuesMap((Seq)Predef$.MODULE$.wrapRefArray((Object[])r.schema().fieldNames()))));
            if (this.metrics().isDefined()) {
                this.notifyAll();
                this.unregister();
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$unregister$1(Observation $this, SparkSession x$1) {
        x$1.listenerManager().unregister($this.listener());
    }

    public Observation(String name) {
        this.name = name;
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Name must not be empty");
        }
        this.listener = new ObservationListener(this);
        this.sparkSession = None$.MODULE$;
        this.metrics = None$.MODULE$;
    }

    public Observation() {
        this(UUID.randomUUID().toString());
    }
}

