/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.logging.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.conf.Constants;
import org.apache.skywalking.apm.agent.core.logging.core.IWriter;
import org.apache.skywalking.apm.util.RunnableWithExceptionProtection;

public class FileWriter
implements IWriter {
    private static FileWriter INSTANCE;
    private static final Object CREATE_LOCK;
    private FileOutputStream fileOutputStream;
    private ArrayBlockingQueue logBuffer;
    private volatile int fileSize;
    private Pattern filenamePattern = Pattern.compile(Config.Logging.FILE_NAME + "\\.\\d{4}_\\d{2}_\\d{2}_\\d{2}_\\d{2}_\\d{2}");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileWriter get() {
        if (INSTANCE == null) {
            Object object = CREATE_LOCK;
            synchronized (object) {
                if (INSTANCE == null) {
                    INSTANCE = new FileWriter();
                }
            }
        }
        return INSTANCE;
    }

    private FileWriter() {
        this.logBuffer = new ArrayBlockingQueue(1024);
        final ArrayList outputLogs = new ArrayList(200);
        Thread logFlusherThread = new Thread((Runnable)new RunnableWithExceptionProtection(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        FileWriter.this.logBuffer.drainTo(outputLogs);
                        for (String log : outputLogs) {
                            FileWriter.this.writeToFile(log + Constants.LINE_SEPARATOR);
                        }
                        try {
                            if (FileWriter.this.fileOutputStream != null) {
                                FileWriter.this.fileOutputStream.flush();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    finally {
                        outputLogs.clear();
                    }
                    try {
                        TimeUnit.SECONDS.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }, new RunnableWithExceptionProtection.CallbackWhenException(){

            @Override
            public void handle(Throwable t) {
            }
        }), "SkywalkingAgent-LogFileWriter");
        logFlusherThread.setDaemon(true);
        logFlusherThread.start();
    }

    private void writeToFile(String message) {
        if (this.prepareWriteStream()) {
            try {
                this.fileOutputStream.write(message.getBytes());
                this.fileSize += message.length();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.switchFile();
            }
        }
    }

    private void switchFile() {
        if (this.fileSize > Config.Logging.MAX_FILE_SIZE) {
            this.forceExecute(new Callable(){

                public Object call() throws Exception {
                    FileWriter.this.fileOutputStream.flush();
                    return null;
                }
            });
            this.forceExecute(new Callable(){

                public Object call() throws Exception {
                    FileWriter.this.fileOutputStream.close();
                    return null;
                }
            });
            this.forceExecute(new Callable(){

                public Object call() throws Exception {
                    new File(Config.Logging.DIR, Config.Logging.FILE_NAME).renameTo(new File(Config.Logging.DIR, Config.Logging.FILE_NAME + new SimpleDateFormat(".yyyy_MM_dd_HH_mm_ss").format(new Date())));
                    return null;
                }
            });
            this.forceExecute(new Callable(){

                public Object call() throws Exception {
                    FileWriter.this.fileOutputStream = null;
                    return null;
                }
            });
            if (Config.Logging.MAX_HISTORY_FILES > 0) {
                this.deleteExpiredFiles();
            }
        }
    }

    private String[] getHistoryFilePath() {
        File path = new File(Config.Logging.DIR);
        String[] pathArr = path.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return FileWriter.this.filenamePattern.matcher(name).matches();
            }
        });
        return pathArr;
    }

    private void deleteExpiredFiles() {
        String[] historyFileArr = this.getHistoryFilePath();
        if (historyFileArr != null && historyFileArr.length > Config.Logging.MAX_HISTORY_FILES) {
            Arrays.sort(historyFileArr, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o2.compareTo(o1);
                }
            });
            for (int i = Config.Logging.MAX_HISTORY_FILES; i < historyFileArr.length; ++i) {
                File expiredFile = new File(Config.Logging.DIR, historyFileArr[i]);
                expiredFile.delete();
            }
        }
    }

    private void forceExecute(Callable callable) {
        try {
            callable.call();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean prepareWriteStream() {
        if (this.fileOutputStream != null) {
            return true;
        }
        File logFilePath = new File(Config.Logging.DIR);
        if (!logFilePath.exists()) {
            logFilePath.mkdirs();
        } else if (!logFilePath.isDirectory()) {
            System.err.println("Log dir(" + Config.Logging.DIR + ") is not a directory.");
        }
        try {
            this.fileOutputStream = new FileOutputStream(new File(logFilePath, Config.Logging.FILE_NAME), true);
            this.fileSize = Long.valueOf(new File(logFilePath, Config.Logging.FILE_NAME).length()).intValue();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return this.fileOutputStream != null;
    }

    @Override
    public void write(String message) {
        this.logBuffer.offer(message);
    }

    static {
        CREATE_LOCK = new Object();
    }
}

