/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.hutool.http.v5;

import cn.hutool.core.util.URLUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import java.lang.reflect.Method;
import java.net.URL;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class HutoolHttpExecuteInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        HttpRequest request = (HttpRequest)objInst;
        ContextCarrier contextCarrier = new ContextCarrier();
        URL url = URLUtil.url((String)request.getUrl());
        String remotePeer = this.getPeer(url);
        String formatURIPath = url.getPath();
        AbstractSpan span = ContextManager.createExitSpan((String)formatURIPath, (ContextCarrier)contextCarrier, (String)remotePeer);
        span.setComponent((Component)ComponentsDefine.HUTOOL);
        Tags.HTTP.METHOD.set(span, request.getMethod().name());
        Tags.URL.set(span, url.toString());
        SpanLayer.asHttp((AbstractSpan)span);
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            request.header(next.getHeadKey(), next.getHeadValue());
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        if (ret != null) {
            HttpResponse response = (HttpResponse)ret;
            int statusCode = response.getStatus();
            AbstractSpan span = ContextManager.activeSpan();
            Tags.HTTP_RESPONSE_STATUS_CODE.set(span, Integer.valueOf(statusCode));
            if (statusCode >= 400) {
                span.errorOccurred();
            }
        }
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }

    private String getPeer(URL url) {
        String host = url.getHost();
        if (url.getPort() > 0) {
            return host + ":" + url.getPort();
        }
        return host;
    }
}

