/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.server.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolNegotiator;
import io.netty.handler.ssl.SslContext;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSessionContext;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.util.MultipleFilesChangeMonitor;

public abstract class AbstractSslContext
extends SslContext {
    private final MultipleFilesChangeMonitor monitor;
    private volatile SslContext ctx;

    protected AbstractSslContext(String privateKeyFile, String certChainFile, String trustedCAsFile) {
        this.updateContext(privateKeyFile, certChainFile, trustedCAsFile);
        this.monitor = new MultipleFilesChangeMonitor(10L, readableContents -> this.updateContext(privateKeyFile, certChainFile, trustedCAsFile), new String[]{certChainFile, privateKeyFile, trustedCAsFile});
    }

    protected AbstractSslContext(String caFile) {
        this.updateContext(caFile);
        this.monitor = new MultipleFilesChangeMonitor(10L, readableContents -> this.updateContext(caFile), new String[]{caFile});
    }

    protected abstract void updateContext(String var1);

    protected abstract void updateContext(String var1, String var2, String var3);

    public void start() {
        this.monitor.start();
    }

    public final boolean isClient() {
        return this.ctx.isClient();
    }

    public final List<String> cipherSuites() {
        return this.ctx.cipherSuites();
    }

    public final long sessionCacheSize() {
        return this.ctx.sessionCacheSize();
    }

    public final long sessionTimeout() {
        return this.ctx.sessionTimeout();
    }

    public final ApplicationProtocolNegotiator applicationProtocolNegotiator() {
        return this.ctx.applicationProtocolNegotiator();
    }

    public final SSLEngine newEngine(ByteBufAllocator alloc) {
        return this.ctx.newEngine(alloc);
    }

    public final SSLEngine newEngine(ByteBufAllocator alloc, String peerHost, int peerPort) {
        return this.ctx.newEngine(alloc, peerHost, peerPort);
    }

    public final SSLSessionContext sessionContext() {
        return this.ctx.sessionContext();
    }

    @Generated
    protected void setCtx(SslContext ctx) {
        this.ctx = ctx;
    }
}

