/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.ebpf.provider;

import io.grpc.BindableService;
import io.grpc.ServerInterceptor;
import java.util.Objects;
import org.apache.logging.log4j.util.Strings;
import org.apache.skywalking.oap.server.core.RunningMode;
import org.apache.skywalking.oap.server.core.oal.rt.OALDefine;
import org.apache.skywalking.oap.server.core.oal.rt.OALEngineLoaderService;
import org.apache.skywalking.oap.server.core.server.GRPCHandlerRegister;
import org.apache.skywalking.oap.server.core.server.GRPCHandlerRegisterImpl;
import org.apache.skywalking.oap.server.core.watermark.WatermarkGRPCInterceptor;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.server.ServerException;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCServer;
import org.apache.skywalking.oap.server.receiver.ebpf.module.EBPFReceiverModule;
import org.apache.skywalking.oap.server.receiver.ebpf.provider.EBPFOALDefine;
import org.apache.skywalking.oap.server.receiver.ebpf.provider.EBPFReceiverModuleConfig;
import org.apache.skywalking.oap.server.receiver.ebpf.provider.handler.AccessLogServiceHandler;
import org.apache.skywalking.oap.server.receiver.ebpf.provider.handler.ContinuousProfilingServiceHandler;
import org.apache.skywalking.oap.server.receiver.ebpf.provider.handler.EBPFProcessServiceHandler;
import org.apache.skywalking.oap.server.receiver.ebpf.provider.handler.EBPFProfilingServiceHandler;

public class EBPFReceiverProvider
extends ModuleProvider {
    private EBPFReceiverModuleConfig config;
    protected GRPCServer grpcServer;
    protected GRPCHandlerRegister receiverGRPCHandlerRegister;

    public String name() {
        return "default";
    }

    public Class<? extends ModuleDefine> module() {
        return EBPFReceiverModule.class;
    }

    public ModuleProvider.ConfigCreator<EBPFReceiverModuleConfig> newConfigCreator() {
        return new ModuleProvider.ConfigCreator<EBPFReceiverModuleConfig>(){

            public Class<EBPFReceiverModuleConfig> type() {
                return EBPFReceiverModuleConfig.class;
            }

            public void onInitialized(EBPFReceiverModuleConfig initialized) {
                EBPFReceiverProvider.this.config = initialized;
            }
        };
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        ((OALEngineLoaderService)this.getManager().find("core").provider().getService(OALEngineLoaderService.class)).load((OALDefine)EBPFOALDefine.INSTANCE);
        if (this.config.getGRPCPort() != 0 && !RunningMode.isInitMode()) {
            this.grpcServer = this.config.isGRPCSslEnabled() ? new GRPCServer(Strings.isBlank((String)this.config.getGRPCHost()) ? "0.0.0.0" : this.config.getGRPCHost(), this.config.getGRPCPort(), this.config.getGRPCSslCertChainPath(), this.config.getGRPCSslKeyPath(), this.config.getGRPCSslTrustedCAsPath()) : new GRPCServer(Strings.isBlank((String)this.config.getGRPCHost()) ? "0.0.0.0" : this.config.getGRPCHost(), this.config.getGRPCPort());
            if (this.config.getMaxMessageSize() > 0) {
                this.grpcServer.setMaxMessageSize(this.config.getMaxMessageSize());
            }
            if (this.config.getMaxConcurrentCallsPerConnection() > 0) {
                this.grpcServer.setMaxConcurrentCallsPerConnection(this.config.getMaxConcurrentCallsPerConnection());
            }
            if (this.config.getGRPCThreadPoolSize() > 0) {
                this.grpcServer.setThreadPoolSize(this.config.getGRPCThreadPoolSize());
            }
            this.grpcServer.initialize();
            this.receiverGRPCHandlerRegister = new GRPCHandlerRegisterImpl(this.grpcServer);
        }
        GRPCHandlerRegister service = Objects.nonNull(this.receiverGRPCHandlerRegister) ? this.receiverGRPCHandlerRegister : (GRPCHandlerRegister)this.getManager().find("receiver-sharing-server").provider().getService(GRPCHandlerRegister.class);
        service.addHandler((BindableService)new EBPFProcessServiceHandler(this.getManager()));
        service.addHandler((BindableService)new EBPFProfilingServiceHandler(this.getManager()));
        service.addHandler((BindableService)new ContinuousProfilingServiceHandler(this.getManager(), this.config));
        service.addHandler((BindableService)new AccessLogServiceHandler(this.getManager()));
        service.addFilter((ServerInterceptor)WatermarkGRPCInterceptor.INSTANCE);
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException, ModuleStartException {
        try {
            if (Objects.nonNull(this.grpcServer) && !RunningMode.isInitMode()) {
                this.grpcServer.start();
            }
        }
        catch (ServerException e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
    }

    public String[] requiredModules() {
        return new String[]{"core", "receiver-sharing-server"};
    }
}

