/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.telemetry.api;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.GaugeMetrics;
import org.apache.skywalking.oap.server.telemetry.api.HealthCheckMetrics;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;

public interface MetricsCreator
extends Service {
    public static final String HEALTH_METRIC_PREFIX = "health_check_";

    public CounterMetrics createCounter(String var1, String var2, MetricsTag.Keys var3, MetricsTag.Values var4);

    public GaugeMetrics createGauge(String var1, String var2, MetricsTag.Keys var3, MetricsTag.Values var4);

    public HistogramMetrics createHistogramMetric(String var1, String var2, MetricsTag.Keys var3, MetricsTag.Values var4, double ... var5);

    default public HealthCheckMetrics createHealthCheckerGauge(String name, MetricsTag.Keys tagKeys, MetricsTag.Values tagValues) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Require non-null or empty metric name");
        return new HealthCheckMetrics(this.createGauge(Strings.lenientFormat((String)"%s%s", (Object[])new Object[]{HEALTH_METRIC_PREFIX, name}), Strings.lenientFormat((String)"%s health check. 1 healthy, 0 not healthy, -1 unknown", (Object[])new Object[]{name}), tagKeys, tagValues));
    }

    default public boolean isHealthCheckerMetrics(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Require non-null or empty metric name");
        return name.startsWith(HEALTH_METRIC_PREFIX);
    }

    default public String extractModuleName(String metricName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)metricName) ? 1 : 0) != 0, (Object)"Require non-null or empty metric name");
        return metricName.replace(HEALTH_METRIC_PREFIX, "");
    }
}

