/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.configuration.zookeeper;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.skywalking.oap.server.configuration.api.ConfigTable;
import org.apache.skywalking.oap.server.configuration.api.FetchingConfigWatcherRegister;
import org.apache.skywalking.oap.server.configuration.api.GroupConfigTable;
import org.apache.skywalking.oap.server.configuration.zookeeper.ZookeeperServerSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperConfigWatcherRegister
extends FetchingConfigWatcherRegister {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZookeeperConfigWatcherRegister.class);
    private final CuratorFramework client;
    private final PathChildrenCache childrenCache;
    private final String prefix;

    public ZookeeperConfigWatcherRegister(ZookeeperServerSettings settings) throws Exception {
        super((long)settings.getPeriod());
        this.prefix = settings.getNamespace() + "/";
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(settings.getBaseSleepTimeMs(), settings.getMaxRetries());
        this.client = CuratorFrameworkFactory.newClient((String)settings.getHostPort(), (RetryPolicy)retryPolicy);
        this.client.start();
        this.childrenCache = new PathChildrenCache(this.client, settings.getNamespace(), true);
        this.childrenCache.start();
    }

    public Optional<ConfigTable> readConfig(Set<String> keys) {
        ConfigTable table = new ConfigTable();
        keys.forEach(s -> {
            ChildData data = this.childrenCache.getCurrentData(this.prefix + s);
            String itemValue = null;
            if (data != null && data.getData() != null) {
                itemValue = new String(data.getData(), StandardCharsets.UTF_8);
            }
            table.add(new ConfigTable.ConfigItem(s, itemValue));
        });
        return Optional.of(table);
    }

    public Optional<GroupConfigTable> readGroupConfig(Set<String> keys) {
        GroupConfigTable table = new GroupConfigTable();
        keys.forEach(key -> {
            GroupConfigTable.GroupConfigItems groupConfigItems = new GroupConfigTable.GroupConfigItems(key);
            try {
                ((List)this.client.getChildren().forPath(this.prefix + key)).forEach(itemName -> {
                    byte[] data = null;
                    try {
                        data = (byte[])this.client.getData().forPath(this.prefix + key + "/" + itemName);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    groupConfigItems.add(new ConfigTable.ConfigItem(itemName, data == null ? null : new String(data, StandardCharsets.UTF_8)));
                });
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            table.addGroupConfigItems(groupConfigItems);
        });
        return Optional.of(table);
    }
}

