/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.mqe.rt.operation;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.skywalking.mqe.rt.exception.IllegalExpressionException;
import org.apache.skywalking.oap.server.core.query.mqe.ExpressionResult;
import org.apache.skywalking.oap.server.core.query.mqe.ExpressionResultType;
import org.apache.skywalking.oap.server.core.query.mqe.MQEValue;
import org.apache.skywalking.oap.server.core.query.mqe.MQEValues;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class TopNOfOp {
    public static ExpressionResult doMergeTopNResult(List<ExpressionResult> topNResults, int limit, int order) throws IllegalExpressionException {
        ExpressionResultType type = null;
        ArrayList allValues = new ArrayList();
        for (ExpressionResult topNResult : topNResults) {
            if (StringUtil.isNotEmpty((String)topNResult.getError())) {
                return topNResult;
            }
            if (type != null && type != topNResult.getType()) {
                throw new IllegalExpressionException("TopN type is not consistent, one is " + String.valueOf(type) + ", another is " + String.valueOf(topNResult.getType()));
            }
            type = topNResult.getType();
            allValues.addAll(((MQEValues)topNResult.getResults().get(0)).getValues());
        }
        if (limit > allValues.size()) {
            limit = allValues.size();
        }
        List mergedValues = allValues.stream().filter(mqeValue -> !mqeValue.isEmptyValue()).sorted(42 == order ? Comparator.comparingDouble(MQEValue::getDoubleValue) : Comparator.comparingDouble(MQEValue::getDoubleValue).reversed()).limit(limit).collect(Collectors.toList());
        ExpressionResult result = new ExpressionResult();
        MQEValues mqeValues = new MQEValues();
        mqeValues.setValues(mergedValues);
        result.getResults().add(mqeValues);
        result.setType(type);
        return result;
    }
}

