/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.debug;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.server.annotation.Default;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.ProducesJson;
import com.linecorp.armeria.server.annotation.ProducesText;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.query.debug.DebuggingSpanRsp;
import org.apache.skywalking.oap.query.debug.DebuggingTraceRsp;
import org.apache.skywalking.oap.query.debug.StatusQueryConfig;
import org.apache.skywalking.oap.query.debug.StatusQueryExceptionHandler;
import org.apache.skywalking.oap.query.debug.log.DebuggingQueryLogsRsp;
import org.apache.skywalking.oap.query.debug.mqe.DebuggingMQERsp;
import org.apache.skywalking.oap.query.debug.topology.DebuggingQueryEndpointTopologyRsp;
import org.apache.skywalking.oap.query.debug.topology.DebuggingQueryInstanceTopologyRsp;
import org.apache.skywalking.oap.query.debug.topology.DebuggingQueryProcessTopologyRsp;
import org.apache.skywalking.oap.query.debug.topology.DebuggingQueryServiceTopologyRsp;
import org.apache.skywalking.oap.query.debug.trace.DebuggingQueryTraceBriefRsp;
import org.apache.skywalking.oap.query.debug.trace.DebuggingQueryTraceRsp;
import org.apache.skywalking.oap.query.debug.trace.zipkin.DebuggingZipkinQueryTraceRsp;
import org.apache.skywalking.oap.query.debug.trace.zipkin.DebuggingZipkinQueryTracesRsp;
import org.apache.skywalking.oap.query.graphql.resolver.LogQuery;
import org.apache.skywalking.oap.query.graphql.resolver.MetricsExpressionQuery;
import org.apache.skywalking.oap.query.graphql.resolver.TopologyQuery;
import org.apache.skywalking.oap.query.graphql.resolver.TraceQuery;
import org.apache.skywalking.oap.query.zipkin.ZipkinQueryConfig;
import org.apache.skywalking.oap.query.zipkin.handler.ZipkinQueryHandler;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.enumeration.Step;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.Entity;
import org.apache.skywalking.oap.server.core.query.input.LogQueryCondition;
import org.apache.skywalking.oap.server.core.query.input.TraceQueryCondition;
import org.apache.skywalking.oap.server.core.query.input.TraceScopeCondition;
import org.apache.skywalking.oap.server.core.query.mqe.ExpressionResult;
import org.apache.skywalking.oap.server.core.query.type.EndpointTopology;
import org.apache.skywalking.oap.server.core.query.type.Logs;
import org.apache.skywalking.oap.server.core.query.type.Pagination;
import org.apache.skywalking.oap.server.core.query.type.ProcessTopology;
import org.apache.skywalking.oap.server.core.query.type.QueryOrder;
import org.apache.skywalking.oap.server.core.query.type.ServiceInstanceTopology;
import org.apache.skywalking.oap.server.core.query.type.Topology;
import org.apache.skywalking.oap.server.core.query.type.Trace;
import org.apache.skywalking.oap.server.core.query.type.TraceBrief;
import org.apache.skywalking.oap.server.core.query.type.TraceState;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingSpan;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingTrace;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingTraceContext;
import org.apache.skywalking.oap.server.core.status.ServerStatusService;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zipkin2.Span;

@ExceptionHandler(value=StatusQueryExceptionHandler.class)
public class DebuggingHTTPHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DebuggingHTTPHandler.class);
    private final ServerStatusService serverStatusService;
    private final MetricsExpressionQuery mqeQuery;
    private final TraceQuery traceQuery;
    private final ZipkinQueryHandler zipkinQueryHandler;
    private final TopologyQuery topologyQuery;
    private final LogQuery logQuery;
    final StatusQueryConfig config;

    public DebuggingHTTPHandler(ModuleManager manager, StatusQueryConfig config) {
        this.serverStatusService = (ServerStatusService)manager.find("core").provider().getService(ServerStatusService.class);
        this.config = config;
        this.mqeQuery = new MetricsExpressionQuery(manager);
        this.traceQuery = new TraceQuery(manager);
        this.zipkinQueryHandler = new ZipkinQueryHandler(new ZipkinQueryConfig(), manager);
        this.topologyQuery = new TopologyQuery(manager);
        this.logQuery = new LogQuery(manager);
    }

    @ProducesText
    @ProducesJson
    @Get(value="/debugging/config/dump")
    public ServerStatusService.ConfigList dumpConfigurations(HttpRequest request) {
        return this.serverStatusService.dumpBootingConfigurations(this.config.getKeywords4MaskingSecretsOfConfig());
    }

    @Get(value="/debugging/query/mqe")
    public String execExpression(@Param(value="dumpDBRsp") boolean dumpStorageRsp, @Param(value="expression") String expression, @Param(value="startTime") String startTime, @Param(value="endTime") String endTime, @Param(value="step") String step, @Param(value="coldStage") Optional<Boolean> coldStage, @Param(value="service") String service, @Param(value="serviceLayer") Optional<String> serviceLayer, @Param(value="serviceInstance") Optional<String> serviceInstance, @Param(value="endpoint") Optional<String> endpoint, @Param(value="process") Optional<String> process, @Param(value="destService") Optional<String> destService, @Param(value="destServiceLayer") Optional<String> destServiceLayer, @Param(value="destServiceInstance") Optional<String> destServiceInstance, @Param(value="destEndpoint") Optional<String> destEndpoint, @Param(value="destProcess") Optional<String> destProcess) {
        Entity entity = new Entity();
        entity.setServiceName(service);
        entity.setServiceInstanceName((String)serviceInstance.orElse(null));
        entity.setEndpointName((String)endpoint.orElse(null));
        entity.setProcessName((String)process.orElse(null));
        entity.setDestServiceName((String)destService.orElse(null));
        entity.setDestServiceInstanceName((String)destServiceInstance.orElse(null));
        entity.setDestEndpointName((String)destEndpoint.orElse(null));
        entity.setDestProcessName((String)destProcess.orElse(null));
        serviceLayer.ifPresentOrElse(s -> entity.setNormal(Boolean.valueOf(Layer.nameOf((String)s).isNormal())), () -> entity.setNormal(Boolean.valueOf(true)));
        destServiceLayer.ifPresentOrElse(s -> entity.setDestNormal(Boolean.valueOf(Layer.nameOf((String)s).isNormal())), () -> entity.setDestNormal(Boolean.valueOf(true)));
        Duration duration = new Duration();
        duration.setStart(startTime);
        duration.setEnd(endTime);
        duration.setStep(Step.valueOf((String)step));
        coldStage.ifPresent(arg_0 -> ((Duration)duration).setColdStage(arg_0));
        ExpressionResult expressionResult = (ExpressionResult)this.mqeQuery.execExpression(expression, entity, duration, true, dumpStorageRsp).join();
        DebuggingTrace execTrace = expressionResult.getDebuggingTrace();
        DebuggingMQERsp result = new DebuggingMQERsp(expressionResult.getType(), expressionResult.getResults(), expressionResult.getError(), this.transformTrace(execTrace));
        return this.transToYAMLString(result);
    }

    @Get(value="/debugging/query/trace/queryBasicTraces")
    public String queryBasicTraces(@Param(value="service") Optional<String> service, @Param(value="serviceLayer") Optional<String> serviceLayer, @Param(value="serviceInstance") Optional<String> serviceInstance, @Param(value="endpoint") Optional<String> endpoint, @Param(value="traceId") Optional<String> traceId, @Param(value="startTime") String startTime, @Param(value="endTime") String endTime, @Param(value="step") String step, @Param(value="minTraceDuration") Optional<Integer> minDuration, @Param(value="maxTraceDuration") Optional<Integer> maxDuration, @Param(value="traceState") String traceState, @Param(value="queryOrder") String queryOrder, @Param(value="tags") Optional<String> tags, @Param(value="pageNum") int pageNum, @Param(value="pageSize") int pageSize) {
        boolean isNormal = serviceLayer.map(s -> Layer.nameOf((String)s).isNormal()).orElse(true);
        Optional<String> serviceId = service.map(name -> IDManager.ServiceID.buildId((String)name, (boolean)isNormal));
        Optional<String> serviceInstanceId = serviceInstance.map(name -> IDManager.ServiceInstanceID.buildId((String)((String)serviceId.orElseThrow()), (String)name));
        Optional<String> endpointId = endpoint.map(name -> IDManager.EndpointID.buildId((String)((String)serviceId.orElseThrow()), (String)name));
        Duration duration = new Duration();
        duration.setStart(startTime);
        duration.setEnd(endTime);
        duration.setStep(Step.valueOf((String)step));
        Pagination pagination = new Pagination();
        pagination.setPageNum(pageNum);
        pagination.setPageSize(pageSize);
        TraceQueryCondition condition = new TraceQueryCondition();
        condition.setServiceId((String)serviceId.orElse(null));
        condition.setServiceInstanceId((String)serviceInstanceId.orElse(null));
        condition.setEndpointId((String)endpointId.orElse(null));
        condition.setTraceId((String)traceId.orElse(null));
        condition.setQueryDuration(duration);
        condition.setMinTraceDuration(minDuration.orElse(0).intValue());
        condition.setMaxTraceDuration(maxDuration.orElse(0).intValue());
        condition.setTraceState(TraceState.valueOf((String)traceState));
        condition.setQueryOrder(QueryOrder.valueOf((String)queryOrder));
        condition.setPaging(pagination);
        tags.ifPresent(ts -> {
            ArrayList tagList = new ArrayList();
            Arrays.stream(ts.split(",")).forEach(t -> {
                Tag tag = new Tag();
                String[] tagArr = t.split("=");
                tag.setKey(tagArr[0]);
                tag.setValue(tagArr[1]);
                tagList.add(tag);
            });
            condition.setTags(tagList);
        });
        TraceBrief traceBrief = (TraceBrief)this.traceQuery.queryBasicTraces(condition, true).join();
        DebuggingQueryTraceBriefRsp result = new DebuggingQueryTraceBriefRsp(traceBrief.getTraces(), this.transformTrace(traceBrief.getDebuggingTrace()));
        return this.transToYAMLString(result);
    }

    @Get(value="/debugging/query/trace/queryTrace")
    public String queryTrace(@Param(value="traceId") String traceId, @Param(value="startTime") String startTime, @Param(value="endTime") String endTime, @Param(value="step") String step, @Param(value="coldStage") Optional<Boolean> coldStage) {
        Duration duration = new Duration();
        duration.setStart(startTime);
        duration.setEnd(endTime);
        duration.setStep(Step.valueOf((String)step));
        coldStage.ifPresent(arg_0 -> ((Duration)duration).setColdStage(arg_0));
        Trace trace = (Trace)this.traceQuery.queryTrace(traceId, duration, true).join();
        DebuggingQueryTraceRsp result = new DebuggingQueryTraceRsp(trace.getSpans(), this.transformTrace(trace.getDebuggingTrace()));
        return this.transToYAMLString(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Get(value="/debugging/query/zipkin/api/v2/traces")
    public String queryZipkinTraces(@Param(value="serviceName") Optional<String> serviceName, @Param(value="remoteServiceName") Optional<String> remoteServiceName, @Param(value="spanName") Optional<String> spanName, @Param(value="annotationQuery") Optional<String> annotationQuery, @Param(value="minDuration") Optional<Long> minDuration, @Param(value="maxDuration") Optional<Long> maxDuration, @Param(value="endTs") Optional<Long> endTs, @Param(value="lookback") Optional<Long> lookback, @Default(value="10") @Param(value="limit") int limit) {
        String string;
        String condition = "serviceName: " + (String)serviceName.orElse(null) + ", remoteServiceName: " + (String)remoteServiceName.orElse(null) + ", spanName: " + (String)spanName.orElse(null) + ", annotationQuery: " + (String)annotationQuery.orElse(null) + ", minDuration: " + String.valueOf(minDuration.orElse(null)) + ", maxDuration: " + String.valueOf(maxDuration.orElse(null)) + ", endTs: " + String.valueOf(endTs.orElse(null)) + ", lookback: " + String.valueOf(lookback.orElse(null)) + ", limit: " + limit;
        DebuggingTraceContext traceContext = new DebuggingTraceContext(condition, true, false);
        DebuggingTraceContext.TRACE_CONTEXT.set(traceContext);
        try {
            AggregatedHttpResponse response = this.zipkinQueryHandler.getTraces(serviceName, remoteServiceName, spanName, annotationQuery, minDuration, maxDuration, endTs, lookback, limit);
            List<List<Object>> traces = new ArrayList<List<Span>>();
            if (response.status().code() == 200) {
                traces = (List)new Gson().fromJson(response.contentUtf8(), new TypeToken<ArrayList<ArrayList<Span>>>(){}.getType());
            }
            DebuggingZipkinQueryTracesRsp result = new DebuggingZipkinQueryTracesRsp(traces, this.transformTrace(traceContext.getExecTrace()));
            string = this.transToYAMLStringZipkin(result);
        }
        catch (Throwable throwable) {
            traceContext.stopTrace();
            DebuggingTraceContext.TRACE_CONTEXT.remove();
            throw throwable;
        }
        traceContext.stopTrace();
        DebuggingTraceContext.TRACE_CONTEXT.remove();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Get(value="/debugging/query/zipkin/api/v2/trace")
    public String getZipkinTraceById(@Param(value="traceId") String traceId) {
        String string;
        DebuggingTraceContext traceContext = new DebuggingTraceContext("traceId: " + traceId, true, false);
        DebuggingTraceContext.TRACE_CONTEXT.set(traceContext);
        try {
            AggregatedHttpResponse response = this.zipkinQueryHandler.getTraceById(traceId);
            List<Object> trace = new ArrayList<Span>();
            if (response.status().code() == 200) {
                trace = (List)new Gson().fromJson(response.contentUtf8(), new TypeToken<ArrayList<Span>>(){}.getType());
            }
            DebuggingZipkinQueryTraceRsp result = new DebuggingZipkinQueryTraceRsp(trace, this.transformTrace(traceContext.getExecTrace()));
            string = this.transToYAMLStringZipkin(result);
        }
        catch (Throwable throwable) {
            traceContext.stopTrace();
            DebuggingTraceContext.TRACE_CONTEXT.remove();
            throw throwable;
        }
        traceContext.stopTrace();
        DebuggingTraceContext.TRACE_CONTEXT.remove();
        return string;
    }

    @Get(value="/debugging/query/topology/getGlobalTopology")
    public String getGlobalTopology(@Param(value="startTime") String startTime, @Param(value="endTime") String endTime, @Param(value="step") String step, @Param(value="coldStage") Optional<Boolean> coldStage, @Param(value="serviceLayer") Optional<String> serviceLayer) {
        Duration duration = new Duration();
        duration.setStart(startTime);
        duration.setEnd(endTime);
        duration.setStep(Step.valueOf((String)step));
        coldStage.ifPresent(arg_0 -> ((Duration)duration).setColdStage(arg_0));
        Topology topology = (Topology)this.topologyQuery.getGlobalTopology(duration, (String)serviceLayer.orElse(null), true).join();
        DebuggingQueryServiceTopologyRsp result = new DebuggingQueryServiceTopologyRsp(topology.getNodes(), topology.getCalls(), this.transformTrace(topology.getDebuggingTrace()));
        return this.transToYAMLString(result);
    }

    @Get(value="/debugging/query/topology/getServicesTopology")
    public String getServicesTopology(@Param(value="startTime") String startTime, @Param(value="endTime") String endTime, @Param(value="step") String step, @Param(value="coldStage") Optional<Boolean> coldStage, @Param(value="serviceLayer") Optional<String> serviceLayer, @Param(value="services") String services) {
        Duration duration = new Duration();
        duration.setStart(startTime);
        duration.setEnd(endTime);
        duration.setStep(Step.valueOf((String)step));
        coldStage.ifPresent(arg_0 -> ((Duration)duration).setColdStage(arg_0));
        boolean isNormal = serviceLayer.map(s -> Layer.nameOf((String)s).isNormal()).orElse(true);
        List ids = Arrays.stream(services.split(",")).map(name -> IDManager.ServiceID.buildId((String)name, (boolean)isNormal)).collect(Collectors.toList());
        Topology topology = (Topology)this.topologyQuery.getServicesTopology(ids, duration, true).join();
        DebuggingQueryServiceTopologyRsp result = new DebuggingQueryServiceTopologyRsp(topology.getNodes(), topology.getCalls(), this.transformTrace(topology.getDebuggingTrace()));
        return this.transToYAMLString(result);
    }

    @Get(value="/debugging/query/topology/getServiceInstanceTopology")
    public String getServiceInstanceTopology(@Param(value="startTime") String startTime, @Param(value="endTime") String endTime, @Param(value="step") String step, @Param(value="coldStage") Optional<Boolean> coldStage, @Param(value="clientService") String clientService, @Param(value="serverService") String serverService, @Param(value="clientServiceLayer") Optional<String> clientServiceLayer, @Param(value="serverServiceLayer") Optional<String> serverServiceLayer) {
        Duration duration = new Duration();
        duration.setStart(startTime);
        duration.setEnd(endTime);
        duration.setStep(Step.valueOf((String)step));
        coldStage.ifPresent(arg_0 -> ((Duration)duration).setColdStage(arg_0));
        String clientServiceId = IDManager.ServiceID.buildId((String)clientService, (boolean)clientServiceLayer.map(s -> Layer.nameOf((String)s).isNormal()).orElse(true));
        String serverServiceId = IDManager.ServiceID.buildId((String)serverService, (boolean)serverServiceLayer.map(s -> Layer.nameOf((String)s).isNormal()).orElse(true));
        ServiceInstanceTopology topology = (ServiceInstanceTopology)this.topologyQuery.getServiceInstanceTopology(clientServiceId, serverServiceId, duration, true).join();
        DebuggingQueryInstanceTopologyRsp result = new DebuggingQueryInstanceTopologyRsp(topology.getNodes(), topology.getCalls(), this.transformTrace(topology.getDebuggingTrace()));
        return this.transToYAMLString(result);
    }

    @Get(value="/debugging/query/topology/getEndpointDependencies")
    public String getEndpointDependencies(@Param(value="startTime") String startTime, @Param(value="endTime") String endTime, @Param(value="step") String step, @Param(value="coldStage") Optional<Boolean> coldStage, @Param(value="service") String service, @Param(value="serviceLayer") Optional<String> serviceLayer, @Param(value="endpoint") String endpoint) {
        Duration duration = new Duration();
        duration.setStart(startTime);
        duration.setEnd(endTime);
        duration.setStep(Step.valueOf((String)step));
        coldStage.ifPresent(arg_0 -> ((Duration)duration).setColdStage(arg_0));
        String endpointId = IDManager.EndpointID.buildId((String)IDManager.ServiceID.buildId((String)service, (boolean)serviceLayer.map(s -> Layer.nameOf((String)s).isNormal()).orElse(true)), (String)endpoint);
        EndpointTopology topology = (EndpointTopology)this.topologyQuery.getEndpointDependencies(endpointId, duration, true).join();
        DebuggingQueryEndpointTopologyRsp result = new DebuggingQueryEndpointTopologyRsp(topology.getNodes(), topology.getCalls(), this.transformTrace(topology.getDebuggingTrace()));
        return this.transToYAMLString(result);
    }

    @Get(value="/debugging/query/topology/getProcessTopology")
    public String getProcessTopology(@Param(value="startTime") String startTime, @Param(value="endTime") String endTime, @Param(value="step") String step, @Param(value="coldStage") Optional<Boolean> coldStage, @Param(value="service") String service, @Param(value="serviceLayer") Optional<String> serviceLayer, @Param(value="instance") String process) {
        Duration duration = new Duration();
        duration.setStart(startTime);
        duration.setEnd(endTime);
        duration.setStep(Step.valueOf((String)step));
        coldStage.ifPresent(arg_0 -> ((Duration)duration).setColdStage(arg_0));
        String instanceId = IDManager.ServiceInstanceID.buildId((String)IDManager.ServiceID.buildId((String)service, (boolean)serviceLayer.map(s -> Layer.nameOf((String)s).isNormal()).orElse(true)), (String)process);
        ProcessTopology topology = (ProcessTopology)this.topologyQuery.getProcessTopology(instanceId, duration, true).join();
        DebuggingQueryProcessTopologyRsp result = new DebuggingQueryProcessTopologyRsp(topology.getNodes(), topology.getCalls(), this.transformTrace(topology.getDebuggingTrace()));
        return this.transToYAMLString(result);
    }

    @Get(value="/debugging/query/log/queryLogs")
    public String queryLogs(@Param(value="service") Optional<String> service, @Param(value="serviceLayer") Optional<String> serviceLayer, @Param(value="serviceInstance") Optional<String> serviceInstance, @Param(value="endpoint") Optional<String> endpoint, @Param(value="startTime") Optional<String> startTime, @Param(value="endTime") Optional<String> endTime, @Param(value="step") Optional<String> step, @Param(value="coldStage") Optional<Boolean> coldStage, @Param(value="traceId") Optional<String> traceId, @Param(value="segmentId") Optional<String> segmentId, @Param(value="spanId") Optional<Integer> spanId, @Param(value="tags") Optional<String> tags, @Param(value="pageNum") int pageNum, @Param(value="pageSize") int pageSize, @Param(value="keywordsOfContent") Optional<String> keywordsOfContent, @Param(value="excludingKeywordsOfContent") Optional<String> excludingKeywordsOfContent, @Param(value="queryOrder") Optional<String> queryOrder) {
        LogQueryCondition condition = new LogQueryCondition();
        condition.setPaging(new Pagination(pageNum, pageSize));
        if (traceId.isPresent()) {
            TraceScopeCondition traceScopeCondition = new TraceScopeCondition();
            traceScopeCondition.setTraceId(traceId.get());
            segmentId.ifPresent(arg_0 -> ((TraceScopeCondition)traceScopeCondition).setSegmentId(arg_0));
            spanId.ifPresent(arg_0 -> ((TraceScopeCondition)traceScopeCondition).setSpanId(arg_0));
            condition.setRelatedTrace(traceScopeCondition);
        } else {
            if (startTime.isEmpty() || endTime.isEmpty() || step.isEmpty()) {
                return "startTime, endTime and step are required";
            }
            Duration duration = new Duration();
            duration.setStart(startTime.get());
            duration.setEnd(endTime.get());
            duration.setStep(Step.valueOf((String)step.get()));
            coldStage.ifPresent(arg_0 -> ((Duration)duration).setColdStage(arg_0));
            condition.setQueryDuration(duration);
        }
        boolean isNormal = serviceLayer.map(s -> Layer.nameOf((String)s).isNormal()).orElse(true);
        Optional<String> serviceId = service.map(name -> IDManager.ServiceID.buildId((String)name, (boolean)isNormal));
        Optional<String> serviceInstanceId = serviceInstance.map(name -> IDManager.ServiceInstanceID.buildId((String)((String)serviceId.orElseThrow()), (String)name));
        Optional<String> endpointId = endpoint.map(name -> IDManager.EndpointID.buildId((String)((String)serviceId.orElseThrow()), (String)name));
        serviceId.ifPresent(arg_0 -> ((LogQueryCondition)condition).setServiceId(arg_0));
        serviceInstanceId.ifPresent(arg_0 -> ((LogQueryCondition)condition).setServiceInstanceId(arg_0));
        endpointId.ifPresent(arg_0 -> ((LogQueryCondition)condition).setEndpointId(arg_0));
        tags.ifPresent(ts -> {
            ArrayList tagList = new ArrayList();
            Arrays.stream(ts.split(",")).forEach(t -> {
                Tag tag = new Tag();
                String[] tagArr = t.split("=");
                tag.setKey(tagArr[0]);
                tag.setValue(tagArr[1]);
                tagList.add(tag);
            });
            condition.setTags(tagList);
        });
        queryOrder.ifPresent(s -> condition.setQueryOrder(Order.valueOf((String)s)));
        keywordsOfContent.ifPresent(k -> condition.setKeywordsOfContent(Arrays.stream(k.split(",")).collect(Collectors.toList())));
        excludingKeywordsOfContent.ifPresent(e -> condition.setExcludingKeywordsOfContent(Arrays.stream(e.split(",")).collect(Collectors.toList())));
        Logs logs = (Logs)this.logQuery.queryLogs(condition, true).join();
        DebuggingQueryLogsRsp result = new DebuggingQueryLogsRsp(logs.getLogs(), logs.getErrorReason(), this.transformTrace(logs.getDebuggingTrace()));
        return this.transToYAMLString(result);
    }

    private DebuggingTraceRsp transformTrace(DebuggingTrace trace) {
        Map<Integer, DebuggingSpanRsp> spanMap = trace.getSpans().stream().collect(Collectors.toMap(DebuggingSpan::getSpanId, this::transformSpan));
        trace.getSpans().forEach(span -> {
            if (span.getParentSpanId() != -1) {
                DebuggingSpanRsp parentSpan = (DebuggingSpanRsp)spanMap.get(span.getParentSpanId());
                parentSpan.getChildSpans().add((DebuggingSpanRsp)spanMap.get(span.getSpanId()));
            }
        });
        return new DebuggingTraceRsp(trace.getTraceId(), trace.getCondition(), trace.getStartTime(), trace.getEndTime(), trace.getDuration(), spanMap.get(0));
    }

    private DebuggingSpanRsp transformSpan(DebuggingSpan span) {
        return new DebuggingSpanRsp(span.getSpanId(), span.getParentSpanId(), span.getOperation(), span.getStartTime(), span.getEndTime(), span.getDuration(), span.getMsg(), span.getError());
    }

    private String transToYAMLString(Object obj) {
        YAMLFactory yamlFactory = new YAMLFactory();
        ObjectMapper mapper = new ObjectMapper((JsonFactory)yamlFactory);
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            log.error("Failed to convert object to YAML String", (Throwable)e);
            return "Failed to convert object to YAML String";
        }
    }

    private String transToYAMLStringZipkin(Object obj) {
        YAMLFactory yamlFactory = new YAMLFactory();
        ObjectMapper mapper = new ObjectMapper((JsonFactory)yamlFactory).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            log.error("Failed to convert object to YAML String", (Throwable)e);
            return "Failed to convert object to YAML String";
        }
    }
}

