/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.debug;

import com.google.gson.Gson;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import lombok.Generated;
import org.apache.skywalking.oap.query.debug.AlarmStatusQueryService;
import org.apache.skywalking.oap.query.debug.StatusQueryExceptionHandler;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExceptionHandler(value=StatusQueryExceptionHandler.class)
public class AlarmStatusQueryHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlarmStatusQueryHandler.class);
    private static final Gson GSON = new Gson();
    private final ModuleManager moduleManager;
    private AlarmStatusQueryService queryService;

    public AlarmStatusQueryHandler(ModuleManager manager) {
        this.moduleManager = manager;
    }

    private AlarmStatusQueryService getQueryService() {
        if (this.queryService == null) {
            this.queryService = (AlarmStatusQueryService)this.moduleManager.find("status-query").provider().getService(AlarmStatusQueryService.class);
        }
        return this.queryService;
    }

    @Get(value="/status/alarm/rules")
    public HttpResponse getAlarmRules() {
        String result = GSON.toJson(this.getQueryService().getAlarmRules());
        return HttpResponse.of((MediaType)MediaType.JSON_UTF_8, (String)result);
    }

    @Get(value="/status/alarm/{ruleId}")
    public HttpResponse getAlarmRuleByName(@Param(value="ruleId") String ruleName) {
        String result = GSON.toJson(this.getQueryService().getAlarmRuleById(ruleName));
        return HttpResponse.of((MediaType)MediaType.JSON_UTF_8, (String)result);
    }

    @Get(value="/status/alarm/{ruleId}/{entityName}")
    public HttpResponse getAlarmRuleContext(@Param(value="ruleId") String ruleId, @Param(value="entityName") String entityName) {
        String result = GSON.toJson(this.getQueryService().getAlarmRuleContext(ruleId, entityName));
        return HttpResponse.of((MediaType)MediaType.JSON_UTF_8, (String)result);
    }
}

