/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.file;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.shaded.guava.base.Splitter;
import com.linecorp.armeria.internal.shaded.guava.math.LongMath;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.file.HttpFile;
import com.linecorp.armeria.server.file.HttpFileAttributes;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.time.Clock;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;

public abstract class AbstractHttpFile
implements HttpFile {
    private static final Splitter etagSplitter = Splitter.on(',').trimResults().omitEmptyStrings();
    @Nullable
    private final MediaType contentType;
    private final Clock clock;
    private final boolean dateEnabled;
    private final boolean lastModifiedEnabled;
    @Nullable
    private final BiFunction<String, HttpFileAttributes, String> entityTagFunction;
    private final HttpHeaders additionalHeaders;

    protected AbstractHttpFile(@Nullable MediaType contentType, Clock clock, boolean dateEnabled, boolean lastModifiedEnabled, @Nullable BiFunction<String, HttpFileAttributes, String> entityTagFunction, HttpHeaders additionalHeaders) {
        this.contentType = contentType;
        this.clock = Objects.requireNonNull(clock, "clock");
        this.dateEnabled = dateEnabled;
        this.lastModifiedEnabled = lastModifiedEnabled;
        this.entityTagFunction = entityTagFunction;
        this.additionalHeaders = Objects.requireNonNull(additionalHeaders, "additionalHeaders");
    }

    @Nullable
    protected final MediaType contentType() {
        return this.contentType;
    }

    protected final Clock clock() {
        return this.clock;
    }

    protected abstract String pathOrUri();

    protected final boolean isDateEnabled() {
        return this.dateEnabled;
    }

    protected final boolean isLastModifiedEnabled() {
        return this.lastModifiedEnabled;
    }

    protected final HttpHeaders additionalHeaders() {
        return this.additionalHeaders;
    }

    @Nullable
    protected final String generateEntityTag(HttpFileAttributes attrs) {
        Objects.requireNonNull(attrs, "attrs");
        return this.entityTagFunction != null ? this.entityTagFunction.apply(this.pathOrUri(), attrs) : null;
    }

    @Nullable
    BiFunction<String, HttpFileAttributes, String> entityTagFunction() {
        return this.entityTagFunction;
    }

    @Override
    public CompletableFuture<ResponseHeaders> readHeaders(Executor fileReadExecutor) {
        return this.readAttributes(fileReadExecutor).thenApply(this::readHeaders);
    }

    @Nullable
    protected final ResponseHeaders readHeaders(@Nullable HttpFileAttributes attrs) {
        if (attrs == null) {
            return null;
        }
        String etag = this.generateEntityTag(attrs);
        ResponseHeadersBuilder headers = ResponseHeaders.builder(HttpStatus.OK).addLong(HttpHeaderNames.CONTENT_LENGTH, attrs.length());
        return this.addCommonHeaders(headers, attrs, etag);
    }

    private ResponseHeaders addCommonHeaders(ResponseHeadersBuilder headers, HttpFileAttributes attrs, @Nullable String etag) {
        if (this.contentType != null) {
            headers.contentType(this.contentType);
        }
        if (this.dateEnabled) {
            headers.setTimeMillis(HttpHeaderNames.DATE, this.clock.millis());
        }
        if (this.lastModifiedEnabled) {
            headers.setTimeMillis(HttpHeaderNames.LAST_MODIFIED, attrs.lastModifiedMillis());
        }
        if (etag != null) {
            headers.set((CharSequence)HttpHeaderNames.ETAG, '\"' + etag + '\"');
        }
        headers.set((Iterable)this.additionalHeaders);
        return headers.build();
    }

    @Override
    public final CompletableFuture<HttpResponse> read(Executor fileReadExecutor, ByteBufAllocator alloc) {
        Objects.requireNonNull(fileReadExecutor, "fileReadExecutor");
        Objects.requireNonNull(alloc, "alloc");
        return ((CompletableFuture)this.readAttributes(fileReadExecutor).thenApply(attrs -> this.read(fileReadExecutor, alloc, (HttpFileAttributes)attrs))).exceptionally(cause -> HttpResponse.ofFailure(Exceptions.peel(cause)));
    }

    @Nullable
    private HttpResponse read(Executor fileReadExecutor, ByteBufAllocator alloc, @Nullable HttpFileAttributes attrs) {
        ResponseHeaders headers = this.readHeaders(attrs);
        if (headers == null) {
            return null;
        }
        assert (attrs != null);
        long length = attrs.length();
        if (length == 0L) {
            return HttpResponse.of(headers);
        }
        try {
            return this.doRead(headers, length, fileReadExecutor, alloc);
        }
        catch (IOException e) {
            return (HttpResponse)Exceptions.throwUnsafely(e);
        }
    }

    @Nullable
    protected abstract HttpResponse doRead(ResponseHeaders var1, long var2, Executor var4, ByteBufAllocator var5) throws IOException;

    @Override
    public HttpService asService() {
        return (ctx, req) -> {
            HttpMethod method = ctx.method();
            if (method != HttpMethod.GET && method != HttpMethod.HEAD) {
                return HttpResponse.of(HttpStatus.METHOD_NOT_ALLOWED);
            }
            return HttpResponse.of((CompletableFuture<? extends HttpResponse>)this.readAttributes(ctx.blockingTaskExecutor()).thenApply(attrs -> {
                if (attrs == null) {
                    return HttpResponse.of(HttpStatus.NOT_FOUND);
                }
                RequestHeaders reqHeaders = req.headers();
                String etag = this.generateEntityTag((HttpFileAttributes)attrs);
                String ifNoneMatch = reqHeaders.get(HttpHeaderNames.IF_NONE_MATCH);
                if (etag != null && ifNoneMatch != null && ("*".equals(ifNoneMatch) || AbstractHttpFile.entityTagMatches(etag, ifNoneMatch))) {
                    return this.newNotModified((HttpFileAttributes)attrs, etag);
                }
                if (ifNoneMatch == null) {
                    try {
                        Long ifModifiedSince = reqHeaders.getTimeMillis(HttpHeaderNames.IF_MODIFIED_SINCE);
                        if (ifModifiedSince != null) {
                            long ifModifiedSinceMillis = LongMath.saturatedAdd(ifModifiedSince, 999L);
                            if (attrs.lastModifiedMillis() <= ifModifiedSinceMillis) {
                                return this.newNotModified((HttpFileAttributes)attrs, etag);
                            }
                        }
                    }
                    catch (Exception ifModifiedSince) {
                        // empty catch block
                    }
                }
                switch (ctx.method()) {
                    case HEAD: {
                        ResponseHeaders resHeaders = this.readHeaders((HttpFileAttributes)attrs);
                        if (resHeaders == null) break;
                        return HttpResponse.of(resHeaders);
                    }
                    case GET: {
                        HttpResponse res = this.read(ctx.blockingTaskExecutor(), ctx.alloc(), (HttpFileAttributes)attrs);
                        if (res == null) break;
                        return res;
                    }
                    default: {
                        throw new Error();
                    }
                }
                return HttpResponse.of(HttpStatus.NOT_FOUND);
            }));
        };
    }

    private static boolean entityTagMatches(String entityTag, String ifNoneMatch) {
        for (String candidate : etagSplitter.split(ifNoneMatch)) {
            String candidateETag = AbstractHttpFile.extractEntityTag(candidate);
            if (!entityTag.equals(candidateETag)) continue;
            return true;
        }
        return false;
    }

    private static String extractEntityTag(String value) {
        int i;
        int etagStart = -1;
        int etagEnd = -1;
        for (i = 0; i < value.length(); ++i) {
            if (value.charAt(i) != '\"') continue;
            etagStart = i + 1;
            ++i;
            break;
        }
        if (etagStart < 0) {
            return value;
        }
        while (i < value.length()) {
            if (value.charAt(i) == '\"') {
                etagEnd = i;
                break;
            }
            ++i;
        }
        return etagEnd > 0 ? value.substring(etagStart, etagEnd) : value.substring(etagStart);
    }

    private HttpResponse newNotModified(HttpFileAttributes attrs, @Nullable String etag) {
        return HttpResponse.of(this.addCommonHeaders(ResponseHeaders.builder(HttpStatus.NOT_MODIFIED), attrs, etag));
    }
}

