/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.AbstractEndpointGroup;
import com.linecorp.armeria.client.endpoint.DynamicEndpointGroupBuilder;
import com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import com.linecorp.armeria.client.endpoint.EndpointSelector;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.util.AsyncCloseableSupport;
import com.linecorp.armeria.common.util.EventLoopCheckingFuture;
import com.linecorp.armeria.common.util.ListenableAsyncCloseable;
import com.linecorp.armeria.internal.client.endpoint.EndpointToStringUtil;
import com.linecorp.armeria.internal.common.util.CollectionUtil;
import com.linecorp.armeria.internal.common.util.ReentrantShortLock;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import com.linecorp.armeria.internal.shaded.guava.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicEndpointGroup
extends AbstractEndpointGroup
implements ListenableAsyncCloseable {
    private static final Logger logger = LoggerFactory.getLogger(DynamicEndpointGroup.class);
    private static final List<Endpoint> UNINITIALIZED_ENDPOINTS = Collections.unmodifiableList(new ArrayList());
    private final EndpointSelectionStrategy selectionStrategy;
    private final AtomicReference<EndpointSelector> selector = new AtomicReference();
    private volatile List<Endpoint> endpoints = UNINITIALIZED_ENDPOINTS;
    private final Lock endpointsLock = new ReentrantShortLock();
    private final CompletableFuture<List<Endpoint>> initialEndpointsFuture = new InitialEndpointsFuture();
    private final AsyncCloseableSupport closeable = AsyncCloseableSupport.of(this::closeAsync);
    private final boolean allowEmptyEndpoints;
    private final long selectionTimeoutMillis;

    @UnstableApi
    public static DynamicEndpointGroupBuilder builder() {
        return new DynamicEndpointGroupBuilder();
    }

    public DynamicEndpointGroup() {
        this(EndpointSelectionStrategy.weightedRoundRobin());
    }

    public DynamicEndpointGroup(EndpointSelectionStrategy selectionStrategy) {
        this(selectionStrategy, true);
    }

    protected DynamicEndpointGroup(boolean allowEmptyEndpoints) {
        this(EndpointSelectionStrategy.weightedRoundRobin(), allowEmptyEndpoints);
    }

    protected DynamicEndpointGroup(boolean allowEmptyEndpoints, long selectionTimeoutMillis) {
        this(EndpointSelectionStrategy.weightedRoundRobin(), allowEmptyEndpoints, selectionTimeoutMillis);
    }

    protected DynamicEndpointGroup(EndpointSelectionStrategy selectionStrategy, boolean allowEmptyEndpoints) {
        this(selectionStrategy, allowEmptyEndpoints, Flags.defaultConnectTimeoutMillis());
    }

    protected DynamicEndpointGroup(EndpointSelectionStrategy selectionStrategy, boolean allowEmptyEndpoints, long selectionTimeoutMillis) {
        this.selectionStrategy = Objects.requireNonNull(selectionStrategy, "selectionStrategy");
        this.allowEmptyEndpoints = allowEmptyEndpoints;
        Preconditions.checkArgument(selectionTimeoutMillis >= 0L, "selectionTimeoutMillis: %s (expected: >= 0)", selectionTimeoutMillis);
        if (selectionTimeoutMillis == 0L) {
            selectionTimeoutMillis = Long.MAX_VALUE;
        }
        this.selectionTimeoutMillis = selectionTimeoutMillis;
    }

    @UnstableApi
    public boolean allowsEmptyEndpoints() {
        return this.allowEmptyEndpoints;
    }

    @Override
    public final List<Endpoint> endpoints() {
        return this.endpoints;
    }

    @Override
    public final EndpointSelectionStrategy selectionStrategy() {
        return this.selectionStrategy;
    }

    @Override
    @Nullable
    public final Endpoint selectNow(ClientRequestContext ctx) {
        return this.maybeCreateSelector().selectNow(ctx);
    }

    @Override
    public long selectionTimeoutMillis() {
        return this.selectionTimeoutMillis;
    }

    @Override
    @Deprecated
    public final CompletableFuture<Endpoint> select(ClientRequestContext ctx, ScheduledExecutorService executor, long timeoutMillis) {
        return this.select(ctx, executor);
    }

    @Override
    public final CompletableFuture<Endpoint> select(ClientRequestContext ctx, ScheduledExecutorService executor) {
        return this.maybeCreateSelector().select(ctx, executor);
    }

    private EndpointSelector maybeCreateSelector() {
        EndpointSelector selector = this.selector.get();
        if (selector != null) {
            return selector;
        }
        EndpointSelector newSelector = this.selectionStrategy.newSelector(this);
        if (this.selector.compareAndSet(null, newSelector)) {
            return newSelector;
        }
        EndpointSelector oldSelector = this.selector.get();
        assert (oldSelector != null);
        return oldSelector;
    }

    @Override
    public final CompletableFuture<List<Endpoint>> whenReady() {
        return this.initialEndpointsFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addEndpoint(Endpoint e) {
        ImmutableList<Endpoint> newEndpoints;
        this.endpointsLock.lock();
        try {
            ArrayList<Endpoint> newEndpointsUnsorted = Lists.newArrayList(this.endpoints);
            newEndpointsUnsorted.add(e);
            newEndpoints = ImmutableList.sortedCopyOf(newEndpointsUnsorted);
            this.endpoints = newEndpoints;
            logger.info("An endpoint has been added: {}. Current endpoints: {}", (Object)EndpointToStringUtil.toShortString(e), (Object)EndpointToStringUtil.toShortString(newEndpoints));
        }
        finally {
            this.endpointsLock.unlock();
        }
        this.maybeCompleteInitialEndpointsFuture(newEndpoints);
        this.notifyListeners(newEndpoints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeEndpoint(Endpoint e) {
        List newEndpoints;
        this.endpointsLock.lock();
        try {
            List<Endpoint> oldEndpoints = this.endpoints;
            if (!this.allowEmptyEndpoints && oldEndpoints.size() == 1) {
                return;
            }
            this.endpoints = newEndpoints = (List)oldEndpoints.stream().filter(endpoint -> !endpoint.equals(e)).collect(ImmutableList.toImmutableList());
            if (this.endpoints.size() != oldEndpoints.size()) {
                logger.info("An endpoint has been removed: {}. Current endpoints: {}", (Object)EndpointToStringUtil.toShortString(e), (Object)EndpointToStringUtil.toShortString(newEndpoints));
            }
        }
        finally {
            this.endpointsLock.unlock();
        }
        this.notifyListeners(newEndpoints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setEndpoints(Iterable<Endpoint> endpoints) {
        ImmutableList<Endpoint> newEndpoints;
        if (!this.allowEmptyEndpoints && Iterables.isEmpty(endpoints)) {
            return;
        }
        this.endpointsLock.lock();
        try {
            List<Endpoint> oldEndpoints = this.endpoints;
            newEndpoints = ImmutableList.sortedCopyOf(endpoints);
            if (!DynamicEndpointGroup.hasChanges(oldEndpoints, newEndpoints)) {
                return;
            }
            this.endpoints = newEndpoints;
            logger.info("New endpoints have been set: {}", (Object)EndpointToStringUtil.toShortString(newEndpoints));
        }
        finally {
            this.endpointsLock.unlock();
        }
        this.maybeCompleteInitialEndpointsFuture(newEndpoints);
        this.notifyListeners(newEndpoints);
    }

    private static boolean hasChanges(List<Endpoint> oldEndpoints, List<Endpoint> newEndpoints) {
        if (oldEndpoints == UNINITIALIZED_ENDPOINTS) {
            return true;
        }
        if (oldEndpoints.size() != newEndpoints.size()) {
            return true;
        }
        for (int i = 0; i < oldEndpoints.size(); ++i) {
            Endpoint b;
            Endpoint a = oldEndpoints.get(i);
            if (a.equals(b = newEndpoints.get(i)) && a.weight() == b.weight() && a.attrs().equals(b.attrs())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    protected List<Endpoint> latestValue() {
        List<Endpoint> endpoints = this.endpoints;
        if (endpoints == UNINITIALIZED_ENDPOINTS) {
            return null;
        }
        return endpoints;
    }

    private void maybeCompleteInitialEndpointsFuture(List<Endpoint> endpoints) {
        if (endpoints != UNINITIALIZED_ENDPOINTS && !this.initialEndpointsFuture.isDone()) {
            this.initialEndpointsFuture.complete(endpoints);
        }
    }

    @Override
    public final boolean isClosing() {
        return this.closeable.isClosing();
    }

    @Override
    public final boolean isClosed() {
        return this.closeable.isClosed();
    }

    @Override
    public final CompletableFuture<?> whenClosed() {
        return this.closeable.whenClosed();
    }

    @Override
    public final CompletableFuture<?> closeAsync() {
        return this.closeable.closeAsync();
    }

    private void closeAsync(CompletableFuture<?> future) {
        if (!this.initialEndpointsFuture.isDone()) {
            this.initialEndpointsFuture.cancel(false);
        }
        this.doCloseAsync(future);
    }

    protected void doCloseAsync(CompletableFuture<?> future) {
        future.complete(null);
    }

    @Override
    public final void close() {
        this.closeable.close();
    }

    public String toString() {
        return this.toString(unused -> {});
    }

    @UnstableApi
    protected final String toString(Consumer<? super StringBuilder> builderMutator) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append("{selector=").append(this.toStringSelector());
        buf.append(", allowsEmptyEndpoints=").append(this.allowEmptyEndpoints);
        buf.append(", initialized=").append(this.initialEndpointsFuture.isDone());
        buf.append(", numEndpoints=").append(this.endpoints.size());
        buf.append(", endpoints=").append(CollectionUtil.truncate(this.endpoints, 10));
        builderMutator.accept(buf);
        return buf.append('}').toString();
    }

    protected String toStringSelector() {
        EndpointSelector endpointSelector = this.selector.get();
        if (endpointSelector == null) {
            return this.selectionStrategy.getClass().toString();
        }
        return endpointSelector.toString();
    }

    private class InitialEndpointsFuture
    extends EventLoopCheckingFuture<List<Endpoint>> {
        private InitialEndpointsFuture() {
        }

        @Override
        public List<Endpoint> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                return (List)super.get(timeout, unit);
            }
            catch (TimeoutException e) {
                TimeoutException timeoutException = new TimeoutException(InitialEndpointsFuture.class.getSimpleName() + " is timed out after " + unit.toMillis(timeout) + " milliseconds. endpoint group: " + DynamicEndpointGroup.this);
                timeoutException.initCause(e);
                throw timeoutException;
            }
        }
    }
}

