/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.agent.kafka.provider.handler;

import lombok.Generated;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.utils.Bytes;
import org.apache.skywalking.apm.network.language.profile.v3.ThreadSnapshot;
import org.apache.skywalking.oap.server.analyzer.agent.kafka.module.KafkaFetcherConfig;
import org.apache.skywalking.oap.server.analyzer.agent.kafka.provider.handler.AbstractKafkaHandler;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.analysis.worker.RecordStreamProcessor;
import org.apache.skywalking.oap.server.core.profiling.trace.ProfileThreadSnapshotRecord;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileTaskHandler
extends AbstractKafkaHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProfileTaskHandler.class);
    private final HistogramMetrics histogram;
    private final CounterMetrics errorCounter;

    public ProfileTaskHandler(ModuleManager manager, KafkaFetcherConfig config) {
        super(manager, config);
        MetricsCreator metricsCreator = (MetricsCreator)manager.find("telemetry").provider().getService(MetricsCreator.class);
        this.histogram = metricsCreator.createHistogramMetric("profile_task_in_latency", "The process latency of profile task", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"kafka"}), new double[0]);
        this.errorCounter = metricsCreator.createCounter("profile_task_analysis_error_count", "The error number of profile task process", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"kafka"}));
    }

    @Override
    public void handle(ConsumerRecord<String, Bytes> record) {
        try (HistogramMetrics.Timer ignored = this.histogram.createTimer();){
            ThreadSnapshot snapshot = ThreadSnapshot.parseFrom((byte[])((Bytes)record.value()).get());
            if (log.isDebugEnabled()) {
                log.debug("Fetched a thread snapshot[{}] from task[{}] reported", (Object)snapshot.getTraceSegmentId(), (Object)snapshot.getTaskId());
            }
            ProfileThreadSnapshotRecord snapshotRecord = new ProfileThreadSnapshotRecord();
            snapshotRecord.setTaskId(snapshot.getTaskId());
            snapshotRecord.setSegmentId(snapshot.getTraceSegmentId());
            snapshotRecord.setDumpTime(snapshot.getTime());
            snapshotRecord.setSequence(snapshot.getSequence());
            snapshotRecord.setStackBinary(snapshot.getStack().toByteArray());
            snapshotRecord.setTimeBucket(TimeBucket.getRecordTimeBucket((long)snapshot.getTime()));
            RecordStreamProcessor.getInstance().in((Record)snapshotRecord);
        }
        catch (Exception e) {
            this.errorCounter.inc();
            log.error("handle record failed", (Throwable)e);
        }
    }

    @Override
    protected String getPlainTopic() {
        return this.config.getTopicNameOfProfiling();
    }
}

