/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.bulk;

import com.google.protobuf.GeneratedMessageV3;
import io.grpc.stub.AbstractAsyncStub;
import io.grpc.stub.StreamObserver;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.skywalking.banyandb.v1.client.AbstractWrite;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBulkWriteProcessor<REQ extends GeneratedMessageV3, STUB extends AbstractAsyncStub<STUB>>
implements Runnable,
Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractBulkWriteProcessor.class);
    private final STUB stub;
    private final int maxBulkSize;
    private final int flushInterval;
    private final ArrayBlockingQueue<Holder> requests;
    private final Semaphore semaphore;
    private final long flushInternalInMillis;
    private final ScheduledThreadPoolExecutor scheduler;
    private final int timeout;
    private volatile long lastFlushTS = 0L;

    protected AbstractBulkWriteProcessor(STUB stub, String processorName, int maxBulkSize, int flushInterval, int concurrency, int timeout) {
        this.stub = stub;
        this.maxBulkSize = maxBulkSize;
        this.flushInterval = flushInterval;
        this.timeout = timeout;
        this.requests = new ArrayBlockingQueue(maxBulkSize + 1);
        this.semaphore = new Semaphore(concurrency > 0 ? concurrency : 1);
        this.scheduler = new ScheduledThreadPoolExecutor(1, r -> {
            Thread thread = new Thread(r);
            thread.setName("BanyanDB BulkProcessor");
            return thread;
        });
        this.scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.scheduler.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        this.scheduler.setRemoveOnCancelPolicy(true);
        this.flushInternalInMillis = flushInterval * 1000;
        this.scheduler.scheduleWithFixedDelay(this, 0L, flushInterval, TimeUnit.SECONDS);
    }

    public CompletableFuture<Void> add(AbstractWrite<REQ> writeEntity) {
        CompletableFuture<Void> f = new CompletableFuture<Void>();
        this.requests.put(Holder.create(writeEntity, f));
        this.flushIfNeeded();
        return f;
    }

    @Override
    public void run() {
        try {
            this.doPeriodicalFlush();
        }
        catch (Throwable t) {
            log.error("Failed to flush data to BanyanDB", t);
        }
    }

    protected void flushIfNeeded() {
        if (this.requests.size() >= this.maxBulkSize) {
            this.flush();
        }
    }

    private void doPeriodicalFlush() {
        if (System.currentTimeMillis() - this.lastFlushTS > this.flushInternalInMillis / 2L) {
            this.flush();
        }
    }

    public void flush() {
        if (this.requests.isEmpty()) {
            return;
        }
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            log.error("Interrupted when trying to get semaphore to execute bulk requests", (Throwable)e);
            return;
        }
        ArrayList<Holder> batch = new ArrayList<Holder>(this.requests.size());
        this.requests.drainTo(batch);
        CompletableFuture<Void> future = this.doObservedFlush(batch);
        future.whenComplete((v, t) -> this.semaphore.release());
        future.join();
        this.lastFlushTS = System.currentTimeMillis();
    }

    protected abstract CompletableFuture<Void> doObservedFlush(List<Holder> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Void> doFlush(List<Holder> data, HistogramMetrics.Timer timer) {
        CompletableFuture<Void> batch = new CompletableFuture<Void>();
        StreamObserver writeRequestStreamObserver = this.buildStreamObserver((AbstractAsyncStub)this.stub.withDeadlineAfter((long)this.timeout, TimeUnit.SECONDS), batch);
        try {
            data.forEach(h -> {
                GeneratedMessageV3 request;
                AbstractWrite<?> entity = h.getWriteEntity();
                try {
                    request = entity.build();
                }
                catch (Throwable bt) {
                    log.error("building the entity fails: {}", (Object)entity.toString(), (Object)bt);
                    h.getFuture().completeExceptionally(bt);
                    return;
                }
                writeRequestStreamObserver.onNext((Object)request);
                h.getFuture().complete(null);
            });
        }
        finally {
            writeRequestStreamObserver.onCompleted();
        }
        batch.whenComplete((ignored, exp) -> {
            timer.close();
            if (exp != null) {
                log.error("Failed to execute requests in bulk", exp);
            }
        });
        return batch;
    }

    @Override
    public void close() {
        this.scheduler.shutdownNow();
    }

    protected abstract StreamObserver<REQ> buildStreamObserver(STUB var1, CompletableFuture<Void> var2);

    static class Holder {
        private final AbstractWrite<?> writeEntity;
        private final CompletableFuture<Void> future;

        private Holder(AbstractWrite<?> writeEntity, CompletableFuture<Void> future) {
            this.writeEntity = writeEntity;
            this.future = future;
        }

        public static <REQ extends GeneratedMessageV3> Holder create(AbstractWrite<REQ> writeEntity, CompletableFuture<Void> future) {
            future.whenComplete((v, t) -> {
                if (t != null) {
                    log.error("Failed to execute the request: {}", (Object)writeEntity.toString(), t);
                }
            });
            return new Holder(writeEntity, future);
        }

        @Generated
        public AbstractWrite<?> getWriteEntity() {
            return this.writeEntity;
        }

        @Generated
        public CompletableFuture<Void> getFuture() {
            return this.future;
        }
    }
}

