/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb;

import java.util.HashSet;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;
import org.apache.skywalking.banyandb.database.v1.BanyandbDatabase;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.apache.skywalking.oap.server.core.RunningMode;
import org.apache.skywalking.oap.server.core.storage.IBatchDAO;
import org.apache.skywalking.oap.server.core.storage.IHistoryDeleteDAO;
import org.apache.skywalking.oap.server.core.storage.StorageBuilderFactory;
import org.apache.skywalking.oap.server.core.storage.StorageDAO;
import org.apache.skywalking.oap.server.core.storage.StorageModule;
import org.apache.skywalking.oap.server.core.storage.cache.INetworkAddressAliasDAO;
import org.apache.skywalking.oap.server.core.storage.management.UIMenuManagementDAO;
import org.apache.skywalking.oap.server.core.storage.management.UITemplateManagementDAO;
import org.apache.skywalking.oap.server.core.storage.model.ModelCreator;
import org.apache.skywalking.oap.server.core.storage.model.ModelInstaller;
import org.apache.skywalking.oap.server.core.storage.profiling.asyncprofiler.IAsyncProfilerTaskLogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.asyncprofiler.IAsyncProfilerTaskQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.asyncprofiler.IJFRDataQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.continuous.IContinuousProfilingPolicyDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IEBPFProfilingDataDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IEBPFProfilingScheduleDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IEBPFProfilingTaskDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IServiceLabelDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.pprof.IPprofDataQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.pprof.IPprofTaskLogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.pprof.IPprofTaskQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileTaskLogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileTaskQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileThreadSnapshotQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IAggregationQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IAlarmQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IBrowserLogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IEventQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IHierarchyQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ILogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IMetadataQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IMetricsQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IRecordsQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ISpanAttachedEventQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITagAutoCompleteQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITopologyQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITraceQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IZipkinQueryDAO;
import org.apache.skywalking.oap.server.core.storage.ttl.StorageTTLStatusQuery;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.HealthChecker;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBAggregationQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBBatchDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBConfigLoader;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBIndexInstaller;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBRecordsQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageConfig;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBTTLStatusQuery;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBUIMenuManagementDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBUITemplateManagementDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.measure.BanyanDBEBPFProfilingScheduleQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.measure.BanyanDBHierarchyQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.measure.BanyanDBMetadataQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.measure.BanyanDBMetricsQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.measure.BanyanDBNetworkAddressAliasDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.measure.BanyanDBServiceLabelDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.measure.BanyanDBTagAutocompleteQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.measure.BanyanDBTopologyQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBAlarmQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBAsyncProfilerTaskLogQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBAsyncProfilerTaskQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBBrowserLogQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBContinuousProfilingPolicyDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBEBPFProfilingDataDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBEBPFProfilingTaskDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBEventQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBHistoryDeleteDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBJFRDataQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBLogQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBPprofDataQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBPprofTaskLogQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBPprofTaskQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBProfileTaskLogQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBProfileTaskQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBProfileThreadSnapshotQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBSpanAttachedEventQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.BanyanDBStorageDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.trace.BanyanDBTraceQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.trace.BanyanDBZipkinQueryDAO;
import org.apache.skywalking.oap.server.telemetry.api.HealthCheckMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BanyanDBStorageProvider
extends ModuleProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BanyanDBStorageProvider.class);
    private BanyanDBStorageConfig config;
    private BanyanDBStorageClient client;
    private ModelInstaller modelInstaller;

    public String name() {
        return "banyandb";
    }

    public Class<? extends ModuleDefine> module() {
        return StorageModule.class;
    }

    public ModuleProvider.ConfigCreator newConfigCreator() {
        return new ModuleProvider.ConfigCreator<BanyanDBStorageConfig>(){

            public Class type() {
                return BanyanDBStorageConfig.class;
            }

            public void onInitialized(BanyanDBStorageConfig initialized) {
            }
        };
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
        this.config = new BanyanDBConfigLoader(this).loadConfig();
        if (StringUtil.isBlank((String)this.config.getGlobal().getNamespace())) {
            this.config.getGlobal().setNamespace("sw");
        }
        if (this.config.getMetricsDay().getTtl() > this.config.getMetadata().getTtl()) {
            throw new ModuleStartException("metricsDay ttl must be less than or equal to metadata ttl");
        }
        if (this.config.getMetricsHour().getTtl() > this.config.getMetadata().getTtl()) {
            throw new ModuleStartException("metricsHour must be less than or equal to metadata ttl");
        }
        if (this.config.getMetricsMin().getTtl() > this.config.getMetadata().getTtl()) {
            throw new ModuleStartException("metricsMin must be less than or equal to metadata ttl");
        }
        this.registerServiceImplementation(StorageBuilderFactory.class, (Service)new StorageBuilderFactory.Default());
        this.client = new BanyanDBStorageClient(this.getManager(), this.config);
        this.modelInstaller = new BanyanDBIndexInstaller(this.client, this.getManager(), this.config);
        this.registerServiceImplementation(IBatchDAO.class, (Service)new BanyanDBBatchDAO(this.client, this.config.getGlobal().getMaxBulkSize(), this.config.getGlobal().getFlushInterval(), this.config.getGlobal().getConcurrentWriteThreads()));
        this.registerServiceImplementation(StorageDAO.class, (Service)new BanyanDBStorageDAO(this.client));
        this.registerServiceImplementation(INetworkAddressAliasDAO.class, (Service)new BanyanDBNetworkAddressAliasDAO(this.client, this.config));
        this.registerServiceImplementation(ITraceQueryDAO.class, (Service)new BanyanDBTraceQueryDAO(this.client, this.config.getGlobal().getSegmentQueryMaxSize(), this.getManager()));
        this.registerServiceImplementation(IBrowserLogQueryDAO.class, (Service)new BanyanDBBrowserLogQueryDAO(this.client));
        this.registerServiceImplementation(IMetadataQueryDAO.class, (Service)new BanyanDBMetadataQueryDAO(this.client, this.config));
        this.registerServiceImplementation(IAlarmQueryDAO.class, (Service)new BanyanDBAlarmQueryDAO(this.client));
        this.registerServiceImplementation(ILogQueryDAO.class, (Service)new BanyanDBLogQueryDAO(this.client));
        this.registerServiceImplementation(IProfileTaskQueryDAO.class, (Service)new BanyanDBProfileTaskQueryDAO(this.client, this.config.getGlobal().getProfileTaskQueryMaxSize()));
        this.registerServiceImplementation(IProfileTaskLogQueryDAO.class, (Service)new BanyanDBProfileTaskLogQueryDAO(this.client, this.config.getGlobal().getProfileTaskQueryMaxSize()));
        this.registerServiceImplementation(IProfileThreadSnapshotQueryDAO.class, (Service)new BanyanDBProfileThreadSnapshotQueryDAO(this.client, this.config.getGlobal().getProfileTaskQueryMaxSize()));
        this.registerServiceImplementation(UITemplateManagementDAO.class, (Service)new BanyanDBUITemplateManagementDAO(this.client));
        this.registerServiceImplementation(UIMenuManagementDAO.class, (Service)new BanyanDBUIMenuManagementDAO(this.client));
        this.registerServiceImplementation(IEventQueryDAO.class, (Service)new BanyanDBEventQueryDAO(this.client));
        this.registerServiceImplementation(ITopologyQueryDAO.class, (Service)new BanyanDBTopologyQueryDAO(this.client));
        this.registerServiceImplementation(IEBPFProfilingTaskDAO.class, (Service)new BanyanDBEBPFProfilingTaskDAO(this.client));
        this.registerServiceImplementation(IEBPFProfilingDataDAO.class, (Service)new BanyanDBEBPFProfilingDataDAO(this.client, this.config.getGlobal().getProfileDataQueryBatchSize()));
        this.registerServiceImplementation(IEBPFProfilingScheduleDAO.class, (Service)new BanyanDBEBPFProfilingScheduleQueryDAO(this.client));
        this.registerServiceImplementation(IContinuousProfilingPolicyDAO.class, (Service)new BanyanDBContinuousProfilingPolicyDAO(this.client));
        this.registerServiceImplementation(IServiceLabelDAO.class, (Service)new BanyanDBServiceLabelDAO(this.client, this.config));
        this.registerServiceImplementation(ITagAutoCompleteQueryDAO.class, (Service)new BanyanDBTagAutocompleteQueryDAO(this.client));
        this.registerServiceImplementation(IHistoryDeleteDAO.class, (Service)new BanyanDBHistoryDeleteDAO());
        this.registerServiceImplementation(IMetricsQueryDAO.class, (Service)new BanyanDBMetricsQueryDAO(this.client));
        this.registerServiceImplementation(IAggregationQueryDAO.class, (Service)new BanyanDBAggregationQueryDAO(this.client));
        this.registerServiceImplementation(IRecordsQueryDAO.class, (Service)new BanyanDBRecordsQueryDAO(this.client));
        this.registerServiceImplementation(IZipkinQueryDAO.class, (Service)new BanyanDBZipkinQueryDAO(this.client));
        this.registerServiceImplementation(ISpanAttachedEventQueryDAO.class, (Service)new BanyanDBSpanAttachedEventQueryDAO(this.client, this.config.getGlobal().getProfileDataQueryBatchSize()));
        this.registerServiceImplementation(IHierarchyQueryDAO.class, (Service)new BanyanDBHierarchyQueryDAO(this.client, this.config));
        this.registerServiceImplementation(IAsyncProfilerTaskQueryDAO.class, (Service)new BanyanDBAsyncProfilerTaskQueryDAO(this.client, this.config.getGlobal().getAsyncProfilerTaskQueryMaxSize()));
        this.registerServiceImplementation(IAsyncProfilerTaskLogQueryDAO.class, (Service)new BanyanDBAsyncProfilerTaskLogQueryDAO(this.client, this.config.getGlobal().getAsyncProfilerTaskQueryMaxSize()));
        this.registerServiceImplementation(IJFRDataQueryDAO.class, (Service)new BanyanDBJFRDataQueryDAO(this.client));
        this.registerServiceImplementation(IPprofTaskQueryDAO.class, (Service)new BanyanDBPprofTaskQueryDAO(this.client, this.config.getGlobal().getPprofTaskQueryMaxSize()));
        this.registerServiceImplementation(IPprofTaskLogQueryDAO.class, (Service)new BanyanDBPprofTaskLogQueryDAO(this.client, this.config.getGlobal().getPprofTaskQueryMaxSize()));
        this.registerServiceImplementation(IPprofDataQueryDAO.class, (Service)new BanyanDBPprofDataQueryDAO(this.client));
        this.registerServiceImplementation(StorageTTLStatusQuery.class, (Service)new BanyanDBTTLStatusQuery(this.config));
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        MetricsCreator metricCreator = (MetricsCreator)this.getManager().find("telemetry").provider().getService(MetricsCreator.class);
        HealthCheckMetrics healthChecker = metricCreator.createHealthCheckerGauge("storage_banyandb", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        this.client.registerChecker((HealthChecker)healthChecker);
        try {
            this.client.connect();
            this.modelInstaller.start();
            ((ModelCreator)this.getManager().find("core").provider().getService(ModelCreator.class)).addModelListener((ModelCreator.CreatingListener)this.modelInstaller);
        }
        catch (Exception e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException, ModuleStartException {
        if (!RunningMode.isNoInitMode()) {
            try {
                List groups = this.client.client.findGroups();
                this.cleanupUnusedTopNRules(groups);
            }
            catch (BanyanDBException e) {
                throw new ModuleStartException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public String[] requiredModules() {
        return new String[]{"core"};
    }

    private void cleanupUnusedTopNRules(List<BanyandbCommon.Group> groups) throws BanyanDBException {
        HashSet topNNames = new HashSet();
        this.config.getTopNConfigs().values().forEach(topNConfig -> topNNames.addAll(topNConfig.keySet()));
        for (BanyandbCommon.Group group : groups) {
            String groupName;
            List topNAggregations;
            if (!BanyandbCommon.Catalog.CATALOG_MEASURE.equals((Object)group.getCatalog()) || !CollectionUtils.isNotEmpty((List)(topNAggregations = this.client.client.findTopNAggregations(groupName = group.getMetadata().getName())))) continue;
            for (BanyandbDatabase.TopNAggregation topNAggregation : topNAggregations) {
                String topNName = topNAggregation.getMetadata().getName();
                if (topNNames.contains(topNName)) continue;
                if (this.config.getGlobal().isCleanupUnusedTopNRules()) {
                    this.client.client.deleteTopNAggregation(groupName, topNName);
                    log.info("Deleted unused topN rule from BanyanDB server: {}, group: {}. Please check bydb-topn.yml. If you don't want to cleanup unused rules from server, please set cleanupUnusedTopNRules=false in bydb.yml", (Object)topNName, (Object)groupName);
                    continue;
                }
                log.warn("Unused topN rule in BanyanDB server: {}, group: {}. Please check bydb-topn.yml. If you want to cleanup unused rules from server, please set cleanupUnusedTopNRules=true in bydb.yml", (Object)topNName, (Object)groupName);
            }
        }
    }
}

