/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.skywalking.banyandb.database.v1.BanyandbDatabase;
import org.apache.skywalking.banyandb.model.v1.BanyandbModel;
import org.apache.skywalking.banyandb.v1.client.AbstractQuery;
import org.apache.skywalking.banyandb.v1.client.DataPoint;
import org.apache.skywalking.banyandb.v1.client.MeasureQuery;
import org.apache.skywalking.banyandb.v1.client.MeasureQueryResponse;
import org.apache.skywalking.banyandb.v1.client.TagAndValue;
import org.apache.skywalking.banyandb.v1.client.TimestampRange;
import org.apache.skywalking.banyandb.v1.client.TopNQueryResponse;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.enumeration.Scope;
import org.apache.skywalking.oap.server.core.query.input.AttrCondition;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.TopNCondition;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.query.type.SelectedRecord;
import org.apache.skywalking.oap.server.core.storage.query.IAggregationQueryDAO;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.MetadataRegistry;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.util.ByteUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BanyanDBAggregationQueryDAO
extends AbstractBanyanDBDAO
implements IAggregationQueryDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BanyanDBAggregationQueryDAO.class);
    private static final Set<String> TAGS = ImmutableSet.of((Object)"entity_id");

    public BanyanDBAggregationQueryDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public List<SelectedRecord> sortMetrics(TopNCondition condition, String valueColumnName, Duration duration, List<KeyValue> additionalConditions) throws IOException {
        BanyandbDatabase.TopNAggregation topNAggregation;
        boolean isColdStage = duration != null && duration.isColdStage();
        String modelName = condition.getName();
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetricMetadata(modelName, duration.getStep());
        if (schema == null) {
            throw new IOException("schema is not registered");
        }
        MetadataRegistry.ColumnSpec spec = schema.getSpec(valueColumnName);
        if (spec == null) {
            throw new IOException("field spec is not registered");
        }
        ImmutableSet.Builder queryTags = ImmutableSet.builder();
        if (condition.getAttributes() != null) {
            for (AttrCondition attr : condition.getAttributes()) {
                if (!attr.isEquals()) {
                    queryTags.add((Object)attr.toString());
                    continue;
                }
                queryTags.add((Object)attr.getKey());
            }
        }
        if (additionalConditions != null) {
            additionalConditions.forEach(additionalCondition -> queryTags.add((Object)additionalCondition.getKey()));
        }
        if (schema.getTopNSpecs() != null && (topNAggregation = schema.getTopNSpecs().get(queryTags.build())) != null) {
            BanyandbModel.Sort sort = topNAggregation.getFieldValueSort();
            switch (condition.getOrder()) {
                case DES: {
                    if (sort != BanyandbModel.Sort.SORT_DESC && sort != BanyandbModel.Sort.SORT_UNSPECIFIED) break;
                    return this.serverSideTopN(isColdStage, condition, schema, spec, this.getTimestampRange(duration), additionalConditions, topNAggregation.getMetadata().getName(), AbstractQuery.Sort.DESC);
                }
                case ASC: {
                    if (sort != BanyandbModel.Sort.SORT_ASC && sort != BanyandbModel.Sort.SORT_UNSPECIFIED) break;
                    return this.serverSideTopN(isColdStage, condition, schema, spec, this.getTimestampRange(duration), additionalConditions, topNAggregation.getMetadata().getName(), AbstractQuery.Sort.ASC);
                }
                default: {
                    throw new IOException("Unsupported order: " + String.valueOf(condition.getOrder()));
                }
            }
        }
        return this.directMetricsTopN(isColdStage, condition, schema, valueColumnName, spec, this.getTimestampRange(duration), additionalConditions);
    }

    List<SelectedRecord> serverSideTopN(boolean isColdStage, TopNCondition condition, MetadataRegistry.Schema schema, MetadataRegistry.ColumnSpec valueColumnSpec, TimestampRange timestampRange, List<KeyValue> additionalConditions, String topNRuleName, AbstractQuery.Sort sort) throws IOException {
        TopNQueryResponse resp = this.topNQueryDebuggable(isColdStage, schema, timestampRange, condition.getTopN(), sort, additionalConditions, condition.getAttributes(), topNRuleName);
        if (resp.size() == 0) {
            return Collections.emptyList();
        }
        if (resp.size() > 1) {
            throw new IOException("invalid TopN response");
        }
        ArrayList<SelectedRecord> topNList = new ArrayList<SelectedRecord>();
        for (TopNQueryResponse.Item item : ((TopNQueryResponse.TopNList)resp.getTopNLists().get(0)).getItems()) {
            SelectedRecord record = new SelectedRecord();
            record.setId((String)((TagAndValue)item.getTagValuesMap().get("entity_id")).getValue());
            record.setValue(BanyanDBAggregationQueryDAO.extractFieldValueAsString(valueColumnSpec, item.getValue()));
            topNList.add(record);
        }
        return topNList;
    }

    List<SelectedRecord> directMetricsTopN(boolean isColdStage, final TopNCondition condition, MetadataRegistry.Schema schema, final String valueColumnName, MetadataRegistry.ColumnSpec valueColumnSpec, TimestampRange timestampRange, final List<KeyValue> additionalConditions) throws IOException {
        MeasureQueryResponse resp;
        if (log.isDebugEnabled() && condition.getScope().equals((Object)Scope.Endpoint)) {
            log.debug("Endpoint direct TopN query, TopNCondition: {}, AdditionalConditions: {}, TimestampRange: {}", new Object[]{condition, additionalConditions, timestampRange});
        }
        if ((resp = this.queryDebuggable(isColdStage, schema, TAGS, Collections.singleton(valueColumnName), timestampRange, new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.meanBy(valueColumnName, (Set)ImmutableSet.of((Object)"entity_id"));
                if (condition.getOrder() == Order.DES) {
                    query.topN(condition.getTopN(), valueColumnName);
                } else {
                    query.bottomN(condition.getTopN(), valueColumnName);
                }
                if (CollectionUtils.isNotEmpty((List)additionalConditions)) {
                    additionalConditions.forEach(additionalCondition -> query.and(this.eq(additionalCondition.getKey(), additionalCondition.getValue())));
                }
                if (CollectionUtils.isNotEmpty((List)condition.getAttributes())) {
                    condition.getAttributes().forEach(attr -> {
                        if (attr.isEquals()) {
                            query.and(this.eq(attr.getKey(), attr.getValue()));
                        } else {
                            query.and(this.ne(attr.getKey(), attr.getValue()));
                        }
                    });
                }
            }
        })).size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<SelectedRecord> topNList = new ArrayList<SelectedRecord>();
        for (DataPoint dataPoint : resp.getDataPoints()) {
            SelectedRecord record = new SelectedRecord();
            record.setId((String)dataPoint.getTagValue("entity_id"));
            record.setValue(BanyanDBAggregationQueryDAO.extractFieldValueAsString(valueColumnSpec, dataPoint.getFieldValue(valueColumnName)));
            topNList.add(record);
        }
        return topNList;
    }

    private static String extractFieldValueAsString(MetadataRegistry.ColumnSpec spec, Object fieldValue) {
        if (Double.TYPE.equals(spec.getColumnClass())) {
            return String.valueOf(ByteUtil.bytes2Double((byte[])fieldValue).longValue());
        }
        if (String.class.equals(spec.getColumnClass())) {
            return (String)fieldValue;
        }
        return String.valueOf(((Number)fieldValue).longValue());
    }
}

