/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.profiling.asyncprofiler.storage.JFRProfilingDataRecord;
import org.apache.skywalking.oap.server.core.storage.profiling.asyncprofiler.IJFRDataQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.JDBCEntityConverters;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;

public class JDBCJFRDataQueryDAO
implements IJFRDataQueryDAO {
    private final JDBCClient jdbcClient;
    private final TableHelper tableHelper;

    public List<JFRProfilingDataRecord> getByTaskIdAndInstancesAndEvent(String taskId, List<String> instanceIds, String eventType) throws IOException {
        if (StringUtil.isBlank((String)taskId) || StringUtil.isBlank((String)eventType)) {
            return new ArrayList<JFRProfilingDataRecord>();
        }
        List<String> tables = this.tableHelper.getTablesWithinTTL("jfr_profiling_data");
        ArrayList<JFRProfilingDataRecord> results = new ArrayList<JFRProfilingDataRecord>();
        for (String table : tables) {
            ArrayList<String> condition = new ArrayList<String>(4);
            StringBuilder sql = new StringBuilder().append("select * from ").append(table).append(" where ").append("table_name").append(" = ?");
            condition.add("jfr_profiling_data");
            sql.append(" and ").append("event_type").append(" =? ");
            condition.add(eventType);
            if (CollectionUtils.isNotEmpty(instanceIds)) {
                sql.append(" and ").append("instance_id").append(" in (?) ");
                String joinedInstanceIds = String.join((CharSequence)",", instanceIds);
                condition.add(joinedInstanceIds);
            }
            results.addAll((Collection)this.jdbcClient.executeQuery(sql.toString(), resultSet -> {
                ArrayList<JFRProfilingDataRecord> result = new ArrayList<JFRProfilingDataRecord>();
                while (resultSet.next()) {
                    result.add(this.parseData(resultSet));
                }
                return result;
            }, condition.toArray(new Object[0])));
        }
        return results;
    }

    private JFRProfilingDataRecord parseData(ResultSet data) {
        JFRProfilingDataRecord.Builder builder = new JFRProfilingDataRecord.Builder();
        JFRProfilingDataRecord jfrProfilingDataRecord = builder.storage2Entity(JDBCEntityConverters.toEntity(data));
        byte[] dataBinary = jfrProfilingDataRecord.getDataBinary();
        if (dataBinary != null) {
            byte[] decodeResult = Base64.getDecoder().decode(dataBinary);
            jfrProfilingDataRecord.setDataBinary(decodeResult);
        }
        return jfrProfilingDataRecord;
    }

    @Generated
    public JDBCJFRDataQueryDAO(JDBCClient jdbcClient, TableHelper tableHelper) {
        this.jdbcClient = jdbcClient;
        this.tableHelper = tableHelper;
    }
}

