/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.watermark;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.watermark.WatermarkEvent;
import org.apache.skywalking.oap.server.core.watermark.WatermarkGRPCInterceptor;
import org.apache.skywalking.oap.server.core.watermark.WatermarkListener;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.TerminalFriendlyTable;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCollector;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatermarkWatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WatermarkWatcher.class);
    private final ModuleManager moduleManager;
    private final long maxHeapMemoryUsagePercentThreshold;
    private final long maxDirectHeapMemoryUsageThreshold;
    private MetricsCollector so11yCollector;
    private long directMemoryUsed = 0L;
    private long heapMemoryMax = 0L;
    private long heapMemoryUsed = 0L;
    private ReentrantLock lock;
    private List<WatermarkListener> listeners;
    private volatile boolean isLimiting = false;
    private Map<WatermarkEvent.Type, Map<String, CounterMetrics>> breakCounters;
    private Map<String, CounterMetrics> recoverCounters;
    private MetricsCreator metricsCreator;

    public void start(MetricsCollector so11yCollector) {
        this.so11yCollector = so11yCollector;
        this.lock = new ReentrantLock();
        this.listeners = new ArrayList<WatermarkListener>();
        this.breakCounters = new HashMap<WatermarkEvent.Type, Map<String, CounterMetrics>>();
        this.recoverCounters = new HashMap<String, CounterMetrics>();
        for (WatermarkEvent.Type type : WatermarkEvent.Type.values()) {
            this.breakCounters.put(type, new HashMap());
        }
        this.metricsCreator = (MetricsCreator)this.moduleManager.find("telemetry").provider().getService(MetricsCreator.class);
        this.addListener(WatermarkGRPCInterceptor.INSTANCE);
        Executors.newSingleThreadScheduledExecutor().scheduleWithFixedDelay(this::watch, 0L, 10L, TimeUnit.SECONDS);
    }

    private void watch() {
        this.heapMemoryUsed = this.so11yCollector.heapMemoryUsage();
        this.heapMemoryMax = this.so11yCollector.heapMemoryMax();
        this.directMemoryUsed = this.so11yCollector.directMemoryUsage();
        if (log.isDebugEnabled()) {
            TerminalFriendlyTable table = new TerminalFriendlyTable("Watermark Controller Key Metrics");
            table.addRow(new TerminalFriendlyTable.Row("Heap Memory Max", String.format("%,d", this.heapMemoryMax)));
            table.addRow(new TerminalFriendlyTable.Row("Heap Memory Used", String.format("%,d", this.heapMemoryUsed)));
            table.addRow(new TerminalFriendlyTable.Row("Heap Memory Usage Percentage", this.heapMemoryUsagePercent() + "%"));
            table.addRow(new TerminalFriendlyTable.Row("Direct Memory Used", String.format("%,d", this.directMemoryUsed)));
            log.debug(table.toString());
        }
        boolean isLimitingTriggered = false;
        if (this.heapMemoryUsagePercent() > this.maxHeapMemoryUsagePercentThreshold) {
            this.notify(WatermarkEvent.Type.HEAP_MEMORY_USAGE_PERCENTAGE);
            isLimitingTriggered = true;
        }
        if (this.maxDirectHeapMemoryUsageThreshold > 0L && this.directMemoryUsed > 0L && this.directMemoryUsed > this.maxDirectHeapMemoryUsageThreshold) {
            this.notify(WatermarkEvent.Type.DIRECT_HEAP_MEMORY_USAGE);
            isLimitingTriggered = true;
        }
        if (!isLimitingTriggered && this.isLimiting) {
            this.recovered();
        }
    }

    private void notify(WatermarkEvent.Type event) {
        if (this.isLimiting) {
            return;
        }
        TerminalFriendlyTable table = new TerminalFriendlyTable("Watermark Controller Key Metrics");
        table.addRow(new TerminalFriendlyTable.Row("Heap Memory Max", String.format("%,d", this.heapMemoryMax)));
        table.addRow(new TerminalFriendlyTable.Row("Heap Memory Used", String.format("%,d", this.heapMemoryUsed)));
        table.addRow(new TerminalFriendlyTable.Row("Heap Memory Usage Percentage", this.heapMemoryUsagePercent() + "%"));
        table.addRow(new TerminalFriendlyTable.Row("Direct Memory Used", String.format("%,d", this.directMemoryUsed)));
        table.addRow(new TerminalFriendlyTable.Row("Event", event.name()));
        this.isLimiting = true;
        this.lock.lock();
        try {
            this.listeners.forEach(listener -> {
                listener.notify(event);
                table.addRow(new TerminalFriendlyTable.Row("Notified Listener", listener.getName()));
                this.breakCounters.get((Object)event).get(listener.getName()).inc();
            });
        }
        finally {
            this.lock.unlock();
        }
        log.warn(table.toString());
    }

    private void recovered() {
        TerminalFriendlyTable table = new TerminalFriendlyTable("Watermark Controller Key Metrics");
        table.addRow(new TerminalFriendlyTable.Row("Heap Memory Max", String.format("%,d", this.heapMemoryMax)));
        table.addRow(new TerminalFriendlyTable.Row("Heap Memory Used", String.format("%,d", this.heapMemoryUsed)));
        table.addRow(new TerminalFriendlyTable.Row("Heap Memory Usage Percentage", this.heapMemoryUsagePercent() + "%"));
        table.addRow(new TerminalFriendlyTable.Row("Direct Memory Used", String.format("%,d", this.directMemoryUsed)));
        table.addRow(new TerminalFriendlyTable.Row("Event", "RECOVERED"));
        this.isLimiting = false;
        this.lock.lock();
        try {
            this.listeners.forEach(listener -> {
                listener.beAwareOfRecovery();
                table.addRow(new TerminalFriendlyTable.Row("Notified Listener", listener.getName()));
                this.recoverCounters.get(listener.getName()).inc();
            });
        }
        finally {
            this.lock.unlock();
        }
        log.info(table.toString());
    }

    private long heapMemoryUsagePercent() {
        if (this.heapMemoryMax > 0L) {
            return this.heapMemoryUsed * 100L / this.heapMemoryMax;
        }
        return -1L;
    }

    private MetricsCreator getMetricsCreator() {
        if (this.metricsCreator == null) {
            this.metricsCreator = (MetricsCreator)this.moduleManager.find("telemetry").provider().getService(MetricsCreator.class);
        }
        return this.metricsCreator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(WatermarkListener listener) {
        this.lock.lock();
        try {
            this.listeners.add(listener);
            MetricsCreator metricsCreator = this.getMetricsCreator();
            for (WatermarkEvent.Type type : WatermarkEvent.Type.values()) {
                this.breakCounters.get((Object)type).put(listener.getName(), metricsCreator.createCounter("watermark_circuit_breaker_break_count", "The number of times the watermark circuit breaker breaks", new MetricsTag.Keys(new String[]{"listener", "event"}), new MetricsTag.Values(new String[]{listener.getName(), type.name()})));
            }
            this.recoverCounters.put(listener.getName(), metricsCreator.createCounter("watermark_circuit_breaker_recover_count", "The number of times the watermark circuit breaker recovers", new MetricsTag.Keys(new String[]{"listener"}), new MetricsTag.Values(new String[]{listener.getName()})));
        }
        finally {
            this.lock.unlock();
        }
    }

    @Generated
    public WatermarkWatcher(ModuleManager moduleManager, long maxHeapMemoryUsagePercentThreshold, long maxDirectHeapMemoryUsageThreshold) {
        this.moduleManager = moduleManager;
        this.maxHeapMemoryUsagePercentThreshold = maxHeapMemoryUsagePercentThreshold;
        this.maxDirectHeapMemoryUsageThreshold = maxDirectHeapMemoryUsageThreshold;
    }
}

