/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.trace.analyze;

import com.google.common.primitives.Ints;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.apm.network.language.profile.v3.ThreadStack;
import org.apache.skywalking.oap.server.core.profiling.trace.ProfileThreadSnapshotRecord;

public class ProfileStack
implements Comparable<ProfileStack> {
    private int sequence;
    private long dumpTime;
    private List<String> stack;

    public static ProfileStack deserialize(ProfileThreadSnapshotRecord record) {
        ThreadStack threadStack = null;
        try {
            threadStack = ThreadStack.parseFrom((byte[])record.getStackBinary());
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("wrong stack data");
        }
        ProfileStack stack = new ProfileStack();
        stack.sequence = record.getSequence();
        stack.dumpTime = record.getDumpTime();
        stack.stack = threadStack.getCodeSignaturesList();
        return stack;
    }

    @Override
    public int compareTo(ProfileStack o) {
        return Ints.compare((int)this.sequence, (int)o.sequence);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfileStack that = (ProfileStack)o;
        return this.sequence == that.sequence;
    }

    public int hashCode() {
        return Objects.hash(this.sequence);
    }

    @Generated
    public ProfileStack() {
    }

    @Generated
    public int getSequence() {
        return this.sequence;
    }

    @Generated
    public long getDumpTime() {
        return this.dumpTime;
    }

    @Generated
    public List<String> getStack() {
        return this.stack;
    }

    @Generated
    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    @Generated
    public void setDumpTime(long dumpTime) {
        this.dumpTime = dumpTime;
    }

    @Generated
    public void setStack(List<String> stack) {
        this.stack = stack;
    }

    @Generated
    public String toString() {
        return "ProfileStack(sequence=" + this.getSequence() + ", dumpTime=" + this.getDumpTime() + ", stack=" + String.valueOf(this.getStack()) + ")";
    }
}

