/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.pprof;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.worker.NoneStreamProcessor;
import org.apache.skywalking.oap.server.core.profiling.pprof.storage.PprofTaskRecord;
import org.apache.skywalking.oap.server.core.query.type.PprofEventType;
import org.apache.skywalking.oap.server.core.query.type.PprofTask;
import org.apache.skywalking.oap.server.core.query.type.PprofTaskCreationResult;
import org.apache.skywalking.oap.server.core.query.type.PprofTaskCreationType;
import org.apache.skywalking.oap.server.core.storage.profiling.pprof.IPprofTaskQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PprofMutationService
implements Service {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PprofMutationService.class);
    private final ModuleManager moduleManager;
    private IPprofTaskQueryDAO taskQueryDAO;

    private IPprofTaskQueryDAO getPprofTaskDAO() {
        if (this.taskQueryDAO == null) {
            this.taskQueryDAO = (IPprofTaskQueryDAO)this.moduleManager.find("storage").provider().getService(IPprofTaskQueryDAO.class);
        }
        return this.taskQueryDAO;
    }

    public PprofTaskCreationResult createTask(String serviceId, List<String> serviceInstanceIds, int duration, PprofEventType events, int dumpPeriod) throws IOException {
        long createTime = System.currentTimeMillis();
        PprofTaskCreationResult checkResult = this.checkDataSuccess(serviceId, serviceInstanceIds, duration, createTime, events, dumpPeriod);
        if (checkResult != null) {
            return checkResult;
        }
        PprofTaskRecord task = new PprofTaskRecord();
        String taskId = createTime + "_" + serviceId;
        task.setTaskId(taskId);
        task.setServiceId(serviceId);
        task.setServiceInstanceIdsFromList(serviceInstanceIds);
        task.setDuration(duration);
        task.setEvents(events.toString());
        task.setDumpPeriod(dumpPeriod);
        task.setCreateTime(createTime);
        task.setTimeBucket(TimeBucket.getRecordTimeBucket(createTime));
        NoneStreamProcessor.getInstance().in(task);
        return PprofTaskCreationResult.builder().id(task.id().build()).code(PprofTaskCreationType.SUCCESS).build();
    }

    private PprofTaskCreationResult checkDataSuccess(String serviceId, List<String> serviceInstanceIds, int duration, long createTime, PprofEventType events, int dumpPeriod) throws IOException {
        String checkArgumentMessage = this.checkArgumentError(serviceId, serviceInstanceIds, duration, events, dumpPeriod);
        if (checkArgumentMessage != null) {
            return PprofTaskCreationResult.builder().code(PprofTaskCreationType.ARGUMENT_ERROR).errorReason(checkArgumentMessage).build();
        }
        String checkTaskProfilingMessage = this.checkTaskProfiling(serviceId, events, createTime);
        if (checkTaskProfilingMessage != null) {
            return PprofTaskCreationResult.builder().code(PprofTaskCreationType.ALREADY_PROFILING_ERROR).errorReason(checkTaskProfilingMessage).build();
        }
        return null;
    }

    private String checkArgumentError(String serviceId, List<String> serviceInstanceIds, int duration, PprofEventType events, int dumpPeriod) {
        if (serviceId == null) {
            return "service cannot be null";
        }
        if (events == null) {
            return "events cannot be empty";
        }
        if (events == PprofEventType.CPU || events == PprofEventType.BLOCK || events == PprofEventType.MUTEX) {
            if (duration <= 0) {
                return "duration cannot be negative";
            }
            if (duration > 15) {
                return "duration cannot be greater than 15 minutes";
            }
        }
        if ((events == PprofEventType.BLOCK || events == PprofEventType.MUTEX) && dumpPeriod <= 0) {
            return "dumpPeriod cannot be negative";
        }
        if (CollectionUtils.isEmpty(serviceInstanceIds)) {
            return "serviceInstanceIds cannot be empty";
        }
        return null;
    }

    private String checkTaskProfiling(String serviceId, PprofEventType events, long createTime) throws IOException {
        long endTimeBucket = TimeBucket.getRecordTimeBucket(createTime);
        List<PprofTask> alreadyHaveTaskList = this.getPprofTaskDAO().getTaskList(serviceId, null, endTimeBucket, null);
        if (CollectionUtils.isNotEmpty(alreadyHaveTaskList)) {
            for (PprofTask task : alreadyHaveTaskList) {
                if (!task.getEvents().equals((Object)events) || task.getCreateTime() + TimeUnit.MINUTES.toMillis(task.getDuration()) < createTime) continue;
                return "current service already has monitor pprof task execute at this time";
            }
        }
        return null;
    }

    @Generated
    public PprofMutationService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }
}

