/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.config;

import java.io.FileNotFoundException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.config.IComponentLibraryCatalogService;
import org.apache.skywalking.oap.server.core.config.InitialComponentCatalogException;
import org.apache.skywalking.oap.server.library.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class ComponentLibraryCatalogService
implements IComponentLibraryCatalogService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComponentLibraryCatalogService.class);
    private static final String COMPONENT_SERVER_MAPPING_SECTION = "Component-Server-Mappings";
    private Map<String, Integer> componentName2Id;
    private Map<Integer, String> componentId2Name;
    private Map<Integer, Integer> componentId2ServerId;
    private Map<Integer, Integer> componentIDPriorities;

    public ComponentLibraryCatalogService() throws InitialComponentCatalogException {
        this.init();
    }

    @Override
    public int getComponentId(String componentName) {
        return this.componentName2Id.get(componentName);
    }

    @Override
    public int getServerIdBasedOnComponent(int componentId) {
        Integer serverComponentId = this.componentId2ServerId.get(componentId);
        return serverComponentId == null ? componentId : serverComponentId;
    }

    @Override
    public String getComponentName(int componentId) {
        String componentName = this.componentId2Name.get(componentId);
        return componentName == null ? this.componentId2Name.get(0) : componentName;
    }

    @Override
    public String getServerNameBasedOnComponent(int componentId) {
        Integer serverComponentId = this.componentId2ServerId.get(componentId);
        return serverComponentId == null ? this.getComponentName(componentId) : this.getComponentName(serverComponentId);
    }

    private void init() throws InitialComponentCatalogException {
        this.componentName2Id = new HashMap<String, Integer>();
        this.componentName2Id.put("N/A", 0);
        this.componentId2Name = new HashMap<Integer, String>();
        this.componentId2Name.put(0, "N/A");
        this.componentId2ServerId = new HashMap<Integer, Integer>();
        this.componentIDPriorities = new HashMap<Integer, Integer>();
        HashMap<String, String> nameMapping = new HashMap<String, String>();
        try {
            Reader applicationReader = ResourceUtils.read((String)"component-libraries.yml");
            Yaml yaml = new Yaml();
            Map map = (Map)yaml.loadAs(applicationReader, Map.class);
            map.forEach((componentName, settingCollection) -> {
                Map settings = (Map)settingCollection;
                if (COMPONENT_SERVER_MAPPING_SECTION.equals(componentName)) {
                    settings.forEach((name, serverName) -> nameMapping.put((String)name, (String)serverName));
                } else {
                    Integer componentId = (Integer)settings.get("id");
                    this.componentName2Id.put((String)componentName, componentId);
                    this.componentId2Name.put(componentId, (String)componentName);
                    Integer priority = (Integer)settings.get("priority");
                    if (priority == null) {
                        priority = 50;
                    }
                    this.componentIDPriorities.put(componentId, priority);
                }
            });
            nameMapping.forEach((name, serverName) -> {
                if (!this.componentName2Id.containsKey(name)) {
                    throw new InitialComponentCatalogException("Component name [" + name + "] in Component-Server-Mappings doesn't exist in component define. ");
                }
                if (!this.componentName2Id.containsKey(serverName)) {
                    throw new InitialComponentCatalogException("Server componentId name [" + serverName + "] in Component-Server-Mappings doesn't exist in component define. ");
                }
                this.componentId2ServerId.put(this.componentName2Id.get(name), this.componentName2Id.get(serverName));
            });
            nameMapping.clear();
        }
        catch (FileNotFoundException e) {
            log.error("component-libraries.yml not found.", (Throwable)e);
        }
    }

    @Override
    public boolean compare(int componentA, int componentB) {
        Integer priorityB;
        Integer priorityA = this.componentIDPriorities.getOrDefault(componentA, 50);
        return priorityA.compareTo(priorityB = this.componentIDPriorities.getOrDefault(componentB, 50)) < 0;
    }
}

