/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.worker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.data.LimitedSizeBufferedData;
import org.apache.skywalking.oap.server.core.analysis.data.ReadWriteSafeCache;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.analysis.topn.TopN;
import org.apache.skywalking.oap.server.core.analysis.worker.PersistenceWorker;
import org.apache.skywalking.oap.server.core.storage.IRecordDAO;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.library.client.request.PrepareRequest;
import org.apache.skywalking.oap.server.library.datacarrier.DataCarrier;
import org.apache.skywalking.oap.server.library.datacarrier.consumer.IConsumer;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopNWorker
extends PersistenceWorker<TopN> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TopNWorker.class);
    private final IRecordDAO recordDAO;
    private final Model model;
    private final DataCarrier<TopN> dataCarrier;
    private long reportPeriod;
    private volatile long lastReportTimestamp;

    TopNWorker(ModuleDefineHolder moduleDefineHolder, Model model, int topNSize, long reportPeriod, IRecordDAO recordDAO) {
        super(moduleDefineHolder, new ReadWriteSafeCache(new LimitedSizeBufferedData(topNSize), new LimitedSizeBufferedData(topNSize)));
        this.recordDAO = recordDAO;
        this.model = model;
        this.dataCarrier = new DataCarrier("TopNWorker", 1, 1000);
        this.dataCarrier.consume((IConsumer)new TopNConsumer(), 1);
        this.lastReportTimestamp = System.currentTimeMillis();
        this.reportPeriod = reportPeriod;
    }

    @Override
    public List<PrepareRequest> buildBatchRequests() {
        long now = System.currentTimeMillis();
        if (now - this.lastReportTimestamp <= this.reportPeriod) {
            return Collections.EMPTY_LIST;
        }
        this.lastReportTimestamp = now;
        List lastCollection = this.getCache().read();
        ArrayList<PrepareRequest> prepareRequests = new ArrayList<PrepareRequest>(lastCollection.size());
        lastCollection.forEach(record -> {
            try {
                prepareRequests.add((PrepareRequest)this.recordDAO.prepareBatchInsert(this.model, (Record)record));
            }
            catch (Throwable t) {
                log.error(t.getMessage(), t);
            }
        });
        return prepareRequests;
    }

    @Override
    public void endOfRound() {
    }

    @Override
    public void in(TopN n) {
        this.dataCarrier.produce((Object)n);
    }

    private class TopNConsumer
    implements IConsumer<TopN> {
        private TopNConsumer() {
        }

        public void consume(List<TopN> data) {
            TopNWorker.this.onWork(data);
        }

        public void onError(List<TopN> data, Throwable t) {
            log.error(t.getMessage(), t);
        }
    }
}

