/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.meter.function;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataLabel;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.query.type.HeatMap;

public class BucketedValues {
    private DataLabel labels = new DataLabel();
    private long[] buckets;
    private long[] values;

    public BucketedValues(long[] buckets, long[] values) {
        if (buckets == null || values == null || buckets.length == 0 || values.length == 0) {
            throw new IllegalArgumentException("buckets and values can't be null.");
        }
        if (buckets.length != values.length) {
            throw new IllegalArgumentException("The length of buckets and values should be same.");
        }
        this.buckets = buckets;
        this.values = values;
    }

    public boolean isCompatible(DataTable dataset) {
        List<String> sortedKeys = dataset.sortedKeys(new HeatMap.KeyComparator(true));
        long[] existedBuckets = new long[sortedKeys.size()];
        for (int i = 0; i < sortedKeys.size(); ++i) {
            String key = sortedKeys.get(i);
            if (key.equals("infinite-")) {
                existedBuckets[i] = Long.MIN_VALUE;
                continue;
            }
            if (key.contains(":")) {
                key = StringUtils.substringAfterLast((String)key, (String)":");
            }
            existedBuckets[i] = Long.parseLong(key);
        }
        return Arrays.equals(this.buckets, existedBuckets);
    }

    @Generated
    public String toString() {
        return "BucketedValues(labels=" + String.valueOf(this.getLabels()) + ", buckets=" + Arrays.toString(this.getBuckets()) + ", values=" + Arrays.toString(this.getValues()) + ")";
    }

    @Generated
    public DataLabel getLabels() {
        return this.labels;
    }

    @Generated
    public long[] getBuckets() {
        return this.buckets;
    }

    @Generated
    public long[] getValues() {
        return this.values;
    }

    @Generated
    public void setLabels(DataLabel labels) {
        this.labels = labels;
    }
}

