/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.RangeQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.response.Document;
import org.apache.skywalking.library.elasticsearch.response.Documents;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHits;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.MetricsCondition;
import org.apache.skywalking.oap.server.core.query.type.HeatMap;
import org.apache.skywalking.oap.server.core.query.type.IntValues;
import org.apache.skywalking.oap.server.core.query.type.KVInt;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.query.type.MetricsValues;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.core.storage.query.IMetricsQueryDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.TimeRangeIndexNameGenerator;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.TimeSeriesUtils;

public class MetricsQueryEsDAO
extends EsDAO
implements IMetricsQueryDAO {
    public MetricsQueryEsDAO(ElasticSearchClient client) {
        super(client);
    }

    public MetricsValues readMetricsValues(MetricsCondition condition, String valueColumnName, Duration duration) {
        String realValueColumn = IndexController.LogicIndicesRegister.getPhysicalColumnName(condition.getName(), valueColumnName);
        String tableName = IndexController.LogicIndicesRegister.getPhysicalTableName(condition.getName());
        List pointOfTimes = duration.assembleDurationPoints();
        HashMap<String, List<String>> indexIdsGroup = new HashMap<String, List<String>>();
        List ids = pointOfTimes.stream().map(pointOfTime -> {
            String id = pointOfTime.id(condition.getEntity().buildId());
            if (IndexController.LogicIndicesRegister.isMergedTable(condition.getName())) {
                id = IndexController.INSTANCE.generateDocId(condition.getName(), id);
            }
            String indexName = TimeSeriesUtils.queryIndexName(tableName, pointOfTime.getPoint(), duration.getStep(), false, false);
            indexIdsGroup.computeIfAbsent(indexName, v -> new ArrayList()).add(id);
            return id;
        }).collect(Collectors.toList());
        MetricsValues metricsValues = new MetricsValues();
        Optional<Documents> response = this.idsDebuggable(indexIdsGroup);
        if (response.isPresent()) {
            Map<String, Map<String, Object>> idMap = this.toMap(response.get());
            IntValues intValues = metricsValues.getValues();
            for (String id : ids) {
                KVInt kvInt = new KVInt();
                kvInt.setId(id);
                if (!idMap.containsKey(id)) continue;
                Map<String, Object> source = idMap.get(id);
                if (source.get(realValueColumn) != null) {
                    kvInt.setValue(((Number)source.get(realValueColumn)).longValue());
                } else {
                    kvInt.setValue((long)ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName()));
                    kvInt.setEmptyValue(true);
                }
                intValues.addKVInt(kvInt);
            }
        }
        metricsValues.setValues(IMetricsQueryDAO.Util.sortValues((IntValues)metricsValues.getValues(), ids, (int)ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName())));
        return metricsValues;
    }

    public List<MetricsValues> readLabeledMetricsValues(MetricsCondition condition, String valueColumnName, List<KeyValue> labels, Duration duration) {
        String realValueColumn = IndexController.LogicIndicesRegister.getPhysicalColumnName(condition.getName(), valueColumnName);
        List pointOfTimes = duration.assembleDurationPoints();
        String tableName = IndexController.LogicIndicesRegister.getPhysicalTableName(condition.getName());
        HashMap<String, List<String>> indexIdsGroup = new HashMap<String, List<String>>();
        boolean aggregationMode = !tableName.equals(condition.getName());
        ArrayList ids = new ArrayList(pointOfTimes.size());
        pointOfTimes.forEach(pointOfTime -> {
            String id = pointOfTime.id(condition.getEntity().buildId());
            if (aggregationMode) {
                id = IndexController.INSTANCE.generateDocId(condition.getName(), id);
            }
            ids.add(id);
            String indexName = TimeSeriesUtils.queryIndexName(tableName, pointOfTime.getPoint(), duration.getStep(), false, false);
            indexIdsGroup.computeIfAbsent(indexName, v -> new ArrayList()).add(id);
        });
        Optional<Documents> response = this.idsDebuggable(indexIdsGroup);
        HashMap<String, DataTable> idMap = new HashMap<String, DataTable>();
        if (response.isPresent()) {
            for (Document document : response.get()) {
                if (document.getSource().get(realValueColumn) == null) continue;
                idMap.put(document.getId(), new DataTable((String)document.getSource().get(realValueColumn)));
            }
        }
        return IMetricsQueryDAO.Util.sortValues((List)IMetricsQueryDAO.Util.composeLabelValue((String)condition.getName(), labels, ids, idMap), ids, (int)ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName()));
    }

    public List<MetricsValues> readLabeledMetricsValuesWithoutEntity(String metricName, String valueColumnName, List<KeyValue> labels, Duration duration) {
        SearchBuilder search = Search.builder().size(Integer.valueOf(10));
        BoolQueryBuilder query = Query.bool().must((QueryBuilder)Query.range((String)"time_bucket").lte((Object)duration.getEndTimeBucket()).gte((Object)duration.getStartTimeBucket()));
        if (IndexController.LogicIndicesRegister.isMergedTable(metricName)) {
            query.must((QueryBuilder)Query.term((String)"metric_table", (Object)metricName));
            search.query((QueryBuilder)query);
        }
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search((Supplier)new TimeRangeIndexNameGenerator(IndexController.LogicIndicesRegister.getPhysicalTableName(metricName), duration.getStartTimeBucketInSec(), duration.getEndTimeBucketInSec()), search.build());
        String realValueColumn = IndexController.LogicIndicesRegister.getPhysicalColumnName(metricName, valueColumnName);
        List pointOfTimes = duration.assembleDurationPoints();
        HashMap<String, DataTable> idMap = new HashMap<String, DataTable>();
        ArrayList<String> ids = new ArrayList<String>(pointOfTimes.size());
        for (SearchHit searchHit : response.getHits()) {
            if (searchHit.getSource().get(realValueColumn) == null) continue;
            idMap.put(searchHit.getId(), new DataTable((String)searchHit.getSource().get(realValueColumn)));
            ids.add(searchHit.getId());
        }
        return IMetricsQueryDAO.Util.sortValues((List)IMetricsQueryDAO.Util.composeLabelValue((String)metricName, labels, ids, idMap), ids, (int)ValueColumnMetadata.INSTANCE.getDefaultValue(metricName));
    }

    public HeatMap readHeatMap(MetricsCondition condition, String valueColumnName, Duration duration) {
        String realValueColumn = IndexController.LogicIndicesRegister.getPhysicalColumnName(condition.getName(), valueColumnName);
        List pointOfTimes = duration.assembleDurationPoints();
        String tableName = IndexController.LogicIndicesRegister.getPhysicalTableName(condition.getName());
        HashMap indexIdsGroup = new HashMap();
        boolean aggregationMode = !tableName.equals(condition.getName());
        ArrayList ids = new ArrayList(pointOfTimes.size());
        pointOfTimes.forEach(pointOfTime -> {
            String id = pointOfTime.id(condition.getEntity().buildId());
            if (aggregationMode) {
                id = IndexController.INSTANCE.generateDocId(condition.getName(), id);
            }
            ids.add(id);
            String indexName = TimeSeriesUtils.queryIndexName(tableName, pointOfTime.getPoint(), duration.getStep(), false, false);
            indexIdsGroup.computeIfAbsent(indexName, v -> new ArrayList()).add(id);
        });
        HeatMap heatMap = new HeatMap();
        Optional response = ((ElasticSearchClient)this.getClient()).ids(indexIdsGroup);
        if (!response.isPresent()) {
            return heatMap;
        }
        Map<String, Map<String, Object>> idMap = this.toMap((Documents)response.get());
        int defaultValue = ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName());
        for (String id : ids) {
            Map<String, Object> source = idMap.get(id);
            if (source == null) continue;
            String value = (String)source.get(realValueColumn);
            heatMap.buildColumn(id, value, defaultValue);
        }
        heatMap.fixMissingColumns(ids, defaultValue);
        return heatMap;
    }

    protected final SearchBuilder buildQuery(MetricsCondition condition, Duration duration) {
        SearchBuilder sourceBuilder = Search.builder();
        RangeQueryBuilder rangeQueryBuilder = Query.range((String)"time_bucket").gte((Object)duration.getStartTimeBucket()).lte((Object)duration.getEndTimeBucket());
        String entityId = condition.getEntity().buildId();
        if (entityId == null && IndexController.LogicIndicesRegister.isMergedTable(condition.getName())) {
            sourceBuilder.query((QueryBuilder)Query.bool().must((QueryBuilder)rangeQueryBuilder).must((QueryBuilder)Query.term((String)"metric_table", (Object)condition.getName())));
        } else if (entityId == null) {
            sourceBuilder.query((QueryBuilder)rangeQueryBuilder);
        } else if (IndexController.LogicIndicesRegister.isMergedTable(condition.getName())) {
            sourceBuilder.query((QueryBuilder)Query.bool().must((QueryBuilder)rangeQueryBuilder).must((QueryBuilder)Query.terms((String)"entity_id", (Object[])new Object[]{entityId})).must((QueryBuilder)Query.term((String)"metric_table", (Object)condition.getName())));
        } else {
            sourceBuilder.query((QueryBuilder)Query.bool().must((QueryBuilder)rangeQueryBuilder).must((QueryBuilder)Query.terms((String)"entity_id", (Object[])new Object[]{entityId})));
        }
        sourceBuilder.size(Integer.valueOf(0));
        return sourceBuilder;
    }

    private Map<String, Map<String, Object>> toMap(SearchHits hits) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        for (SearchHit hit : hits) {
            result.put(hit.getId(), hit.getSource());
        }
        return result;
    }

    private Map<String, Map<String, Object>> toMap(Documents documents) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        for (Document document : documents) {
            result.put(document.getId(), document.getSource());
        }
        return result;
    }
}

