/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.type;

import com.google.common.base.Splitter;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.query.graphql.type.InternalLog;
import org.apache.skywalking.oap.server.core.query.type.ContentType;
import org.apache.skywalking.oap.server.core.query.type.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogAdapter.class);
    private final InternalLog log;
    private final DateTimeFormatter rfc3339Formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZZZZZ").withResolverStyle(ResolverStyle.LENIENT);

    public Log adapt() {
        Log l = new Log();
        List timeAndContent = Splitter.on((String)" ").limit(2).trimResults().splitToList((CharSequence)this.log.line());
        if (timeAndContent.size() == 2) {
            String timeStr = ((String)timeAndContent.get(0)).replaceAll("\\.\\d+Z", "Z");
            try {
                TemporalAccessor t = this.rfc3339Formatter.parse(timeStr);
                long timestamp = Instant.from(t).getEpochSecond();
                l.setTimestamp(Long.valueOf(timestamp));
                l.setContent(String.format("[%s] %s", this.log.container(), timeAndContent.get(1)));
                l.setContentType(ContentType.TEXT);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to parse log entry, {}", (Object)this.log, (Object)e);
            }
        }
        return l;
    }

    @Generated
    public LogAdapter(InternalLog log) {
        this.log = log;
    }
}

