/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.zabbix.provider;

import com.google.common.base.Splitter;
import java.util.Collections;
import java.util.List;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterSystem;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.receiver.zabbix.module.ZabbixReceiverModule;
import org.apache.skywalking.oap.server.receiver.zabbix.provider.ZabbixMetrics;
import org.apache.skywalking.oap.server.receiver.zabbix.provider.ZabbixModuleConfig;
import org.apache.skywalking.oap.server.receiver.zabbix.provider.config.ZabbixConfig;
import org.apache.skywalking.oap.server.receiver.zabbix.provider.config.ZabbixConfigs;
import org.apache.skywalking.oap.server.receiver.zabbix.provider.protocol.ZabbixServer;

public class ZabbixReceiverProvider
extends ModuleProvider {
    private ZabbixModuleConfig moduleConfig = new ZabbixModuleConfig();
    private List<ZabbixConfig> configs;
    private ZabbixMetrics zabbixMetrics;

    public String name() {
        return "default";
    }

    public Class<? extends ModuleDefine> module() {
        return ZabbixReceiverModule.class;
    }

    public ModuleProvider.ConfigCreator newConfigCreator() {
        return new ModuleProvider.ConfigCreator<ZabbixModuleConfig>(){

            public Class type() {
                return ZabbixModuleConfig.class;
            }

            public void onInitialized(ZabbixModuleConfig initialized) {
                ZabbixReceiverProvider.this.moduleConfig = initialized;
            }
        };
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
        this.configs = ZabbixConfigs.loadConfigs("zabbix-rules", StringUtil.isEmpty((String)this.moduleConfig.getActiveFiles()) ? Collections.emptyList() : Splitter.on((String)",").splitToList((CharSequence)this.moduleConfig.getActiveFiles()));
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        if (CollectionUtils.isNotEmpty(this.configs)) {
            this.zabbixMetrics = new ZabbixMetrics(this.configs, (MeterSystem)this.getManager().find("core").provider().getService(MeterSystem.class));
            ZabbixServer zabbixServer = new ZabbixServer(this.moduleConfig, this.zabbixMetrics);
            try {
                zabbixServer.start();
            }
            catch (Exception e) {
                throw new ModuleStartException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException, ModuleStartException {
    }

    public String[] requiredModules() {
        return new String[]{"core"};
    }
}

