/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.log.analyzer.dsl.spec.sink.sampler;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.skywalking.oap.log.analyzer.dsl.spec.sink.sampler.Sampler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimitingSampler
implements Sampler {
    private volatile int rpm;
    private final AtomicInteger factor = new AtomicInteger();
    private final ResetHandler resetHandler;

    public RateLimitingSampler(ResetHandler resetHandler) {
        this.resetHandler = resetHandler;
    }

    @Override
    public RateLimitingSampler start() {
        this.resetHandler.start(this);
        return this;
    }

    @Override
    public void close() {
        this.resetHandler.close(this);
    }

    @Override
    public boolean sample() {
        return this.factor.getAndIncrement() < this.rpm;
    }

    @Override
    public RateLimitingSampler reset() {
        this.factor.set(0);
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RateLimitingSampler)) {
            return false;
        }
        RateLimitingSampler other = (RateLimitingSampler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.rpm() == other.rpm();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RateLimitingSampler;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.rpm();
        return result;
    }

    @Generated
    public int rpm() {
        return this.rpm;
    }

    @Generated
    public RateLimitingSampler rpm(int rpm) {
        this.rpm = rpm;
        return this;
    }

    public static class ResetHandler {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(ResetHandler.class);
        private final List<Sampler> samplers = new ArrayList<Sampler>();
        private volatile ScheduledFuture<?> future;
        private volatile boolean started = false;

        private synchronized void start(Sampler sampler) {
            this.samplers.add(sampler);
            if (!this.started) {
                this.future = Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(this::reset, 1L, 1L, TimeUnit.MINUTES);
                this.started = true;
            }
        }

        private synchronized void close(Sampler sampler) {
            this.samplers.remove(sampler);
            if (this.samplers.isEmpty() && this.future != null) {
                this.future.cancel(true);
                this.started = false;
            }
        }

        private synchronized void reset() {
            this.samplers.forEach(sampler -> {
                try {
                    sampler.reset();
                }
                catch (Exception e) {
                    log.error("Failed to reset sampler {}.", sampler, (Object)e);
                }
            });
        }
    }
}

