/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.protobuf.Timestamp;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;
import org.apache.skywalking.banyandb.common.v1.ServiceGrpc;
import org.apache.skywalking.banyandb.database.v1.BanyandbDatabase;
import org.apache.skywalking.banyandb.measure.v1.BanyandbMeasure;
import org.apache.skywalking.banyandb.measure.v1.MeasureServiceGrpc;
import org.apache.skywalking.banyandb.property.v1.BanyandbProperty;
import org.apache.skywalking.banyandb.stream.v1.BanyandbStream;
import org.apache.skywalking.banyandb.stream.v1.StreamServiceGrpc;
import org.apache.skywalking.banyandb.trace.v1.BanyandbTrace;
import org.apache.skywalking.banyandb.trace.v1.TraceServiceGrpc;
import org.apache.skywalking.banyandb.v1.client.MeasureQuery;
import org.apache.skywalking.banyandb.v1.client.MeasureQueryResponse;
import org.apache.skywalking.banyandb.v1.client.MeasureWrite;
import org.apache.skywalking.banyandb.v1.client.Options;
import org.apache.skywalking.banyandb.v1.client.PropertyStore;
import org.apache.skywalking.banyandb.v1.client.StreamQuery;
import org.apache.skywalking.banyandb.v1.client.StreamQueryResponse;
import org.apache.skywalking.banyandb.v1.client.StreamWrite;
import org.apache.skywalking.banyandb.v1.client.TopNQuery;
import org.apache.skywalking.banyandb.v1.client.TopNQueryResponse;
import org.apache.skywalking.banyandb.v1.client.TraceQuery;
import org.apache.skywalking.banyandb.v1.client.TraceQueryResponse;
import org.apache.skywalking.banyandb.v1.client.TraceWrite;
import org.apache.skywalking.banyandb.v1.client.auth.AuthInterceptor;
import org.apache.skywalking.banyandb.v1.client.grpc.HandleExceptionsWith;
import org.apache.skywalking.banyandb.v1.client.grpc.channel.ChannelManager;
import org.apache.skywalking.banyandb.v1.client.grpc.channel.DefaultChannelFactory;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.apache.skywalking.banyandb.v1.client.metadata.GroupMetadataRegistry;
import org.apache.skywalking.banyandb.v1.client.metadata.IndexRuleBindingMetadataRegistry;
import org.apache.skywalking.banyandb.v1.client.metadata.IndexRuleMetadataRegistry;
import org.apache.skywalking.banyandb.v1.client.metadata.MeasureMetadataRegistry;
import org.apache.skywalking.banyandb.v1.client.metadata.MetadataCache;
import org.apache.skywalking.banyandb.v1.client.metadata.PropertyMetadataRegistry;
import org.apache.skywalking.banyandb.v1.client.metadata.ResourceExist;
import org.apache.skywalking.banyandb.v1.client.metadata.StreamMetadataRegistry;
import org.apache.skywalking.banyandb.v1.client.metadata.TopNAggregationMetadataRegistry;
import org.apache.skywalking.banyandb.v1.client.metadata.TraceMetadataRegistry;
import org.apache.skywalking.banyandb.v1.client.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BanyanDBClient
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(BanyanDBClient.class);
    public static final ZonedDateTime DEFAULT_EXPIRE_AT = ZonedDateTime.of(2099, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
    private final String[] targets;
    private final Options options;
    private volatile Channel channel;
    private StreamServiceGrpc.StreamServiceStub streamServiceStub;
    private MeasureServiceGrpc.MeasureServiceStub measureServiceStub;
    private TraceServiceGrpc.TraceServiceStub traceServiceStub;
    private StreamServiceGrpc.StreamServiceBlockingStub streamServiceBlockingStub;
    private MeasureServiceGrpc.MeasureServiceBlockingStub measureServiceBlockingStub;
    private TraceServiceGrpc.TraceServiceBlockingStub traceServiceBlockingStub;
    private volatile boolean isConnected = false;
    private final ReentrantLock connectionEstablishLock;
    private final MetadataCache metadataCache;

    public BanyanDBClient(String ... targets) {
        this(targets, new Options());
    }

    public BanyanDBClient(String[] targets, Options options) {
        String[] tt = (String[])Preconditions.checkNotNull((Object)targets, (Object)"targets");
        Preconditions.checkState((tt.length > 0 ? 1 : 0) != 0, (Object)"targets' size must be more than 1");
        tt = (String[])Arrays.stream(tt).filter(t -> !Strings.isNullOrEmpty((String)t)).toArray(String[]::new);
        Preconditions.checkState((tt.length > 0 ? 1 : 0) != 0, (Object)"valid targets' size must be more than 1");
        this.targets = tt;
        this.options = options;
        this.connectionEstablishLock = new ReentrantLock();
        this.metadataCache = new MetadataCache(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws IOException {
        this.connectionEstablishLock.lock();
        try {
            if (!this.isConnected) {
                ChannelManager rawChannel;
                URI[] addresses = new URI[this.targets.length];
                for (int i = 0; i < this.targets.length; ++i) {
                    addresses[i] = URI.create("//" + this.targets[i]);
                }
                ChannelManager interceptedChannel = rawChannel = ChannelManager.create(this.options.buildChannelManagerSettings(), new DefaultChannelFactory(addresses, this.options));
                String username = this.options.getUsername();
                String password = this.options.getPassword();
                if (!"".equals(username) && !"".equals(password)) {
                    interceptedChannel = ClientInterceptors.intercept((Channel)rawChannel, (ClientInterceptor[])new ClientInterceptor[]{new AuthInterceptor(username, password)});
                }
                this.channel = interceptedChannel;
                this.streamServiceBlockingStub = StreamServiceGrpc.newBlockingStub(this.channel);
                this.measureServiceBlockingStub = MeasureServiceGrpc.newBlockingStub(this.channel);
                this.traceServiceBlockingStub = TraceServiceGrpc.newBlockingStub(this.channel);
                this.streamServiceStub = StreamServiceGrpc.newStub(this.channel);
                this.measureServiceStub = MeasureServiceGrpc.newStub(this.channel);
                this.traceServiceStub = TraceServiceGrpc.newStub(this.channel);
                this.isConnected = true;
            }
        }
        finally {
            this.connectionEstablishLock.unlock();
        }
    }

    @VisibleForTesting
    void connect(Channel channel) {
        this.connectionEstablishLock.lock();
        try {
            if (!this.isConnected) {
                this.channel = channel;
                this.streamServiceBlockingStub = StreamServiceGrpc.newBlockingStub(this.channel);
                this.measureServiceBlockingStub = MeasureServiceGrpc.newBlockingStub(this.channel);
                this.traceServiceBlockingStub = TraceServiceGrpc.newBlockingStub(this.channel);
                this.streamServiceStub = StreamServiceGrpc.newStub(this.channel);
                this.measureServiceStub = MeasureServiceGrpc.newStub(this.channel);
                this.traceServiceStub = TraceServiceGrpc.newStub(this.channel);
                this.isConnected = true;
            }
        }
        finally {
            this.connectionEstablishLock.unlock();
        }
    }

    public MeasureWrite createMeasureWrite(String group, String name, long timestamp) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        return new MeasureWrite(this.metadataCache.findMeasureMetadata(group, name), timestamp);
    }

    public StreamWrite createStreamWrite(String group, String name, String elementId) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        return new StreamWrite(this.metadataCache.findStreamMetadata(group, name), elementId);
    }

    public TraceWrite createTraceWrite(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        return new TraceWrite(this.metadataCache.findTraceMetadata(group, name));
    }

    public StreamQueryResponse query(StreamQuery streamQuery) throws BanyanDBException {
        Preconditions.checkState((this.streamServiceStub != null ? 1 : 0) != 0, (Object)"stream service is null");
        for (String group : streamQuery.groups) {
            MetadataCache.EntityMetadata em = this.metadataCache.findStreamMetadata(group, streamQuery.name);
            if (em == null) continue;
            BanyandbStream.QueryResponse response = HandleExceptionsWith.callAndTranslateApiException(() -> ((StreamServiceGrpc.StreamServiceBlockingStub)this.streamServiceBlockingStub.withDeadlineAfter(this.getOptions().getDeadline(), TimeUnit.SECONDS)).query(streamQuery.build(em)));
            return new StreamQueryResponse(response);
        }
        throw new RuntimeException("No metadata found for the query");
    }

    public TopNQueryResponse query(TopNQuery topNQuery) throws BanyanDBException {
        Preconditions.checkState((this.measureServiceStub != null ? 1 : 0) != 0, (Object)"measure service is null");
        BanyandbMeasure.TopNResponse response = HandleExceptionsWith.callAndTranslateApiException(() -> ((MeasureServiceGrpc.MeasureServiceBlockingStub)this.measureServiceBlockingStub.withDeadlineAfter(this.getOptions().getDeadline(), TimeUnit.SECONDS)).topN(topNQuery.build()));
        return new TopNQueryResponse(response);
    }

    public MeasureQueryResponse query(MeasureQuery measureQuery) throws BanyanDBException {
        Preconditions.checkState((this.streamServiceStub != null ? 1 : 0) != 0, (Object)"measure service is null");
        for (String group : measureQuery.groups) {
            MetadataCache.EntityMetadata em = this.metadataCache.findMeasureMetadata(group, measureQuery.name);
            if (em == null) continue;
            BanyandbMeasure.QueryResponse response = HandleExceptionsWith.callAndTranslateApiException(() -> ((MeasureServiceGrpc.MeasureServiceBlockingStub)this.measureServiceBlockingStub.withDeadlineAfter(this.getOptions().getDeadline(), TimeUnit.SECONDS)).query(measureQuery.build(em)));
            return new MeasureQueryResponse(response);
        }
        throw new RuntimeException("No metadata found for the query");
    }

    public TraceQueryResponse query(TraceQuery traceQuery) throws BanyanDBException {
        Preconditions.checkState((this.traceServiceStub != null ? 1 : 0) != 0, (Object)"trace service is null");
        for (String group : traceQuery.groups) {
            MetadataCache.EntityMetadata em = this.metadataCache.findTraceMetadata(group, traceQuery.name);
            if (em == null) continue;
            BanyandbTrace.QueryResponse response = HandleExceptionsWith.callAndTranslateApiException(() -> ((TraceServiceGrpc.TraceServiceBlockingStub)this.traceServiceBlockingStub.withDeadlineAfter(this.getOptions().getDeadline(), TimeUnit.SECONDS)).query(traceQuery.build(em)));
            return new TraceQueryResponse(response);
        }
        throw new RuntimeException("No metadata found for the query");
    }

    public BanyandbCommon.Group define(BanyandbCommon.Group group) throws BanyanDBException {
        GroupMetadataRegistry registry = new GroupMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        registry.create(group);
        return registry.get(null, group.getMetadata().getName());
    }

    public void define(BanyandbDatabase.Stream stream) throws BanyanDBException {
        StreamMetadataRegistry streamRegistry = new StreamMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        long modRevision = streamRegistry.create(stream);
        stream = stream.toBuilder().setMetadata(stream.getMetadata().toBuilder().setModRevision(modRevision)).build();
        this.metadataCache.register(stream);
    }

    public void define(BanyandbDatabase.Stream stream, List<BanyandbDatabase.IndexRule> indexRules) throws BanyanDBException {
        this.define(stream);
        this.defineIndexRules(stream, indexRules);
    }

    public void define(BanyandbDatabase.Measure measure) throws BanyanDBException {
        MeasureMetadataRegistry measureRegistry = new MeasureMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        long modRevision = measureRegistry.create(measure);
        measure = measure.toBuilder().setMetadata(measure.getMetadata().toBuilder().setModRevision(modRevision)).build();
        this.metadataCache.register(measure);
    }

    public void define(BanyandbDatabase.Measure measure, List<BanyandbDatabase.IndexRule> indexRules) throws BanyanDBException {
        this.define(measure);
        this.defineIndexRules(measure, indexRules);
    }

    public void define(BanyandbDatabase.TopNAggregation topNAggregation) throws BanyanDBException {
        TopNAggregationMetadataRegistry registry = new TopNAggregationMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        registry.create(topNAggregation);
    }

    public void define(BanyandbDatabase.IndexRule indexRule) throws BanyanDBException {
        IndexRuleMetadataRegistry registry = new IndexRuleMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        registry.create(indexRule);
    }

    public void define(BanyandbDatabase.IndexRuleBinding indexRuleBinding) throws BanyanDBException {
        ZonedDateTime beginAt = indexRuleBinding.getBeginAt() == Timestamp.getDefaultInstance() ? ZonedDateTime.now() : TimeUtils.parseTimestamp(indexRuleBinding.getBeginAt());
        ZonedDateTime expireAt = indexRuleBinding.getExpireAt() == Timestamp.getDefaultInstance() ? DEFAULT_EXPIRE_AT : TimeUtils.parseTimestamp(indexRuleBinding.getExpireAt());
        this.define(indexRuleBinding, beginAt, expireAt);
    }

    public void define(BanyandbDatabase.IndexRuleBinding indexRuleBinding, ZonedDateTime beginAt, ZonedDateTime expireAt) throws BanyanDBException {
        IndexRuleBindingMetadataRegistry registry = new IndexRuleBindingMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        indexRuleBinding = indexRuleBinding.toBuilder().setBeginAt(TimeUtils.buildTimestamp(beginAt)).setExpireAt(TimeUtils.buildTimestamp(expireAt)).build();
        registry.create(indexRuleBinding);
    }

    public void defineIndexRules(BanyandbDatabase.Stream stream, List<BanyandbDatabase.IndexRule> indexRules) throws BanyanDBException {
        Preconditions.checkArgument((stream != null ? 1 : 0) != 0, (Object)"stream cannot be null");
        IndexRuleMetadataRegistry irRegistry = new IndexRuleMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        for (BanyandbDatabase.IndexRule ir : indexRules) {
            try {
                irRegistry.create(ir);
            }
            catch (BanyanDBException ex) {
                if (ex.getStatus().equals((Object)Status.Code.ALREADY_EXISTS)) continue;
                throw ex;
            }
        }
        if (indexRules.isEmpty()) {
            return;
        }
        List<String> indexRuleNames = indexRules.stream().map(indexRule -> indexRule.getMetadata().getName()).collect(Collectors.toList());
        BanyandbDatabase.IndexRuleBinding binding = BanyandbDatabase.IndexRuleBinding.newBuilder().setMetadata(BanyandbCommon.Metadata.newBuilder().setGroup(stream.getMetadata().getGroup()).setName(stream.getMetadata().getName())).setSubject(BanyandbDatabase.Subject.newBuilder().setName(stream.getMetadata().getName()).setCatalog(BanyandbCommon.Catalog.CATALOG_STREAM)).addAllRules(indexRuleNames).build();
        this.define(binding);
    }

    public void defineIndexRules(BanyandbDatabase.Measure measure, List<BanyandbDatabase.IndexRule> indexRules) throws BanyanDBException {
        Preconditions.checkArgument((measure != null ? 1 : 0) != 0, (Object)"measure cannot be null");
        IndexRuleMetadataRegistry irRegistry = new IndexRuleMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        for (BanyandbDatabase.IndexRule ir : indexRules) {
            try {
                irRegistry.create(ir);
            }
            catch (BanyanDBException ex) {
                if (ex.getStatus().equals((Object)Status.Code.ALREADY_EXISTS)) continue;
                throw ex;
            }
        }
        if (indexRules.isEmpty()) {
            return;
        }
        List<String> indexRuleNames = indexRules.stream().map(indexRule -> indexRule.getMetadata().getName()).collect(Collectors.toList());
        BanyandbDatabase.IndexRuleBinding binding = BanyandbDatabase.IndexRuleBinding.newBuilder().setMetadata(BanyandbCommon.Metadata.newBuilder().setGroup(measure.getMetadata().getGroup()).setName(measure.getMetadata().getName())).setSubject(BanyandbDatabase.Subject.newBuilder().setName(measure.getMetadata().getName()).setCatalog(BanyandbCommon.Catalog.CATALOG_MEASURE)).addAllRules(indexRuleNames).build();
        this.define(binding);
    }

    public void update(BanyandbCommon.Group group) throws BanyanDBException {
        GroupMetadataRegistry registry = new GroupMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        registry.update(group);
    }

    public void update(BanyandbDatabase.Stream stream) throws BanyanDBException {
        StreamMetadataRegistry streamRegistry = new StreamMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        streamRegistry.update(stream);
        this.metadataCache.register(stream);
    }

    public void update(BanyandbDatabase.Measure measure) throws BanyanDBException {
        MeasureMetadataRegistry measureRegistry = new MeasureMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        measureRegistry.update(measure);
        this.metadataCache.register(measure);
    }

    public void update(BanyandbDatabase.TopNAggregation topNAggregation) throws BanyanDBException {
        TopNAggregationMetadataRegistry registry = new TopNAggregationMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        registry.update(topNAggregation);
    }

    public void update(BanyandbDatabase.IndexRule indexRule) throws BanyanDBException {
        IndexRuleMetadataRegistry registry = new IndexRuleMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        registry.update(indexRule);
    }

    public void update(BanyandbDatabase.IndexRuleBinding indexRuleBinding) throws BanyanDBException {
        IndexRuleBindingMetadataRegistry registry = new IndexRuleBindingMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        registry.update(indexRuleBinding);
    }

    public boolean deleteGroup(String name) throws BanyanDBException {
        GroupMetadataRegistry registry = new GroupMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        return registry.delete(name, name);
    }

    public boolean deleteStream(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        StreamMetadataRegistry streamRegistry = new StreamMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        if (streamRegistry.delete(group, name)) {
            this.metadataCache.unregister(group, name);
            return true;
        }
        return false;
    }

    public boolean deleteMeasure(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        MeasureMetadataRegistry measureRegistry = new MeasureMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        if (measureRegistry.delete(group, name)) {
            this.metadataCache.unregister(group, name);
            return true;
        }
        return false;
    }

    public boolean deleteTopNAggregation(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        TopNAggregationMetadataRegistry registry = new TopNAggregationMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        return registry.delete(group, name);
    }

    public boolean deleteIndexRule(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        IndexRuleMetadataRegistry registry = new IndexRuleMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        return registry.delete(group, name);
    }

    public boolean deleteIndexRuleBinding(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        IndexRuleBindingMetadataRegistry registry = new IndexRuleBindingMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        return registry.delete(group, name);
    }

    public BanyandbDatabase.IndexRule findIndexRule(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        IndexRuleMetadataRegistry registry = new IndexRuleMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        try {
            return registry.get(group, name);
        }
        catch (BanyanDBException ex) {
            if (ex.getStatus().equals((Object)Status.Code.NOT_FOUND)) {
                return null;
            }
            throw ex;
        }
    }

    public List<BanyandbDatabase.IndexRule> findIndexRules(String group) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        IndexRuleMetadataRegistry registry = new IndexRuleMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        return registry.list(group);
    }

    public BanyandbDatabase.IndexRuleBinding findIndexRuleBinding(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        IndexRuleBindingMetadataRegistry registry = new IndexRuleBindingMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        try {
            return registry.get(group, name);
        }
        catch (BanyanDBException ex) {
            if (ex.getStatus().equals((Object)Status.Code.NOT_FOUND)) {
                return null;
            }
            throw ex;
        }
    }

    public List<BanyandbDatabase.IndexRuleBinding> findIndexRuleBindings(String group) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        IndexRuleBindingMetadataRegistry registry = new IndexRuleBindingMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        return registry.list(group);
    }

    public void define(BanyandbDatabase.Property property) throws BanyanDBException {
        PropertyMetadataRegistry registry = new PropertyMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        registry.create(property);
    }

    public void update(BanyandbDatabase.Property property) throws BanyanDBException {
        PropertyMetadataRegistry registry = new PropertyMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        registry.update(property);
    }

    public BanyandbDatabase.Property findPropertyDefinition(String group, String name) throws BanyanDBException {
        PropertyMetadataRegistry registry = new PropertyMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        return registry.get(group, name);
    }

    public List<BanyandbDatabase.Property> findPropertiesDefinition(String group) throws BanyanDBException {
        PropertyMetadataRegistry registry = new PropertyMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        return registry.list(group);
    }

    public boolean deletePropertyDefinition(String group, String name) throws BanyanDBException {
        PropertyMetadataRegistry registry = new PropertyMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        return registry.delete(group, name);
    }

    public BanyandbProperty.QueryResponse query(BanyandbProperty.QueryRequest request) throws BanyanDBException {
        PropertyStore store = new PropertyStore((Channel)Preconditions.checkNotNull((Object)this.channel));
        return store.query(request);
    }

    public void define(BanyandbDatabase.Trace trace) throws BanyanDBException {
        TraceMetadataRegistry registry = new TraceMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        registry.create(trace);
    }

    public void update(BanyandbDatabase.Trace trace) throws BanyanDBException {
        TraceMetadataRegistry registry = new TraceMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        registry.update(trace);
    }

    public BanyandbDatabase.Trace findTrace(String group, String name) throws BanyanDBException {
        try {
            return new TraceMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel)).get(group, name);
        }
        catch (BanyanDBException ex) {
            if (ex.getStatus().equals((Object)Status.Code.NOT_FOUND)) {
                return null;
            }
            throw ex;
        }
    }

    public List<BanyandbDatabase.Trace> findTraces(String group) throws BanyanDBException {
        TraceMetadataRegistry registry = new TraceMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        return registry.list(group);
    }

    public boolean deleteTrace(String group, String name) throws BanyanDBException {
        TraceMetadataRegistry registry = new TraceMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        return registry.delete(group, name);
    }

    public BanyandbCommon.Group findGroup(String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        try {
            return new GroupMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel)).get(name, name);
        }
        catch (BanyanDBException ex) {
            if (ex.getStatus().equals((Object)Status.Code.NOT_FOUND)) {
                return null;
            }
            throw ex;
        }
    }

    public List<BanyandbCommon.Group> findGroups() throws BanyanDBException {
        return new GroupMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel)).list("");
    }

    public BanyandbDatabase.TopNAggregation findTopNAggregation(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        try {
            return new TopNAggregationMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel)).get(group, name);
        }
        catch (BanyanDBException ex) {
            if (ex.getStatus().equals((Object)Status.Code.NOT_FOUND)) {
                return null;
            }
            throw ex;
        }
    }

    public List<BanyandbDatabase.TopNAggregation> findTopNAggregations(String group) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        return new TopNAggregationMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel)).list(group);
    }

    public BanyandbDatabase.Stream findStream(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        try {
            return new StreamMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel)).get(group, name);
        }
        catch (BanyanDBException ex) {
            if (ex.getStatus().equals((Object)Status.Code.NOT_FOUND)) {
                return null;
            }
            throw ex;
        }
    }

    public List<BanyandbDatabase.Stream> findStreams(String group) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        StreamMetadataRegistry registry = new StreamMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        return registry.list(group);
    }

    public BanyandbDatabase.Measure findMeasure(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        try {
            return new MeasureMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel)).get(group, name);
        }
        catch (BanyanDBException ex) {
            if (ex.getStatus().equals((Object)Status.Code.NOT_FOUND)) {
                return null;
            }
            throw ex;
        }
    }

    public List<BanyandbDatabase.Measure> findMeasures(String group) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        MeasureMetadataRegistry registry = new MeasureMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        return registry.list(group);
    }

    private List<BanyandbDatabase.IndexRule> findIndexRulesByGroupAndBindingName(String group, String bindingName) throws BanyanDBException {
        BanyandbDatabase.IndexRuleBinding irb;
        IndexRuleBindingMetadataRegistry irbRegistry = new IndexRuleBindingMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        try {
            irb = irbRegistry.get(group, bindingName);
        }
        catch (BanyanDBException ex) {
            if (ex.getStatus().equals((Object)Status.Code.NOT_FOUND)) {
                return Collections.emptyList();
            }
            throw ex;
        }
        if (irb == null) {
            return Collections.emptyList();
        }
        ArrayList<BanyandbDatabase.IndexRule> indexRules = new ArrayList<BanyandbDatabase.IndexRule>(irb.getRulesList().size());
        return indexRules;
    }

    public ResourceExist existStream(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        return new StreamMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel)).exist(group, name);
    }

    public ResourceExist existMeasure(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        return new MeasureMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel)).exist(group, name);
    }

    public ResourceExist existTopNAggregation(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        return new TopNAggregationMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel)).exist(group, name);
    }

    public ResourceExist existProperty(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        return new PropertyMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel)).exist(group, name);
    }

    public ResourceExist existTrace(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        return new TraceMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel)).exist(group, name);
    }

    public MetadataCache.EntityMetadata updateStreamMetadataCacheFromSever(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        return this.metadataCache.updateStreamFromSever(group, name);
    }

    public MetadataCache.EntityMetadata updateMeasureMetadataCacheFromSever(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        return this.metadataCache.updateMeasureFromSever(group, name);
    }

    public MetadataCache.EntityMetadata updateTraceMetadataCacheFromServer(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        return this.metadataCache.updateTraceFromServer(group, name);
    }

    public BanyandbCommon.APIVersion getAPIVersion() throws BanyanDBException {
        ServiceGrpc.ServiceBlockingStub stub = ServiceGrpc.newBlockingStub(this.channel);
        return HandleExceptionsWith.callAndTranslateApiException(() -> {
            BanyandbCommon.GetAPIVersionResponse resp = stub.getAPIVersion(BanyandbCommon.GetAPIVersionRequest.getDefaultInstance());
            return resp.getVersion();
        });
    }

    @Override
    public void close() throws IOException {
        this.connectionEstablishLock.lock();
        if (!(this.channel instanceof ManagedChannel)) {
            return;
        }
        ManagedChannel managedChannel = (ManagedChannel)this.channel;
        try {
            if (this.isConnected) {
                managedChannel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
                this.isConnected = false;
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            log.warn("fail to wait for channel termination, shutdown now!", (Throwable)interruptedException);
            managedChannel.shutdownNow();
            this.isConnected = false;
        }
        finally {
            this.connectionEstablishLock.unlock();
        }
    }

    public Options getOptions() {
        return this.options;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public StreamServiceGrpc.StreamServiceStub getStreamServiceStub() {
        return this.streamServiceStub;
    }

    public MeasureServiceGrpc.MeasureServiceStub getMeasureServiceStub() {
        return this.measureServiceStub;
    }

    public TraceServiceGrpc.TraceServiceStub getTraceServiceStub() {
        return this.traceServiceStub;
    }

    public StreamServiceGrpc.StreamServiceBlockingStub getStreamServiceBlockingStub() {
        return this.streamServiceBlockingStub;
    }

    public MeasureServiceGrpc.MeasureServiceBlockingStub getMeasureServiceBlockingStub() {
        return this.measureServiceBlockingStub;
    }

    public TraceServiceGrpc.TraceServiceBlockingStub getTraceServiceBlockingStub() {
        return this.traceServiceBlockingStub;
    }
}

